/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import com.google.common.collect.Iterables;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import java.util.function.Predicate;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class BaublesHelper {
    public static boolean doesPlayerWearBauble(EntityPlayer player, BaubleType inType, Predicate<ItemStack> predicate) {
        for (ItemStack worn : BaublesHelper.getWornBaublesForType(player, inType)) {
            if (!predicate.test(worn)) continue;
            return true;
        }
        return false;
    }

    public static boolean doesPlayerWearBauble(EntityPlayer player, BaubleType inType, ItemStack expected, boolean strict) {
        for (ItemStack worn : BaublesHelper.getWornBaublesForType(player, inType)) {
            if (!(strict ? ItemUtils.matchStacks(worn, expected) : ItemUtils.matchStackLoosely(worn, expected))) continue;
            return true;
        }
        return false;
    }

    public static Iterable<ItemStack> getWornBaublesForType(EntityPlayer player, BaubleType type) {
        IBaublesItemHandler handler = BaublesApi.getBaublesHandler((EntityPlayer)player);
        NonNullList worn = NonNullList.func_191196_a();
        for (int slot : type.getValidSlots()) {
            ItemStack stack = handler.getStackInSlot(slot);
            if (stack.func_190926_b()) continue;
            worn.add(stack);
        }
        return worn;
    }

    public static ItemStack getFirstWornBaublesForType(EntityPlayer player, BaubleType type) {
        return (ItemStack)Iterables.getFirst(BaublesHelper.getWornBaublesForType(player, type), (Object)ItemStack.field_190927_a);
    }
}

