/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.common.auxiliary.link.ILinkableTile;
import hellfirepvp.astralsorcery.common.lib.MultiBlockArrays;
import hellfirepvp.astralsorcery.common.structure.array.BlockArray;
import hellfirepvp.astralsorcery.common.structure.array.PatternBlockArray;
import hellfirepvp.astralsorcery.common.tile.IMultiblockDependantTile;
import hellfirepvp.astralsorcery.common.tile.base.TileEntityTick;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileRitualLink
extends TileEntityTick
implements ILinkableTile,
IMultiblockDependantTile {
    private static PatternBlockArray previewPatternCopy = null;
    private BlockPos linkedTo = null;

    @Override
    public void func_73660_a() {
        TileRitualLink link;
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            this.playClientEffects();
        } else if (this.linkedTo != null && MiscUtils.isChunkLoaded(this.field_145850_b, new ChunkPos(this.linkedTo)) && (link = MiscUtils.getTileAt((IBlockAccess)this.field_145850_b, this.linkedTo, TileRitualLink.class, true)) == null) {
            this.linkedTo = null;
            this.markForUpdate();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playClientEffects() {
        if (this.linkedTo != null && Minecraft.func_71410_x().field_71439_g.func_174818_b(this.func_174877_v()) < 1024.0) {
            if (this.ticksExisted % 4 == 0) {
                List<Vector3> positions = MiscUtils.getCirclePositions(new Vector3(this).add(0.5, 0.5, 0.5), Vector3.RotAxis.Y_AXIS, 0.4f - rand.nextFloat() * 0.1f, 10 + rand.nextInt(10));
                for (Vector3 v : positions) {
                    EntityFXFacingParticle particle = EffectHelper.genericFlareParticle(v.getX(), v.getY(), v.getZ());
                    particle.gravity(0.004).scale(0.15f);
                    particle.motion(0.0, (double)((float)(rand.nextBoolean() ? 1 : -1) * rand.nextFloat()) * 0.01, 0.0);
                    if (!rand.nextBoolean()) continue;
                    particle.setColor(Color.WHITE);
                }
            }
            Vector3 v = new Vector3(this).add(0.5, 0.5, 0.5);
            EntityFXFacingParticle particle = EffectHelper.genericFlareParticle(v.getX(), v.getY(), v.getZ());
            particle.gravity(0.004).scale(0.3f);
            particle.motion(0.0, (double)((float)(rand.nextBoolean() ? 1 : -1) * rand.nextFloat()) * 0.015, 0.0);
            particle.setColor(Color.getHSBColor(rand.nextFloat() * 360.0f, 1.0f, 1.0f));
        }
    }

    public BlockPos getLinkedTo() {
        return this.linkedTo;
    }

    public void updateLink(@Nullable BlockPos link) {
        this.linkedTo = link;
        this.markForUpdate();
    }

    @Override
    protected void onFirstTick() {
    }

    @Override
    @Nullable
    public PatternBlockArray getRequiredStructure() {
        if (previewPatternCopy == null) {
            previewPatternCopy = new PatternBlockArray(MultiBlockArrays.patternRitualPedestalWithLink.getRegistryName());
            MultiBlockArrays.patternRitualPedestalWithLink.getPattern().forEach((pos, info) -> previewPatternCopy.addBlock(pos.func_177979_c(5), info.state, info.matcher));
            MultiBlockArrays.patternRitualPedestalWithLink.getTileCallbacks().forEach((pos, callback) -> previewPatternCopy.addTileCallback(pos.func_177979_c(5), (BlockArray.TileEntityCallback)callback));
        }
        return previewPatternCopy;
    }

    @Override
    @Nonnull
    public BlockPos getLocationPos() {
        return this.func_174877_v();
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.linkedTo = compound.func_74764_b("posLink") ? NBTHelper.readBlockPosFromNBT(compound.func_74775_l("posLink")) : null;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        if (this.linkedTo != null) {
            NBTTagCompound tag = new NBTTagCompound();
            NBTHelper.writeBlockPosToNBT(this.linkedTo, tag);
            compound.func_74782_a("posLink", (NBTBase)tag);
        }
    }

    @Override
    public World getLinkWorld() {
        return this.func_145831_w();
    }

    @Override
    public BlockPos getLinkPos() {
        return this.func_174877_v();
    }

    @Override
    @Nullable
    public String getUnLocalizedDisplayName() {
        return "tile.blockrituallink.name";
    }

    @Override
    public void onLinkCreate(EntityPlayer player, BlockPos other) {
        this.linkedTo = other;
        TileRitualLink otherLink = MiscUtils.getTileAt((IBlockAccess)player.func_130014_f_(), other, TileRitualLink.class, true);
        if (otherLink != null) {
            otherLink.linkedTo = this.func_174877_v();
            otherLink.markForUpdate();
        }
        this.markForUpdate();
    }

    @Override
    public boolean tryLink(EntityPlayer player, BlockPos other) {
        TileRitualLink otherLink = MiscUtils.getTileAt((IBlockAccess)player.func_130014_f_(), other, TileRitualLink.class, true);
        return otherLink != null && otherLink.linkedTo == null && !other.equals((Object)this.func_174877_v());
    }

    @Override
    public boolean tryUnlink(EntityPlayer player, BlockPos other) {
        TileRitualLink otherLink = MiscUtils.getTileAt((IBlockAccess)player.func_130014_f_(), other, TileRitualLink.class, true);
        if (otherLink == null || otherLink.linkedTo == null) {
            return false;
        }
        if (otherLink.linkedTo.equals((Object)this.func_174877_v())) {
            this.linkedTo = null;
            otherLink.linkedTo = null;
            otherLink.markForUpdate();
            this.markForUpdate();
            return true;
        }
        return false;
    }

    @Override
    public List<BlockPos> getLinkedPositions() {
        return this.linkedTo != null ? Lists.newArrayList((Object[])new BlockPos[]{this.linkedTo}) : Lists.newArrayList();
    }
}

