/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.render.tile;

import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.render.tile.TESRCollectorCrystal;
import hellfirepvp.astralsorcery.client.util.ItemColorizationHelper;
import hellfirepvp.astralsorcery.client.util.RenderConstellation;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.TextureHelper;
import hellfirepvp.astralsorcery.common.block.network.BlockCollectorCrystalBase;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.distribution.ConstellationSkyHandler;
import hellfirepvp.astralsorcery.common.crafting.ItemHandle;
import hellfirepvp.astralsorcery.common.crafting.altar.ActiveCraftingTask;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.TraitRecipe;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.GL11;

public class TESRAltar
extends TileEntitySpecialRenderer<TileAltar> {
    public void render(TileAltar te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        switch (te.getAltarLevel()) {
            case TRAIT_CRAFT: {
                if (!te.getMultiblockState()) break;
                IConstellation c = te.getFocusedConstellation();
                if (c != null) {
                    GL11.glPushMatrix();
                    float alphaDaytime = ConstellationSkyHandler.getInstance().getCurrentDaytimeDistribution(te.func_145831_w());
                    alphaDaytime *= 0.8f;
                    int max = 5000;
                    int t = (int)(ClientScheduler.getClientTick() % (long)max);
                    float halfAge = (float)max / 2.0f;
                    float tr = 1.0f - Math.abs(halfAge - (float)t) / halfAge;
                    RenderingUtils.removeStandartTranslationFromTESRMatrix(partialTicks);
                    float br = 0.9f * alphaDaytime;
                    RenderConstellation.renderConstellationIntoWorldFlat(c, c.getConstellationColor(), new Vector3(te).add(0.5, 0.03, 0.5), 5.0f + (tr *= 2.0f), 2.0, 0.1f + br);
                    GL11.glPopMatrix();
                }
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 4.0), (double)(z + 0.5));
                ActiveCraftingTask act = te.getActiveCraftingTask();
                if (act != null && act.getRecipeToCraft() instanceof TraitRecipe) {
                    List<ItemHandle> requiredHandles = ((TraitRecipe)act.getRecipeToCraft()).getTraitItemHandles();
                    if (!requiredHandles.isEmpty()) {
                        int amt = 60 / requiredHandles.size();
                        for (ItemHandle outer : requiredHandles) {
                            NonNullList<ItemStack> stacksApplicable = outer.getApplicableItemsForRender();
                            int mod = (int)(ClientScheduler.getClientTick() % (long)(stacksApplicable.size() * 60));
                            ItemStack element = (ItemStack)stacksApplicable.get(MathHelper.func_76141_d((float)MathHelper.func_76125_a((int)(stacksApplicable.size() * (mod / (stacksApplicable.size() * 60))), (int)0, (int)(stacksApplicable.size() - 1))));
                            Color col = ItemColorizationHelper.getDominantColorFromItemStack(element);
                            if (col == null) {
                                col = BlockCollectorCrystalBase.CollectorCrystalType.CELESTIAL_CRYSTAL.displayColor;
                            }
                            RenderingUtils.renderLightRayEffects(0.0, 0.5, 0.0, col, 0x12315L | (long)outer.hashCode(), ClientScheduler.getClientTick(), 20, 2.0f, amt, amt / 2);
                        }
                    }
                    RenderingUtils.renderLightRayEffects(0.0, 0.5, 0.0, Color.WHITE, 0L, ClientScheduler.getClientTick(), 15, 2.0f, 40, 25);
                } else {
                    RenderingUtils.renderLightRayEffects(0.0, 0.5, 0.0, Color.WHITE, 305223265L, ClientScheduler.getClientTick(), 20, 2.0f, 50, 25);
                    RenderingUtils.renderLightRayEffects(0.0, 0.5, 0.0, Color.BLUE, 0L, ClientScheduler.getClientTick(), 10, 1.0f, 40, 25);
                }
                GlStateManager.func_179137_b((double)0.0, (double)0.15, (double)0.0);
                GlStateManager.func_179139_a((double)0.7, (double)0.7, (double)0.7);
                TESRCollectorCrystal.renderCrystal(true, true);
                GlStateManager.func_179121_F();
                TextureHelper.refreshTextureBindState();
                break;
            }
        }
        ActiveCraftingTask task = te.getActiveCraftingTask();
        if (task != null) {
            task.getRecipeToCraft().onCraftTESRRender(te, x, y, z, partialTicks);
        }
    }
}

