/*
 * Decompiled with CFR 0.152.
 */
package binnie.design;

import binnie.core.util.I18N;
import binnie.design.Design;
import binnie.design.EnumPattern;
import binnie.design.Layout;
import binnie.design.api.IDesign;
import binnie.design.api.IDesignCategory;
import binnie.design.api.ILayout;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;

public enum EnumDesign implements IDesign
{
    Blank("blank"),
    Octagon("octagon", EnumPattern.Octagon.layout()),
    Diamond("diamond", EnumPattern.Diamond.layout()),
    Ringed("ringed", EnumPattern.Ringed.layout()),
    Squared("squared", EnumPattern.Squared.layout()),
    Multiply("multiply", EnumPattern.Multiply.layout()),
    Halved("halved"),
    Striped("striped"),
    ThinStriped("thin.striped"),
    Chequered("full.chequered", EnumPattern.Chequered.layout()),
    Tiled("full.tiled", EnumPattern.Tiled.layout()),
    ChequeredB("chequered", EnumPattern.Chequered.layout()),
    TiledB("tiled", EnumPattern.Tiled.layout()),
    VeryThinCorner("very.thin.cornered"),
    ThinCorner("thin.cornered"),
    Corner("cornered"),
    ThickCorner("thick.cornered"),
    Edged("edged", EnumPattern.Edged.layout()),
    ThinEdged("thin.edged", EnumPattern.ThinEdged.layout()),
    ThinBarred("thin.barred", EnumPattern.ThinBarred.layout()),
    Barred("barred", EnumPattern.Barred.layout()),
    ThickBarred("thick.barred", EnumPattern.ThickBarred.layout()),
    Diagonal("diagonal", EnumPattern.Edged.layout()),
    ThickDiagonal("thick.diagonal", EnumPattern.Halved.layout()),
    ThinSaltire("thin.saltire"),
    Saltire("saltire"),
    ThickSaltire("thick.saltire"),
    ThinCrossed("thin.crossed"),
    Crossed("crossed"),
    ThickCrossed("thick.crossed"),
    ThinTSection("thin.t.section"),
    TSection("t.section"),
    ThickTSection("thick.t.section"),
    ThinBarredCorner("thin.barred.corner"),
    BarredCorner("barred.corner"),
    ThickBarredCorner("thick.barred.corner"),
    ThinStripedCorner("thin.striped.corner"),
    StripedCorner("striped.corner"),
    Emblem1("emblem.1", EnumPattern.Emblem1.layout()),
    Emblem2("emblem.2", EnumPattern.Emblem2.layout()),
    Emblem3("emblem.3", EnumPattern.Emblem3.layout()),
    Emblem4("emblem.4", EnumPattern.Emblem4.layout()),
    Emblem5("emblem.5", EnumPattern.Emblem5.layout()),
    LetterA("letter.a", true),
    LetterB("letter.b", true),
    LetterC("letter.c"),
    LetterD("letter.d"),
    LetterE("letter.e"),
    LetterF("letter.f", true),
    LetterG("letter.g"),
    LetterH("letter.h"),
    LetterI("letter.i"),
    LetterJ("letter.j"),
    LetterK("letter.k"),
    LetterL("letter.l"),
    LetterM("letter.m"),
    LetterN("letter.n"),
    LetterO("letter.o"),
    LetterP("letter.p"),
    LetterQ("letter.q"),
    LetterR("letter.r"),
    LetterS("letter.s", true),
    LetterT("letter.t", true),
    LetterU("letter.u"),
    LetterV("letter.v"),
    LetterW("letter.w"),
    LetterX("letter.x"),
    LetterY("letter.y"),
    LetterZ("letter.z"),
    ThinCurvedCrossed("thin.curved.crossed"),
    ThinCurvedBarredCorner("thin.curved.barred.corner"),
    CurvedBarredCorner("curved.barred.corner"),
    ThinCurvedCorner("thin.curved.corner"),
    CurvedCorner("curved.corner"),
    ThinCurvedTSection("thin.curved.t.section"),
    CurvedTSection("curved.t.section"),
    BarredEnd("barred.end", true),
    DiagonalCorner("diagonal.corner", true),
    DiagonalTSection("diagonal.t.section"),
    DiagonalCurvedCorner("diagonal.curved.corner", true),
    DiagonalCurvedTSection("diagonal.curved.t.section"),
    OrnateBarred("ornate.barred", EnumPattern.OrnateBarred.layout()),
    SplitBarred("split.barred", EnumPattern.SplitBarred.layout()),
    SplitBarredCorner("split.barred.corner"),
    SplitBarredTSection("split.barred.t.section"),
    SplitCrossed("split.crossed"),
    SplitBarredEnd("split.barred.end", true),
    OrnateThinBarred("ornate.thin.barred", EnumPattern.OrnateThinBarred.layout()),
    Circle("circle", EnumPattern.Circle.layout()),
    Plus("plus", EnumPattern.Plus.layout()),
    Creeper("creeper", true),
    OrnateStripedCorner("ornate.striped.corner"),
    Test("testing.block"),
    DiagonalHalved("diagonal.halved"),
    Diagonal1Edged("cornered.diagonal"),
    Diagonal2Edged("opposite.cornered.diagonal"),
    ThickDiagonal1Edged("thick.cornered.diagonal"),
    ThinBarredEnd("thin.barred.end", true),
    ThickBarredEnd("thick.barred.end", true),
    OverlappedBarred("overlapped.barred", EnumPattern.Barred.layout()),
    OverlappedSplitBarred("overlapped.split.barred", EnumPattern.SplitBarred.layout());

    private String name;
    private ILayout topPattern;
    private ILayout bottomPattern;
    private ILayout northPattern;
    private ILayout southPattern;
    private ILayout eastPattern;
    private ILayout westPattern;

    private EnumDesign(String name) {
        this(name, false);
    }

    private EnumDesign(String name, boolean inverted) {
        this(name, Layout.get(EnumPattern.Blank, inverted));
    }

    private EnumDesign(String name, ILayout fillLayout) {
        this.topPattern = fillLayout;
        this.bottomPattern = fillLayout;
        this.northPattern = fillLayout;
        this.eastPattern = fillLayout;
        this.southPattern = fillLayout;
        this.westPattern = fillLayout;
        this.name = name;
    }

    void setEdgePatterns(ILayout north, ILayout east, ILayout south, ILayout west) {
        this.setNorthPattern(north);
        this.setEastPattern(east);
        this.setSouthPattern(south);
        this.setWestPattern(west);
    }

    void setEdgePatterns(ILayout face) {
        this.setEdgePatterns(face, face, face, face);
    }

    void setupStriped(ILayout vert) {
        this.setTopAndBottomPattern(vert);
        this.setEdgePatterns(vert.invert(), EnumPattern.Blank.layout(true), vert, EnumPattern.Blank.layout());
    }

    void setChequered(ILayout cheq) {
        this.setNorthPattern(cheq.invert());
        this.setSouthPattern(cheq.invert());
        this.setBottomPattern(cheq.invert());
    }

    void setStripedChequered(ILayout stripe) {
        this.setNorthPattern(stripe.invert());
        this.setSouthPattern(stripe.invert());
        this.setEastPattern(stripe);
        this.setWestPattern(stripe);
    }

    void setCornered(ILayout corner, ILayout edge) {
        this.setTopAndBottomPattern(corner);
        this.setNorthPattern(EnumPattern.Blank.layout());
        this.setEastPattern(edge.flipHorizontal());
        this.setSouthPattern(edge);
        this.setWestPattern(EnumPattern.Blank.layout());
    }

    void setEdged() {
        this.setWestPattern(EnumPattern.Blank.layout());
        this.setEastPattern(EnumPattern.Blank.layout(true));
        this.northPattern = this.northPattern.flipHorizontal();
    }

    void setBarred() {
        this.setEastPattern(EnumPattern.Blank.layout(true));
        this.setWestPattern(EnumPattern.Blank.layout(true));
    }

    void setDiagonal(ILayout diagonal) {
        this.setTopAndBottomPattern(diagonal);
        this.northPattern = this.northPattern.flipHorizontal();
        this.southPattern = this.southPattern.flipHorizontal();
    }

    void setSaltire(ILayout saltire, ILayout bar) {
        this.setTopAndBottomPattern(saltire);
        this.setEdgePatterns(bar.invert());
    }

    void setCross(ILayout saltire, ILayout bar) {
        this.setTopAndBottomPattern(saltire);
        this.setEdgePatterns(bar);
    }

    void setTSection(ILayout tsection, ILayout bar) {
        this.setTopAndBottomPattern(tsection);
        this.setEdgePatterns(bar, bar, bar, EnumPattern.Blank.layout(true));
    }

    void setBarredCorner(ILayout corner, ILayout bar) {
        this.setTSection(corner, bar);
        this.setNorthPattern(EnumPattern.Blank.layout(true));
    }

    void setStripedCorner(ILayout corner, ILayout striped) {
        this.setCornered(corner, striped);
    }

    void setLetterPattern(ILayout letter) {
        this.setTopPattern(letter);
        this.setBottomPattern(EnumPattern.Blank.layout(true));
    }

    void setBarredEndPattern(ILayout end, ILayout bar) {
        this.setTopAndBottomPattern(end);
        this.setWestPattern(bar);
    }

    void setDiagonalCorner(ILayout diagonal, ILayout bar, ILayout edged) {
        this.setTopAndBottomPattern(diagonal);
        this.setWestPattern(bar.invert());
        this.setNorthPattern(edged.flipHorizontal());
        this.setSouthPattern(edged);
    }

    void setDiagonalTSection(ILayout diagonal, ILayout bar, ILayout edged) {
        this.setTopAndBottomPattern(diagonal);
        this.setWestPattern(bar.invert());
        this.setNorthPattern(bar.invert());
        this.setEastPattern(edged.flipHorizontal());
        this.setSouthPattern(edged);
    }

    @Override
    public String getName() {
        return I18N.localise(new ResourceLocation("binniedesign", "pattern." + this.name));
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public ILayout getTopPattern() {
        return this.topPattern;
    }

    public void setTopPattern(ILayout layout) {
        this.topPattern = layout;
    }

    public void setTopAndBottomPattern(ILayout layout) {
        this.topPattern = layout;
        this.setBottomPattern(layout.flipVertical());
    }

    @Override
    public ILayout getBottomPattern() {
        return this.bottomPattern;
    }

    public void setBottomPattern(ILayout layout) {
        this.bottomPattern = layout;
    }

    @Override
    public ILayout getNorthPattern() {
        return this.northPattern;
    }

    public void setNorthPattern(ILayout layout) {
        this.northPattern = layout;
    }

    @Override
    public ILayout getSouthPattern() {
        return this.southPattern;
    }

    public void setSouthPattern(ILayout layout) {
        this.southPattern = layout;
    }

    @Override
    public ILayout getEastPattern() {
        return this.eastPattern;
    }

    public void setEastPattern(ILayout layout) {
        this.eastPattern = layout;
    }

    @Override
    public ILayout getWestPattern() {
        return this.westPattern;
    }

    public void setWestPattern(ILayout layout) {
        this.westPattern = layout;
    }

    static {
        Category.DESIGN.addDesign(Blank);
        Category.DESIGN.addDesign(Octagon);
        Category.DESIGN.addDesign(Diamond);
        Category.DESIGN.addDesign(Ringed);
        Category.DESIGN.addDesign(Squared);
        Category.DESIGN.addDesign(Multiply);
        Category.DESIGN.addDesign(Plus);
        Category.DESIGN.addDesign(Circle);
        Category.DESIGN.addDesign(Emblem1);
        Category.DESIGN.addDesign(Emblem2);
        Category.DESIGN.addDesign(Emblem3);
        Category.DESIGN.addDesign(Emblem4);
        Category.DESIGN.addDesign(Emblem5);
        Category.DESIGN.addDesign(Creeper);
        Category.STRIPES.addDesign(Chequered);
        Category.STRIPES.addDesign(ChequeredB);
        Category.STRIPES.addDesign(Tiled);
        Category.STRIPES.addDesign(TiledB);
        Category.STRIPES.addDesign(Striped);
        Category.STRIPES.addDesign(ThinStriped);
        Category.STRIPES.addDesign(ThinStripedCorner);
        Category.STRIPES.addDesign(StripedCorner);
        Category.STRIPES.addDesign(OrnateStripedCorner);
        Category.EDGES.addDesign(Halved);
        Category.EDGES.addDesign(Corner);
        Category.EDGES.addDesign(ThickCorner);
        Category.EDGES.addDesign(Edged);
        Category.EDGES.addDesign(ThinCorner);
        Category.EDGES.addDesign(ThinEdged);
        Category.EDGES.addDesign(VeryThinCorner);
        Category.EDGES.addDesign(ThinCurvedCorner);
        Category.EDGES.addDesign(CurvedCorner);
        Category.BARRED.addDesign(ThinBarred);
        Category.BARRED.addDesign(ThinBarredCorner);
        Category.BARRED.addDesign(ThinTSection);
        Category.BARRED.addDesign(ThinCrossed);
        Category.BARRED.addDesign(ThinBarredEnd);
        Category.BARRED.addDesign(OrnateThinBarred);
        Category.BARRED.addDesign(Barred);
        Category.BARRED.addDesign(BarredCorner);
        Category.BARRED.addDesign(TSection);
        Category.BARRED.addDesign(Crossed);
        Category.BARRED.addDesign(BarredEnd);
        Category.BARRED.addDesign(OverlappedBarred);
        Category.BARRED.addDesign(OrnateBarred);
        Category.BARRED.addDesign(ThickBarred);
        Category.BARRED.addDesign(ThickBarredCorner);
        Category.BARRED.addDesign(ThickTSection);
        Category.BARRED.addDesign(ThickCrossed);
        Category.BARRED.addDesign(ThickBarredEnd);
        Category.BARRED.addDesign(ThinCurvedBarredCorner);
        Category.BARRED.addDesign(CurvedBarredCorner);
        Category.BARRED.addDesign(ThinCurvedTSection);
        Category.BARRED.addDesign(CurvedTSection);
        Category.BARRED.addDesign(ThinCurvedCrossed);
        Category.BARRED.addDesign(SplitBarred);
        Category.BARRED.addDesign(SplitBarredCorner);
        Category.BARRED.addDesign(SplitBarredTSection);
        Category.BARRED.addDesign(SplitCrossed);
        Category.BARRED.addDesign(SplitBarredEnd);
        Category.BARRED.addDesign(OverlappedSplitBarred);
        Category.DIAGONAL.addDesign(ThinSaltire);
        Category.DIAGONAL.addDesign(Diagonal);
        Category.DIAGONAL.addDesign(DiagonalCorner);
        Category.DIAGONAL.addDesign(DiagonalTSection);
        Category.DIAGONAL.addDesign(DiagonalCurvedCorner);
        Category.DIAGONAL.addDesign(DiagonalCurvedTSection);
        Category.DIAGONAL.addDesign(Saltire);
        Category.DIAGONAL.addDesign(ThickDiagonal);
        Category.DIAGONAL.addDesign(ThickSaltire);
        Category.DIAGONAL.addDesign(DiagonalHalved);
        Category.DIAGONAL.addDesign(Diagonal1Edged);
        Category.DIAGONAL.addDesign(Diagonal2Edged);
        Category.DIAGONAL.addDesign(ThickDiagonal1Edged);
        ThinStriped.setupStriped(EnumPattern.ThinStriped.layout());
        Striped.setupStriped(EnumPattern.Striped.layout());
        Halved.setupStriped(EnumPattern.Halved.layout());
        Chequered.setChequered(EnumPattern.Chequered.layout());
        Tiled.setChequered(EnumPattern.Tiled.layout());
        ChequeredB.setStripedChequered(EnumPattern.Halved.layout());
        TiledB.setStripedChequered(EnumPattern.Striped.layout());
        VeryThinCorner.setCornered(EnumPattern.VeryThinCorner.layout(), EnumPattern.ThinEdged.layout());
        ThinCorner.setCornered(EnumPattern.ThinCorner.layout(), EnumPattern.Edged.layout());
        Corner.setCornered(EnumPattern.Corner.layout(), EnumPattern.Halved.layout());
        ThickCorner.setCornered(EnumPattern.ThickCorner.layout(), EnumPattern.Edged.layout(true).flipHorizontal());
        ThinCurvedCorner.setCornered(EnumPattern.ThinCurvedCorner.layout(), EnumPattern.Edged.layout());
        CurvedCorner.setCornered(EnumPattern.CurvedCorner.layout(), EnumPattern.Halved.layout());
        Edged.setEdged();
        ThinEdged.setEdged();
        ThinBarred.setBarred();
        Barred.setBarred();
        ThickBarred.setBarred();
        Diagonal.setDiagonal(EnumPattern.Diagonal.layout());
        ThickDiagonal.setDiagonal(EnumPattern.ThickDiagonal.layout());
        ThinSaltire.setSaltire(EnumPattern.ThinSaltire.layout(), EnumPattern.ThickBarred.layout());
        Saltire.setSaltire(EnumPattern.Saltire.layout(), EnumPattern.Barred.layout());
        ThickSaltire.setSaltire(EnumPattern.ThickSaltire.layout(), EnumPattern.ThinBarred.layout());
        ThinCrossed.setCross(EnumPattern.ThinCrossed.layout(), EnumPattern.ThinBarred.layout());
        Crossed.setCross(EnumPattern.Crossed.layout(), EnumPattern.Barred.layout());
        ThickCrossed.setCross(EnumPattern.ThickCrossed.layout(), EnumPattern.ThickBarred.layout());
        ThinCurvedCrossed.setCross(EnumPattern.ThinCurvedCrossed.layout(), EnumPattern.ThinBarred.layout());
        ThinTSection.setTSection(EnumPattern.ThinTSection.layout(), EnumPattern.ThinBarred.layout());
        TSection.setTSection(EnumPattern.TSection.layout(), EnumPattern.Barred.layout());
        ThickTSection.setTSection(EnumPattern.ThickTSection.layout(), EnumPattern.ThickBarred.layout());
        ThinCurvedTSection.setTSection(EnumPattern.ThinCurvedTSection.layout(), EnumPattern.ThinBarred.layout());
        CurvedTSection.setTSection(EnumPattern.CurvedTSection.layout(), EnumPattern.Barred.layout());
        ThinBarredCorner.setBarredCorner(EnumPattern.ThinBarredCorner.layout(), EnumPattern.ThinBarred.layout());
        BarredCorner.setBarredCorner(EnumPattern.BarredCorner.layout(), EnumPattern.Barred.layout());
        ThickBarredCorner.setBarredCorner(EnumPattern.ThickBarredCorner.layout(), EnumPattern.ThickBarred.layout());
        ThinCurvedBarredCorner.setBarredCorner(EnumPattern.ThinCurvedBarredCorner.layout(), EnumPattern.ThinBarred.layout());
        CurvedBarredCorner.setBarredCorner(EnumPattern.BarredCurvedCorner.layout(), EnumPattern.Barred.layout());
        ThinStripedCorner.setStripedCorner(EnumPattern.ThinStripedCorner.layout(), EnumPattern.ThinStriped.layout());
        StripedCorner.setStripedCorner(EnumPattern.StripedCorner.layout(), EnumPattern.Striped.layout());
        OrnateStripedCorner.setStripedCorner(EnumPattern.OrnateStripedCorner.layout(), EnumPattern.ThinStriped.layout());
        LetterA.setLetterPattern(EnumPattern.LetterA.layout());
        LetterB.setLetterPattern(EnumPattern.LetterB.layout());
        LetterF.setLetterPattern(EnumPattern.LetterF.layout());
        LetterS.setLetterPattern(EnumPattern.LetterS.layout());
        LetterT.setLetterPattern(EnumPattern.LetterT.layout());
        BarredEnd.setBarredEndPattern(EnumPattern.BarredEnd.layout(), EnumPattern.Barred.layout());
        DiagonalCorner.setDiagonalCorner(EnumPattern.DiagonalCorner.layout(), EnumPattern.Barred.layout(), EnumPattern.Edged.layout());
        DiagonalTSection.setDiagonalTSection(EnumPattern.DiagonalTSection.layout(), EnumPattern.Barred.layout(), EnumPattern.Edged.layout());
        DiagonalCurvedCorner.setDiagonalCorner(EnumPattern.DiagonalCurvedCorner.layout(), EnumPattern.Barred.layout(), EnumPattern.Edged.layout());
        DiagonalCurvedTSection.setDiagonalTSection(EnumPattern.DiagonalCurvedTSection.layout(), EnumPattern.Barred.layout(), EnumPattern.Edged.layout());
        OrnateBarred.setBarred();
        OrnateThinBarred.setBarred();
        SplitBarred.setBarred();
        SplitBarredCorner.setBarredCorner(EnumPattern.SplitBarredCorner.layout(), EnumPattern.SplitBarred.layout());
        SplitBarredTSection.setTSection(EnumPattern.SplitBarredTSection.layout(), EnumPattern.SplitBarred.layout());
        SplitCrossed.setCross(EnumPattern.SplitCrossed.layout(), EnumPattern.SplitBarred.layout());
        SplitBarredEnd.setBarredEndPattern(EnumPattern.SplitBarredEnd.layout(), EnumPattern.SplitBarred.layout());
        Creeper.setTopAndBottomPattern(EnumPattern.Creeper.layout());
        DiagonalHalved.setTopAndBottomPattern(EnumPattern.DiagonalHalved.layout());
        DiagonalHalved.setEdgePatterns(EnumPattern.Blank.layout(), EnumPattern.Blank.layout(true), EnumPattern.Blank.layout(true), EnumPattern.Blank.layout());
        Diagonal1Edged.setTopAndBottomPattern(EnumPattern.Diagonal1Edged.layout());
        Diagonal1Edged.setEdgePatterns(EnumPattern.Edged.layout().flipHorizontal(), EnumPattern.Blank.layout(true), EnumPattern.Blank.layout(true), EnumPattern.Edged.layout());
        Diagonal2Edged.setTopAndBottomPattern(EnumPattern.Diagonal2Edged.layout());
        Diagonal2Edged.setEdgePatterns(EnumPattern.Edged.layout(), EnumPattern.Edged.layout().flipHorizontal(), EnumPattern.Edged.layout(), EnumPattern.Edged.layout().flipHorizontal());
        ThickDiagonal1Edged.setTopAndBottomPattern(EnumPattern.ThickDiagonal1Edged.layout());
        ThickDiagonal1Edged.setEdgePatterns(EnumPattern.Halved.layout().flipHorizontal(), EnumPattern.Blank.layout(true), EnumPattern.Blank.layout(true), EnumPattern.Halved.layout());
        ThickBarredEnd.setBarredEndPattern(EnumPattern.ThickBarredEnd.layout(), EnumPattern.ThickBarred.layout());
        ThinBarredEnd.setBarredEndPattern(EnumPattern.ThinBarredEnd.layout(), EnumPattern.ThinBarred.layout());
        OverlappedSplitBarred.setTopAndBottomPattern(EnumPattern.OverlappedSplitBarred.layout());
        OverlappedBarred.setTopAndBottomPattern(EnumPattern.OverlappedBarred.layout());
    }

    static enum Category implements IDesignCategory
    {
        DESIGN("Designs & Emblems"),
        STRIPES("Squares & Stripes"),
        EDGES("Edges"),
        BARRED("Bars"),
        LETTERS("Letters"),
        DIAGONAL("Diagonals");

        private final String name;
        private final List<IDesign> designs = new ArrayList<IDesign>();

        private Category(String name) {
            this.name = name;
            Design.getDesignManager().registerDesignCategory(this);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public List<IDesign> getDesigns() {
            return this.designs;
        }

        @Override
        public void addDesign(IDesign design) {
            this.designs.add(design);
        }

        @Override
        public String getId() {
            return this.toString().toLowerCase();
        }
    }
}

