/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.inventory;

import elec332.core.util.ItemStackHelper;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public abstract class WrappedItemHandler
implements IItemHandlerModifiable {
    public static IItemHandlerModifiable wrap(@Nonnull IItemHandler itemHandler, boolean in, boolean out) {
        return WrappedItemHandler.wrap(() -> itemHandler, in, out);
    }

    public static IItemHandlerModifiable wrap(final @Nonnull Supplier<IItemHandler> itemHandler, final boolean in, final boolean out) {
        return new WrappedItemHandler(){

            @Override
            @Nonnull
            protected IItemHandler getItemHandler() {
                return (IItemHandler)itemHandler.get();
            }

            @Override
            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return in ? super.insertItem(slot, stack, simulate) : stack;
            }

            @Override
            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return out ? super.extractItem(slot, amount, simulate) : ItemStackHelper.NULL_STACK;
            }
        };
    }

    public static IItemHandlerModifiable wrap(IItemHandler itemHandler) {
        return WrappedItemHandler.wrap(() -> itemHandler);
    }

    public static IItemHandlerModifiable wrap(final Supplier<IItemHandler> itemHandler) {
        return new WrappedItemHandler(){

            @Override
            @Nonnull
            protected IItemHandler getItemHandler() {
                return (IItemHandler)itemHandler.get();
            }
        };
    }

    @Nonnull
    protected abstract IItemHandler getItemHandler();

    public int getSlots() {
        return this.getItemHandler().getSlots();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.getItemHandler().getStackInSlot(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        return this.getItemHandler().insertItem(slot, stack, simulate);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.getItemHandler().extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.getItemHandler().getSlotLimit(slot);
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        if (this.getItemHandler() instanceof IItemHandlerModifiable) {
            ((IItemHandlerModifiable)this.getItemHandler()).setStackInSlot(slot, stack);
            return;
        }
        throw new UnsupportedOperationException();
    }
}

