/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.handler.annotations;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import elec332.core.api.callback.CallbackProcessor;
import elec332.core.api.callback.ICallbackProcessor;
import elec332.core.api.callback.RegisteredCallback;
import elec332.core.api.discovery.ASMDataProcessor;
import elec332.core.api.registration.HasSpecialRenderer;
import elec332.core.api.registration.RegisteredTileEntity;
import elec332.core.handler.annotations.AbstractAnnotationProcessor;
import elec332.core.util.FMLUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.objectweb.asm.Type;

@ASMDataProcessor(value={LoaderState.INITIALIZATION})
public class InitAnnotationProcessor
extends AbstractAnnotationProcessor {
    @Override
    protected void registerProcesses() {
        final ArrayList callbacks = Lists.newArrayList();
        final List callbacks_ = Collections.unmodifiableList(callbacks);
        this.registerDataProcessor(RegisteredCallback.class, new Consumer<ASMDataTable.ASMData>(){

            @Override
            public void accept(ASMDataTable.ASMData asmData) {
                Class<?> clazz = InitAnnotationProcessor.this.loadClass(asmData, false);
                if (clazz == null) {
                    return;
                }
                Object instance = InitAnnotationProcessor.this.instantiate(clazz, false, new Object[0]);
                if (instance == null) {
                    return;
                }
                callbacks.add(instance);
            }
        });
        this.registerDataProcessor(CallbackProcessor.class, new Consumer<ASMDataTable.ASMData>(){

            @Override
            public void accept(ASMDataTable.ASMData asmData) {
                Object instance = InitAnnotationProcessor.this.instantiate(InitAnnotationProcessor.this.loadClass(asmData), new Object[0]);
                if (instance instanceof ICallbackProcessor) {
                    ((ICallbackProcessor)instance).getCallbacks(callbacks_);
                }
            }
        });
        this.registerDataProcessor(HasSpecialRenderer.class, new Consumer<ASMDataTable.ASMData>(){

            @Override
            public void accept(ASMDataTable.ASMData asmData) {
                try {
                    ClientRegistry.bindTileEntitySpecialRenderer(Class.forName(asmData.getClassName()), (TileEntitySpecialRenderer)((TileEntitySpecialRenderer)Class.forName(((Type)asmData.getAnnotationInfo().get("value")).getClassName()).newInstance()));
                }
                catch (Exception ex) {
                    throw Throwables.propagate((Throwable)ex);
                }
            }
        }, FMLCommonHandler.instance().getSide().isClient());
        this.registerDataProcessor(RegisteredTileEntity.class, new Consumer<ASMDataTable.ASMData>(){

            @Override
            public void accept(ASMDataTable.ASMData data) {
                try {
                    String name = (String)data.getAnnotationInfo().get("value");
                    Class<?> clazz = Class.forName(data.getClassName());
                    if (!name.contains(":")) {
                        String mod = FMLUtil.getOwnerName(clazz);
                        name = mod + ":" + name;
                    }
                    GameRegistry.registerTileEntity(clazz, (ResourceLocation)new ResourceLocation(name));
                }
                catch (Exception e) {
                    AbstractAnnotationProcessor.logger.error("Error registering tile: " + data.getClassName());
                }
            }
        });
    }
}

