/*
 * Decompiled with CFR 0.152.
 */
package mcjty.meecreeps.proxy;

import java.io.File;
import java.util.HashMap;
import mcjty.lib.datafix.fixes.TileEntityNamespace;
import mcjty.lib.network.PacketHandler;
import mcjty.lib.proxy.AbstractCommonProxy;
import mcjty.meecreeps.CommandHandler;
import mcjty.meecreeps.ForgeEventHandlers;
import mcjty.meecreeps.MeeCreeps;
import mcjty.meecreeps.blocks.HeldCubeBlock;
import mcjty.meecreeps.blocks.ModBlocks;
import mcjty.meecreeps.blocks.PortalBlock;
import mcjty.meecreeps.blocks.PortalTileEntity;
import mcjty.meecreeps.config.Config;
import mcjty.meecreeps.entities.ModEntities;
import mcjty.meecreeps.items.CartridgeItem;
import mcjty.meecreeps.items.CreepCubeItem;
import mcjty.meecreeps.items.EmptyPortalGunItem;
import mcjty.meecreeps.items.PortalGunItem;
import mcjty.meecreeps.items.ProjectileItem;
import mcjty.meecreeps.network.MeeCreepsMessages;
import mcjty.meecreeps.proxy.GuiProxy;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.ModFixs;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class CommonProxy
extends AbstractCommonProxy {
    public void preInit(FMLPreInitializationEvent e) {
        super.preInit(e);
        MinecraftForge.EVENT_BUS.register((Object)new ForgeEventHandlers());
        CommandHandler.registerCommands();
        MeeCreeps.api.registerFactories();
        File directory = e.getModConfigurationDirectory();
        this.mainConfig = new Configuration(new File(directory.getPath(), "meecreeps.cfg"));
        Config.readConfig(this.mainConfig);
        SimpleNetworkWrapper network = PacketHandler.registerMessages((String)"meecreeps", (String)"meecreeps");
        MeeCreepsMessages.registerMessages(network);
        ModEntities.init();
    }

    public void init(FMLInitializationEvent e) {
        super.init(e);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)MeeCreeps.instance, (IGuiHandler)new GuiProxy());
    }

    public void postInit(FMLPostInitializationEvent e) {
        super.postInit(e);
        if (this.mainConfig.hasChanged()) {
            this.mainConfig.save();
        }
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        ModFixs modFixs = FMLCommonHandler.instance().getDataFixer().init("meecreeps", 1);
        HashMap<String, String> oldToNewIdMap = new HashMap<String, String>();
        event.getRegistry().register((IForgeRegistryEntry)new HeldCubeBlock());
        event.getRegistry().register((IForgeRegistryEntry)new PortalBlock());
        GameRegistry.registerTileEntity(PortalTileEntity.class, (String)"meecreeps:portalblock");
        oldToNewIdMap.put("meecreeps_portalblock", "meecreeps:portalblock");
        oldToNewIdMap.put("minecraft:meecreeps_portalblock", "meecreeps:portalblock");
        modFixs.registerFix((IFixType)FixTypes.BLOCK_ENTITY, (IFixableData)new TileEntityNamespace(oldToNewIdMap, 1));
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)new CreepCubeItem());
        event.getRegistry().register((IForgeRegistryEntry)new PortalGunItem());
        event.getRegistry().register((IForgeRegistryEntry)new EmptyPortalGunItem());
        event.getRegistry().register((IForgeRegistryEntry)new ProjectileItem());
        event.getRegistry().register((IForgeRegistryEntry)new CartridgeItem());
        event.getRegistry().register(new ItemBlock((Block)ModBlocks.portalBlock).setRegistryName(ModBlocks.portalBlock.getRegistryName()));
    }
}

