/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client.containerBuilder.builder;

import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotFurnaceFuel;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.tuple.Pair;
import reborncore.RebornCore;
import reborncore.api.recipe.IRecipeCrafterProvider;
import reborncore.api.tile.IUpgrade;
import reborncore.api.tile.IUpgradeable;
import reborncore.client.containerBuilder.builder.ContainerBuilder;
import reborncore.client.containerBuilder.builder.slot.FilteredSlot;
import reborncore.client.containerBuilder.builder.slot.UpgradeSlot;
import reborncore.client.gui.slots.BaseSlot;
import reborncore.client.gui.slots.SlotFake;
import reborncore.client.gui.slots.SlotOutput;
import reborncore.common.powerSystem.ExternalPowerSystems;
import reborncore.common.powerSystem.TilePowerAcceptor;

public class ContainerTileInventoryBuilder {
    private final IInventory tile;
    private final ContainerBuilder parent;
    private final int rangeStart;

    ContainerTileInventoryBuilder(ContainerBuilder parent, IInventory tile) {
        this.tile = tile;
        this.parent = parent;
        this.rangeStart = parent.slots.size();
        if (tile instanceof IUpgradeable) {
            this.upgradeSlots((IUpgradeable)tile);
        }
    }

    public ContainerTileInventoryBuilder slot(int index, int x, int y) {
        this.parent.slots.add(new BaseSlot(this.tile, index, x, y));
        return this;
    }

    public ContainerTileInventoryBuilder slot(int index, int x, int y, Predicate<ItemStack> filter) {
        this.parent.slots.add(new BaseSlot(this.tile, index, x, y, filter));
        return this;
    }

    public ContainerTileInventoryBuilder outputSlot(int index, int x, int y) {
        this.parent.slots.add(new SlotOutput(this.tile, index, x, y));
        return this;
    }

    public ContainerTileInventoryBuilder fakeSlot(int index, int x, int y) {
        this.parent.slots.add(new SlotFake(this.tile, index, x, y, false, false, Integer.MAX_VALUE));
        return this;
    }

    public ContainerTileInventoryBuilder filterSlot(int index, int x, int y, Predicate<ItemStack> filter) {
        this.parent.slots.add(new FilteredSlot(this.tile, index, x, y).setFilter(filter));
        return this;
    }

    public ContainerTileInventoryBuilder energySlot(int index, int x, int y) {
        this.parent.slots.add(new FilteredSlot(this.tile, index, x, y).setFilter(ExternalPowerSystems::isPoweredItem));
        return this;
    }

    public ContainerTileInventoryBuilder fluidSlot(int index, int x, int y) {
        this.parent.slots.add(new FilteredSlot(this.tile, index, x, y).setFilter(stack -> stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, EnumFacing.UP)));
        return this;
    }

    public ContainerTileInventoryBuilder fuelSlot(int index, int x, int y) {
        this.parent.slots.add((Slot)new SlotFurnaceFuel(this.tile, index, x, y));
        return this;
    }

    @Deprecated
    public ContainerTileInventoryBuilder upgradeSlot(int index, int x, int y) {
        this.parent.slots.add(new FilteredSlot(this.tile, index, x, y).setFilter(stack -> stack.func_77973_b() instanceof IUpgrade));
        return this;
    }

    private ContainerTileInventoryBuilder upgradeSlots(IUpgradeable upgradeable) {
        if (upgradeable.canBeUpgraded()) {
            for (int i = 0; i < upgradeable.getUpgradeSlotCount(); ++i) {
                this.parent.slots.add(new UpgradeSlot(upgradeable.getUpgradeInvetory(), i, -19, i * 18 + 12));
            }
        }
        return this;
    }

    public ContainerTileInventoryBuilder syncShortValue(IntSupplier supplier, IntConsumer setter) {
        this.parent.shortValues.add((Pair<IntSupplier, IntConsumer>)Pair.of((Object)supplier, (Object)setter));
        return this;
    }

    public ContainerTileInventoryBuilder syncIntegerValue(IntSupplier supplier, IntConsumer setter) {
        this.parent.integerValues.add((Pair<IntSupplier, IntConsumer>)Pair.of((Object)supplier, (Object)setter));
        return this;
    }

    public ContainerTileInventoryBuilder syncLongValue(LongSupplier supplier, LongConsumer setter) {
        this.parent.longValues.add((Pair<LongSupplier, LongConsumer>)Pair.of((Object)supplier, (Object)setter));
        return this;
    }

    public <T> ContainerTileInventoryBuilder sync(Supplier<T> supplier, Consumer<T> setter) {
        this.parent.objectValues.add((Pair<Supplier, Consumer>)Pair.of(supplier, setter));
        return this;
    }

    public ContainerTileInventoryBuilder syncEnergyValue() {
        if (this.tile instanceof TilePowerAcceptor) {
            return this.syncIntegerValue(() -> (int)((TilePowerAcceptor)this.tile).getEnergy(), ((TilePowerAcceptor)this.tile)::setEnergy).syncIntegerValue(() -> (int)((TilePowerAcceptor)this.tile).extraPowerStoage, ((TilePowerAcceptor)this.tile)::setExtraPowerStoage).syncIntegerValue(() -> (int)((TilePowerAcceptor)this.tile).getPowerChange(), ((TilePowerAcceptor)this.tile)::setPowerChange);
        }
        RebornCore.logHelper.error(this.tile + " is not an instance of TilePowerAcceptor! Energy cannot be synced.");
        return this;
    }

    public ContainerTileInventoryBuilder syncCrafterValue() {
        if (this.tile instanceof IRecipeCrafterProvider) {
            return this.syncIntegerValue(() -> ((IRecipeCrafterProvider)this.tile).getRecipeCrafter().currentTickTime, currentTickTime -> {
                ((IRecipeCrafterProvider)this.tile).getRecipeCrafter().currentTickTime = currentTickTime;
            }).syncIntegerValue(() -> ((IRecipeCrafterProvider)this.tile).getRecipeCrafter().currentNeededTicks, currentNeededTicks -> {
                ((IRecipeCrafterProvider)this.tile).getRecipeCrafter().currentNeededTicks = currentNeededTicks;
            });
        }
        RebornCore.logHelper.error(this.tile + " is not an instance of IRecipeCrafterProvider! Craft progress cannot be synced.");
        return this;
    }

    public ContainerTileInventoryBuilder onCraft(Consumer<InventoryCrafting> onCraft) {
        this.parent.craftEvents.add(onCraft);
        return this;
    }

    public ContainerBuilder addInventory() {
        this.parent.tileInventoryRanges.add((Range<Integer>)Range.between((Comparable)Integer.valueOf(this.rangeStart), (Comparable)Integer.valueOf(this.parent.slots.size() - 1)));
        return this.parent;
    }
}

