/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.world;

import aroma1997.core.config.Conf;
import aroma1997.core.network.AutoEncode;
import aroma1997.core.network.packets.PacketAutoEncode;
import aroma1997.world.DimensionalWorld;
import aroma1997.world.DimensionalWorldItems;
import aroma1997.world.gen.WorldGenConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class Config
extends PacketAutoEncode {
    public static final Config INSTANCE = new Config();
    public static final String CATEGORY_WORLD_CUSTOMIZATION = "World Modifiers";
    public static final String CATEGORY_MOB_SPAWN = "Mob spawns";
    @AutoEncode
    public int dimensionid;
    public int worldHeight;
    public boolean generateCaves;
    public boolean generateStrongholds;
    public boolean generateVillages;
    public boolean generateRavines;
    public boolean generateMineshafts;
    public List<WorldGenerator> additionalWorldGens = new ArrayList<WorldGenerator>();
    @AutoEncode
    public boolean onlyDay;
    @AutoEncode
    public boolean artificialLight;
    public String welcomeMessage;
    public int oreGenMultiplier;
    public Set<EnumCreatureType> mobsToSpawn = new HashSet<EnumCreatureType>();

    void loadFromDisc() {
        Configuration conf = Conf.getConfig((String)"aroma1997sdimension");
        File oreConfOld = Conf.getConfigFile((String)"aroma1997sdimension_gen");
        if (oreConfOld.exists()) {
            oreConfOld.delete();
        }
        File oreConf = new File(conf.getConfigFile().getParentFile(), "aroma1997sdimension_gen.json");
        this.dimensionid = conf.getInt("dimensionID", "general", -6, Integer.MIN_VALUE, Integer.MAX_VALUE, "The actual dimension id of the mining world.");
        this.loadReloadables(conf, oreConf);
        if (conf.hasChanged()) {
            conf.save();
        }
    }

    void loadReloadablesFromDisc() {
        Configuration conf = Conf.getConfig((String)"aroma1997sdimension");
        File oreConf = new File(conf.getConfigFile().getParentFile(), "aroma1997sdimension_gen.json");
        this.loadReloadables(conf, oreConf);
        if (conf.hasChanged()) {
            conf.save();
        }
    }

    private void loadReloadables(Configuration conf, File oreConf) {
        DimensionalWorldItems.miningBiome.field_76753_B = Config.getStateFromString(conf.getString("fillerBlock", CATEGORY_WORLD_CUSTOMIZATION, "minecraft:dirt", "Filler block of the mining world in the form modid:blockname:metadata"));
        DimensionalWorldItems.miningBiome.field_76752_A = Config.getStateFromString(conf.getString("topBlock", CATEGORY_WORLD_CUSTOMIZATION, "minecraft:grass", "Top block of the mining world in the form modid:blockname:metadata"));
        this.worldHeight = conf.getInt("worldHeight", CATEGORY_WORLD_CUSTOMIZATION, 70, 0, 230, "The world height of the Mining world.");
        this.generateCaves = conf.getBoolean("generateCaves", CATEGORY_WORLD_CUSTOMIZATION, true, "This will determine whether caves will be generated in the mining world.");
        this.generateStrongholds = conf.getBoolean("generateStrongholds", CATEGORY_WORLD_CUSTOMIZATION, false, "This will determine whether strongholds will be generated in the mining world.");
        this.generateVillages = conf.getBoolean("generateVillages", CATEGORY_WORLD_CUSTOMIZATION, true, "This will determine whether villages will be generated in the mining world.");
        this.generateRavines = conf.getBoolean("generateRavines", CATEGORY_WORLD_CUSTOMIZATION, true, "This will determine whether ravines will be generated in the mining world.");
        this.generateMineshafts = conf.getBoolean("generateMineshafts", CATEGORY_WORLD_CUSTOMIZATION, true, "This will determine whether abandoned mineshafts will be generated in the mining world.");
        this.additionalWorldGens = WorldGenConfig.loadAdditionalWorldGen(oreConf);
        this.onlyDay = conf.getBoolean("onlyDay", CATEGORY_WORLD_CUSTOMIZATION, true, "Setting this to true will make it so it's always daytime. Note: this can be abused for solar power generation.");
        this.artificialLight = conf.getBoolean("artificialLight", CATEGORY_WORLD_CUSTOMIZATION, false, "Setting this to true means, that you can also see in the dark. This will however not change the light level.");
        this.welcomeMessage = conf.getString("welcomeMessage", "general", "", "Set this to a message you want players to show when they go to the mining world. \r\n Something like \"Mining World will be reset on Tuesday - Server admins.\"");
        EnumSet<EnumCreatureType> localMobsToSpawn = EnumSet.noneOf(EnumCreatureType.class);
        for (EnumCreatureType type : EnumCreatureType.values()) {
            if (!conf.getBoolean("spawn" + type.name(), CATEGORY_MOB_SPAWN, false, "Set this to true to allow mobs of the type " + type + " to spawn in the mining world.")) continue;
            localMobsToSpawn.add(type);
        }
        this.mobsToSpawn = localMobsToSpawn;
        this.oreGenMultiplier = conf.getInt("oreGenMultiplier", CATEGORY_WORLD_CUSTOMIZATION, 1, 0, 100, "How many ore generation passes will be done.");
    }

    public void onReload() {
    }

    public static IBlockState getStateFromString(String name) {
        int meta;
        String second;
        String first;
        name = name.trim();
        String[] split = name.split(":");
        if (name.isEmpty()) {
            first = "minecraft";
            second = "stone";
            meta = 0;
        } else if (split.length == 1) {
            first = "minecraft";
            second = split[0];
            meta = 0;
        } else if (split.length == 2) {
            first = split[0];
            second = split[1];
            meta = 0;
        } else if (split.length == 3) {
            first = split[0];
            second = split[1];
            meta = Integer.parseInt(split[2]);
        } else {
            throw new IllegalArgumentException("Invalid argument amount for blockstate " + name);
        }
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(first, second));
        if (block == null) {
            DimensionalWorld.instance.log.info("Block specified for " + name + " was not found.");
            block = Blocks.field_150350_a;
        }
        return block.func_176203_a(meta);
    }

    public static class PacketHandler
    implements IMessageHandler<Config, IMessage> {
        public IMessage onMessage(Config config, MessageContext context) {
            DimensionalWorld.proxy.setConfig(config);
            return null;
        }
    }
}

