/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.integration.forestry.upgrades;

import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.base.handler.darksteel.AbstractUpgrade;
import crazypants.enderio.integration.forestry.ForestryItemStacks;
import crazypants.enderio.integration.forestry.config.ForestryConfig;
import crazypants.enderio.util.Prep;
import javax.annotation.Nonnull;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;

public class NaturalistEyeUpgrade
extends AbstractUpgrade {
    @Nonnull
    private static final String UPGRADE_NAME = "naturalist_eye";

    @Nonnull
    public static ItemStack getNaturalistEye() {
        return ForestryItemStacks.FORESTRY_HELMET != null ? ForestryItemStacks.FORESTRY_HELMET : Prep.getEmpty();
    }

    public NaturalistEyeUpgrade() {
        super("enderiointegrationforestry", UPGRADE_NAME, "enderio.darksteel.upgrade.naturalist_eye", NaturalistEyeUpgrade.getNaturalistEye(), ForestryConfig.naturalistEyeCost);
    }

    @Override
    public boolean canAddToItem(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item) {
        return item.isForSlot(EntityEquipmentSlot.HEAD) && Prep.isValid(this.getUpgradeItem()) && !this.hasUpgrade(stack, item);
    }

    @Override
    @Nonnull
    public ItemStack getUpgradeItem() {
        this.upgradeItem = NaturalistEyeUpgrade.getNaturalistEye();
        return this.upgradeItem;
    }

    @Override
    @Nonnull
    public String getUpgradeItemName() {
        if (Prep.isInvalid(this.getUpgradeItem())) {
            return "(???)";
        }
        return super.getUpgradeItemName();
    }
}

