/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.base.Predicate;
import com.mojang.authlib.GameProfile;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.common.ai.StringFilterEntitySelector;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.item.ItemGunAmmo;
import me.desht.pneumaticcraft.common.minigun.Minigun;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.tileentity.FilteredItemStackHandler;
import me.desht.pneumaticcraft.common.tileentity.IGUITextFieldSensitive;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControlled;
import me.desht.pneumaticcraft.common.tileentity.TileEntitySecurityStation;
import me.desht.pneumaticcraft.common.tileentity.TileEntityTickableBase;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.fakeplayer.FakeNetHandlerPlayerServer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntitySentryTurret
extends TileEntityTickableBase
implements IRedstoneControlled,
IGUITextFieldSensitive {
    private static final int INVENTORY_SIZE = 4;
    private final ItemStackHandler inventory = new TurretItemStackHandler(this);
    @GuiSynced
    private String entityFilter = "";
    @GuiSynced
    private int redstoneMode;
    @DescSynced
    private double range;
    @DescSynced
    private boolean activated;
    @DescSynced
    private ItemStack minigunColorStack = ItemStack.field_190927_a;
    private Minigun minigun;
    @DescSynced
    private int targetEntityId = -1;
    @DescSynced
    private boolean sweeping;
    private final SentryTurretEntitySelector entitySelector = new SentryTurretEntitySelector();
    private double rangeSq;

    public TileEntitySentryTurret() {
        super(4);
        this.addApplicableUpgrade(IItemRegistry.EnumUpgrade.RANGE);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K) {
            EntityLivingBase target;
            if (this.getMinigun().getAttackTarget() == null && this.redstoneAllows()) {
                List entities;
                this.getMinigun().setSweeping(true);
                if ((this.func_145831_w().func_82737_E() & 0xFL) == 0L && (entities = this.func_145831_w().func_175647_a(EntityLivingBase.class, this.getTargetingBoundingBox(), (Predicate)this.entitySelector)).size() > 0) {
                    entities.sort(new TargetSorter());
                    this.getMinigun().setAttackTarget((EntityLivingBase)entities.get(0));
                    this.targetEntityId = ((EntityLivingBase)entities.get(0)).func_145782_y();
                }
            } else {
                this.getMinigun().setSweeping(false);
            }
            if ((target = this.getMinigun().getAttackTarget()) != null) {
                if (!this.redstoneAllows() || !this.entitySelector.apply((Entity)target)) {
                    this.getMinigun().setAttackTarget(null);
                    this.targetEntityId = -1;
                } else if ((this.func_145831_w().func_82737_E() & 7L) == 0L) {
                    this.getFakePlayer().func_70107_b((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5);
                    boolean usedAmmo = this.getMinigun().tryFireMinigun((Entity)target);
                    if (usedAmmo) {
                        for (int i = 0; i < this.inventory.getSlots(); ++i) {
                            if (this.inventory.getStackInSlot(i).func_190926_b()) continue;
                            this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
                            break;
                        }
                    }
                }
            }
        }
        this.getMinigun().update((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5);
    }

    private boolean canSeeEntity(Entity entity) {
        Vec3d entityVec = new Vec3d(entity.field_70165_t + (double)(entity.field_70130_N / 2.0f), entity.field_70163_u + (double)(entity.field_70131_O / 2.0f), entity.field_70161_v + (double)(entity.field_70130_N / 2.0f));
        Vec3d tileVec = new Vec3d((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5);
        RayTraceResult trace = this.func_145831_w().func_72933_a(entityVec, tileVec);
        return trace != null && trace.func_178782_a().equals((Object)this.func_174877_v());
    }

    private AxisAlignedBB getTargetingBoundingBox() {
        return new AxisAlignedBB((double)this.func_174877_v().func_177958_n() - this.range, (double)this.func_174877_v().func_177956_o() - this.range, (double)this.func_174877_v().func_177952_p() - this.range, (double)this.func_174877_v().func_177958_n() + this.range + 1.0, (double)this.func_174877_v().func_177956_o() + this.range + 1.0, (double)this.func_174877_v().func_177952_p() + this.range + 1.0);
    }

    @Override
    protected void onFirstServerUpdate() {
        super.onFirstServerUpdate();
        this.updateAmmo();
    }

    @Override
    public void onDescUpdate() {
        super.onDescUpdate();
        Entity entity = this.func_145831_w().func_73045_a(this.targetEntityId);
        if (entity instanceof EntityLivingBase) {
            this.getMinigun().setAttackTarget((EntityLivingBase)entity);
        } else {
            this.getMinigun().setAttackTarget(null);
        }
    }

    public Minigun getMinigun() {
        if (this.minigun == null) {
            this.minigun = new MinigunSentryTurret();
            this.minigun.setWorld(this.func_145831_w());
            if (!this.func_145831_w().field_72995_K) {
                this.minigun.setPlayer(this.getFakePlayer());
            }
        }
        return this.minigun;
    }

    private EntityPlayer getFakePlayer() {
        FakePlayer fakePlayer = FakePlayerFactory.get((WorldServer)((WorldServer)this.func_145831_w()), (GameProfile)new GameProfile(null, "Sentry Turret"));
        if (fakePlayer.field_71135_a == null) {
            fakePlayer.field_71135_a = new FakeNetHandlerPlayerServer(FMLCommonHandler.instance().getMinecraftServerInstance(), (EntityPlayerMP)fakePlayer);
        }
        return fakePlayer;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74782_a("Items", (NBTBase)this.inventory.serializeNBT());
        tag.func_74774_a("redstoneMode", (byte)this.redstoneMode);
        tag.func_74778_a("entityFilter", this.entityFilter);
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.deserializeNBT(tag.func_74775_l("Items"));
        this.redstoneMode = tag.func_74771_c("redstoneMode");
        this.setText(0, tag.func_74779_i("entityFilter"));
    }

    @Override
    public boolean redstoneAllows() {
        return this.redstoneMode == 3 || super.redstoneAllows();
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public void handleGUIButtonPress(int buttonID, EntityPlayer player) {
        if (buttonID == 0) {
            ++this.redstoneMode;
            if (this.redstoneMode > 2) {
                this.redstoneMode = 0;
            }
        }
    }

    @Override
    public String getName() {
        return Blockss.SENTRY_TURRET.func_149739_a();
    }

    private void updateAmmo() {
        ItemStack ammo = ItemStack.field_190927_a;
        for (int i = 0; i < this.inventory.getSlots() && (ammo = this.inventory.getStackInSlot(i)).func_190926_b(); ++i) {
        }
        this.getMinigun().setAmmoStack(ammo);
        this.recalculateRange();
    }

    @Override
    public IItemHandlerModifiable getPrimaryInventory() {
        return this.inventory;
    }

    @Override
    protected void onUpgradesChanged() {
        super.onUpgradesChanged();
        if (this.func_145831_w() != null) {
            this.recalculateRange();
        }
    }

    private void recalculateRange() {
        this.range = 16.0 + (double)Math.min(16, this.getUpgrades(IItemRegistry.EnumUpgrade.RANGE));
        ItemStack ammoStack = this.getMinigun().getAmmoStack();
        if (ammoStack.func_77973_b() instanceof ItemGunAmmo) {
            this.range *= (double)((ItemGunAmmo)ammoStack.func_77973_b()).getRangeMultiplier(ammoStack);
        }
        this.rangeSq = this.range * this.range;
    }

    @Override
    public void setText(int textFieldID, String text) {
        this.entityFilter = text;
        this.entitySelector.setFilter(text);
        if (this.minigun != null) {
            this.minigun.setAttackTarget(null);
        }
        this.func_70296_d();
    }

    @Override
    public String getText(int textFieldID) {
        return this.entityFilter;
    }

    private class SentryTurretEntitySelector
    extends StringFilterEntitySelector {
        private SentryTurretEntitySelector() {
        }

        @Override
        public boolean apply(Entity entity) {
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                if (player.field_71075_bZ.field_75098_d || this.isExcludedBySecurityStations(player)) {
                    return false;
                }
            }
            return super.apply(entity) && this.inRange(entity) && TileEntitySentryTurret.this.canSeeEntity(entity);
        }

        private boolean inRange(Entity entity) {
            return PneumaticCraftUtils.distBetweenSq((Vec3i)new BlockPos(TileEntitySentryTurret.this.func_174877_v().func_177958_n(), TileEntitySentryTurret.this.func_174877_v().func_177956_o(), TileEntitySentryTurret.this.func_174877_v().func_177952_p()), entity.field_70165_t, entity.field_70163_u, entity.field_70161_v) <= TileEntitySentryTurret.this.rangeSq;
        }

        private boolean isExcludedBySecurityStations(EntityPlayer player) {
            Iterator iterator = PneumaticCraftUtils.getSecurityStations(TileEntitySentryTurret.this.func_145831_w(), TileEntitySentryTurret.this.func_174877_v(), false).iterator();
            if (iterator.hasNext()) {
                while (iterator.hasNext()) {
                    if (((TileEntitySecurityStation)iterator.next()).doesAllowPlayer(player)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    private class TargetSorter
    implements Comparator<Entity> {
        private final BlockPos pos;

        TargetSorter() {
            this.pos = new BlockPos(TileEntitySentryTurret.this.func_174877_v().func_177958_n(), TileEntitySentryTurret.this.func_174877_v().func_177956_o(), TileEntitySentryTurret.this.func_174877_v().func_177952_p());
        }

        @Override
        public int compare(Entity arg0, Entity arg1) {
            double dist1 = PneumaticCraftUtils.distBetweenSq(this.pos, arg0.func_180425_c());
            double dist2 = PneumaticCraftUtils.distBetweenSq(this.pos, arg1.func_180425_c());
            return Double.compare(dist1, dist2);
        }
    }

    private class MinigunSentryTurret
    extends Minigun {
        MinigunSentryTurret() {
            super(true);
        }

        @Override
        public boolean isMinigunActivated() {
            return TileEntitySentryTurret.this.activated;
        }

        @Override
        public void setMinigunActivated(boolean activated) {
            TileEntitySentryTurret.this.activated = activated;
        }

        @Override
        public void setAmmoColorStack(@Nonnull ItemStack ammo) {
            TileEntitySentryTurret.this.minigunColorStack = ammo;
        }

        @Override
        public int getAmmoColor() {
            return this.getAmmoColor(TileEntitySentryTurret.this.minigunColorStack);
        }

        @Override
        public void playSound(SoundEvent soundName, float volume, float pitch) {
            NetworkHandler.sendToAllAround(new PacketPlaySound(soundName, SoundCategory.BLOCKS, (double)TileEntitySentryTurret.this.func_174877_v().func_177958_n() + 0.5, (double)TileEntitySentryTurret.this.func_174877_v().func_177956_o() + 0.5, (double)TileEntitySentryTurret.this.func_174877_v().func_177952_p() + 0.5, volume, pitch, false), this.world);
        }

        @Override
        public void setSweeping(boolean sweeping) {
            TileEntitySentryTurret.this.sweeping = sweeping;
        }

        @Override
        public boolean isSweeping() {
            return TileEntitySentryTurret.this.sweeping;
        }

        @Override
        public Object getSoundSource() {
            return TileEntitySentryTurret.this.func_174877_v();
        }
    }

    private class TurretItemStackHandler
    extends FilteredItemStackHandler {
        TurretItemStackHandler(TileEntity te) {
            super(te, 4);
        }

        @Override
        protected void onContentsChanged(int slot) {
            TileEntitySentryTurret.this.updateAmmo();
        }

        @Override
        public boolean test(Integer integer, ItemStack itemStack) {
            return itemStack.func_190926_b() || itemStack.func_77973_b() instanceof ItemGunAmmo;
        }
    }
}

