/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import io.netty.buffer.ByteBuf;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.common.CommonHUDHandler;
import me.desht.pneumaticcraft.common.network.AbstractPacket;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAirCannon;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemHandlerHelper;

public class PacketChestplateLauncher
extends AbstractPacket<PacketChestplateLauncher> {
    private static final float SCALE_FACTOR = 0.7f;
    private float amount;

    public PacketChestplateLauncher() {
    }

    public PacketChestplateLauncher(float amount) {
        this.amount = amount;
    }

    @Override
    public void handleClientSide(PacketChestplateLauncher message, EntityPlayer player) {
    }

    @Override
    public void handleServerSide(PacketChestplateLauncher message, EntityPlayer player) {
        World world = player.func_130014_f_();
        ItemStack stack = player.func_184592_cb();
        CommonHUDHandler handler = CommonHUDHandler.getHandlerForPlayer(player);
        int upgrades = handler.getUpgradeCount(EntityEquipmentSlot.CHEST, IItemRegistry.EnumUpgrade.DISPENSER, 4);
        if (handler.getArmorPressure(EntityEquipmentSlot.CHEST) > 0.1f && handler.isArmorReady(EntityEquipmentSlot.CHEST) && upgrades > 0 && !stack.func_190926_b()) {
            ItemStack toFire = player.field_71075_bZ.field_75098_d ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1) : stack.func_77979_a(1);
            Entity launchedEntity = TileEntityAirCannon.getEntityToLaunch(player.func_130014_f_(), toFire, player, true, true);
            if (launchedEntity instanceof EntityArrow) {
                EntityArrow arrow = (EntityArrow)launchedEntity;
                arrow.field_70251_a = player.field_71075_bZ.field_75098_d ? EntityArrow.PickupStatus.CREATIVE_ONLY : EntityArrow.PickupStatus.ALLOWED;
                arrow.func_70239_b(arrow.func_70242_d() + 0.25 * (double)upgrades * (double)message.amount);
            }
            Vec3d velocity = player.func_70040_Z().func_72432_b().func_186678_a((double)(message.amount * (float)upgrades * 0.7f));
            TileEntityAirCannon.launchEntity(launchedEntity, player.func_174824_e(1.0f).func_72441_c(0.0, -0.1, 0.0), velocity, true);
            int usedAir = (int)((float)(20 * upgrades) * message.amount);
            if (!player.field_71075_bZ.field_75098_d) {
                handler.addAir(player.func_184582_a(EntityEquipmentSlot.CHEST), EntityEquipmentSlot.CHEST, -usedAir);
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.amount = buf.readFloat();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeFloat(this.amount);
    }
}

