/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import me.desht.pneumaticcraft.common.GuiHandler;
import me.desht.pneumaticcraft.common.block.BlockPneumaticCraftModeled;
import me.desht.pneumaticcraft.common.tileentity.TileEntityOmnidirectionalHopper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockOmnidirectionalHopper
extends BlockPneumaticCraftModeled {
    private static final PropertyEnum<EnumFacing> INPUT = PropertyEnum.func_177709_a((String)"input", EnumFacing.class);

    BlockOmnidirectionalHopper(String registryName) {
        super(Material.field_151573_f, registryName);
    }

    BlockOmnidirectionalHopper() {
        super(Material.field_151573_f, "omnidirectional_hopper");
    }

    @Override
    protected Class<? extends TileEntity> getTileEntityClass() {
        return TileEntityOmnidirectionalHopper.class;
    }

    @Override
    public GuiHandler.EnumGuiId getGuiID() {
        return GuiHandler.EnumGuiId.OMNIDIRECTIONAL_HOPPER;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ROTATION, INPUT});
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return super.func_176203_a(meta).func_177226_a(INPUT, (Comparable)EnumFacing.field_82609_l[meta / 6 % 6]);
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        state = super.func_176221_a(state, worldIn, pos);
        TileEntityOmnidirectionalHopper te = (TileEntityOmnidirectionalHopper)PneumaticCraftUtils.getTileEntitySafely(worldIn, pos);
        return state.func_177226_a(INPUT, (Comparable)te.getInputDirection()).func_177226_a((IProperty)ROTATION, (Comparable)te.getRotation());
    }

    @Override
    protected EnumFacing getRotation(IBlockAccess world, BlockPos pos) {
        TileEntityOmnidirectionalHopper hopper = (TileEntityOmnidirectionalHopper)world.func_175625_s(pos);
        return hopper.getRotation();
    }

    @Override
    protected void setRotation(World world, BlockPos pos, EnumFacing rotation) {
        TileEntityOmnidirectionalHopper hopper = (TileEntityOmnidirectionalHopper)world.func_175625_s(pos);
        hopper.setRotation(rotation);
    }

    @Override
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)ROTATION, (Comparable)facing.func_176734_d()).func_177226_a(INPUT, (Comparable)PneumaticCraftUtils.getDirectionFacing(placer, true).func_176734_d());
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase par5EntityLiving, ItemStack par6ItemStack) {
        super.func_180633_a(world, pos, state, par5EntityLiving, par6ItemStack);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityOmnidirectionalHopper) {
            TileEntityOmnidirectionalHopper hopper = (TileEntityOmnidirectionalHopper)te;
            hopper.setInputDirection((EnumFacing)state.func_177229_b(INPUT));
            hopper.setRotation((EnumFacing)state.func_177229_b((IProperty)ROTATION));
        }
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    protected boolean canRotateToTopOrBottom() {
        return true;
    }

    @Override
    public boolean rotateBlock(World world, EntityPlayer player, BlockPos pos, EnumFacing face) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityOmnidirectionalHopper) {
            TileEntityOmnidirectionalHopper teOh = (TileEntityOmnidirectionalHopper)te;
            if (player != null && player.func_70093_af()) {
                EnumFacing rotation = this.getRotation((IBlockAccess)world, pos);
                if ((rotation = EnumFacing.func_82600_a((int)(rotation.ordinal() + 1))) == teOh.getInputDirection()) {
                    rotation = EnumFacing.func_82600_a((int)(rotation.ordinal() + 1));
                }
                this.setRotation(world, pos, rotation);
            } else {
                EnumFacing rotation = teOh.getInputDirection();
                if ((rotation = EnumFacing.func_82600_a((int)(rotation.ordinal() + 1))) == this.getRotation((IBlockAccess)world, pos)) {
                    rotation = EnumFacing.func_82600_a((int)(rotation.ordinal() + 1));
                }
                teOh.setInputDirection(rotation);
            }
            return true;
        }
        return false;
    }

    public RayTraceResult func_180636_a(IBlockState blockState, World world, BlockPos pos, Vec3d origin, Vec3d direction) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityOmnidirectionalHopper) {
            EnumFacing o = ((TileEntityOmnidirectionalHopper)te).getInputDirection();
            boolean isColliding = false;
            this.setBlockBounds(new AxisAlignedBB(o.func_82601_c() == 1 ? 0.625 : 0.0, o.func_96559_d() == 1 ? 0.625 : 0.0, o.func_82599_e() == 1 ? 0.625 : 0.0, o.func_82601_c() == -1 ? 0.375 : 1.0, o.func_96559_d() == -1 ? 0.375 : 1.0, o.func_82599_e() == -1 ? 0.375 : 1.0));
            if (super.func_180636_a(blockState, world, pos, origin, direction) != null) {
                isColliding = true;
            }
            this.setBlockBounds(new AxisAlignedBB(0.25, 0.25, 0.25, 0.75, 0.75, 0.75));
            if (super.func_180636_a(blockState, world, pos, origin, direction) != null) {
                isColliding = true;
            }
            this.setBlockBounds(field_185505_j);
            return isColliding ? super.func_180636_a(blockState, world, pos, origin, direction) : null;
        }
        return null;
    }
}

