/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.render.valuetype;

import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.integrateddynamics.api.client.render.valuetype.IValueTypeWorldRenderer;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.ingredient.IIngredientComponentHandler;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.client.render.valuetype.ValueTypeWorldRenderers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeIngredients;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.ingredient.IngredientComponentHandlers;

public class IngredientsValueTypeWorldRenderer
implements IValueTypeWorldRenderer {
    @Override
    public void renderValue(IPartContainer partContainer, double x, double y, double z, float partialTick, int destroyStage, EnumFacing direction, IPartType partType, IValue value, TileEntityRendererDispatcher rendererDispatcher, float alpha) {
        Optional ingredientsOptional = ((ValueObjectTypeIngredients.ValueIngredients)value).getRawValue();
        if (ingredientsOptional.isPresent()) {
            IMixedIngredients ingredients = (IMixedIngredients)ingredientsOptional.get();
            ArrayList values = Lists.newArrayList();
            for (IngredientComponent component : ingredients.getComponents()) {
                IIngredientComponentHandler componentHandler = IngredientComponentHandlers.REGISTRY.getComponentHandler(component);
                for (Object instance : ingredients.getInstances(component)) {
                    values.add(componentHandler.toValue(instance));
                }
            }
            IngredientsValueTypeWorldRenderer.renderGrid(partContainer, x, y, z, partialTick, destroyStage, direction, partType, values, rendererDispatcher, alpha);
        }
    }

    public static void renderGrid(IPartContainer partContainer, double x, double y, double z, float partialTick, int destroyStage, EnumFacing direction, IPartType partType, List<IValue> values, TileEntityRendererDispatcher rendererDispatcher, float alpha) {
        GlStateManager.func_179094_E();
        int matrixRadius = IngredientsValueTypeWorldRenderer.getSmallestSquareFrom(values.size());
        double scale = 1.0 / (double)matrixRadius;
        GlStateManager.func_179139_a((double)scale, (double)scale, (double)1.0);
        for (int i = 0; i < matrixRadius; ++i) {
            int realIndex;
            for (int j = 0; j < matrixRadius && (realIndex = i * matrixRadius + j) < values.size(); ++j) {
                IValueTypeWorldRenderer renderer;
                IValue renderValue = values.get(realIndex);
                if (renderValue == null) continue;
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)((float)j * 12.5f), (float)((float)i * 12.5f), (float)0.0f);
                if (renderValue instanceof ValueObjectTypeItemStack.ValueItemStack && ((ValueObjectTypeItemStack.ValueItemStack)renderValue).getRawValue().func_77960_j() == Short.MAX_VALUE) {
                    NonNullList subItems = ItemStackHelpers.getSubItems((ItemStack)((ValueObjectTypeItemStack.ValueItemStack)renderValue).getRawValue());
                    int subtick = (int)Minecraft.func_71410_x().field_71441_e.func_72820_D() / 10;
                    ItemStack itemStack = (ItemStack)IngredientsValueTypeWorldRenderer.prepareElementForTick(subItems, subtick, () -> ItemStack.field_190927_a);
                    renderValue = ValueObjectTypeItemStack.ValueItemStack.of(itemStack);
                }
                if ((renderer = ValueTypeWorldRenderers.REGISTRY.getRenderer(renderValue.getType())) == null) {
                    renderer = ValueTypeWorldRenderers.DEFAULT;
                }
                renderer.renderValue(partContainer, x, y, z, partialTick, destroyStage, direction, partType, renderValue, rendererDispatcher, alpha);
                GlStateManager.func_179121_F();
            }
        }
        GlStateManager.func_179121_F();
    }

    @Nullable
    protected static <T> T prepareElementForTick(List<T> elements, int tick, Supplier<T> defaultFactory) {
        return (T)(elements.size() > 0 ? elements.get(tick % elements.size()) : defaultFactory.get());
    }

    protected static int getSmallestSquareFrom(int n) {
        while (!IngredientsValueTypeWorldRenderer.isInt(Math.sqrt(n))) {
            ++n;
        }
        return (int)Math.sqrt(n);
    }

    protected static final boolean isInt(double n) {
        return n == Math.floor(n) && !Double.isInfinite(n);
    }
}

