/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib;

import com.brandon3055.brandonscore.lib.DLResourceLocation;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.TextureMetadataSection;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class ThreadedImageDownloader
extends SimpleTexture {
    private static final ResourceLocation RESOURCE_BROKEN_DOWNLOAD = new ResourceLocation("brandonscore".toLowerCase() + ":textures/loading_texture_failed.png");
    private static final AtomicInteger TEXTURE_DOWNLOADER_THREAD_ID = new AtomicInteger(0);
    private final File cacheFile;
    private final String resourceUrl;
    @Nullable
    private final IImageBuffer imageBuffer;
    @Nullable
    private Thread downloadThread;
    @Nullable
    private BufferedImage bufferedImage;
    private boolean textureUploadedToGPU;
    private volatile boolean downloadFailed = false;
    private DLResourceLocation dlLocation = null;

    public ThreadedImageDownloader(File cacheFile, String imageUrl, ResourceLocation textureLocation, @Nullable IImageBuffer imageBuffer) {
        super(textureLocation);
        this.cacheFile = cacheFile;
        this.resourceUrl = imageUrl;
        this.imageBuffer = imageBuffer;
    }

    public void setDlLocation(DLResourceLocation dlLocation) {
        this.dlLocation = dlLocation;
    }

    public void func_110551_a(IResourceManager resourceManager) throws IOException {
        if (this.bufferedImage == null && this.field_110568_b != null) {
            if (this.dlLocation != null && this.field_110568_b instanceof DLResourceLocation && ((DLResourceLocation)this.field_110568_b).sizeSet) {
                this.dlLocation.sizeSet = ((DLResourceLocation)this.field_110568_b).sizeSet;
                this.dlLocation.width = ((DLResourceLocation)this.field_110568_b).width;
                this.dlLocation.height = ((DLResourceLocation)this.field_110568_b).height;
                this.dlLocation.dlFailed = false;
                this.dlLocation.dlFinished = false;
            }
            super.func_110551_a(resourceManager);
        }
        if (this.downloadThread == null) {
            if (this.cacheFile != null && this.cacheFile.isFile()) {
                LogHelperBC.debug("Loading texture from local cache (%s)", this.cacheFile);
                try {
                    this.bufferedImage = ImageIO.read(this.cacheFile);
                    if (this.imageBuffer != null) {
                        this.setBufferedImage(this.imageBuffer.func_78432_a(this.bufferedImage));
                    }
                    if (this.dlLocation != null) {
                        this.dlLocation.width = this.bufferedImage.getWidth();
                        this.dlLocation.height = this.bufferedImage.getHeight();
                        this.dlLocation.sizeSet = true;
                        this.dlLocation.dlFailed = false;
                        this.dlLocation.dlFinished = true;
                    }
                }
                catch (IOException ioexception) {
                    LogHelperBC.error("Couldn't load texture %s %s", this.cacheFile, ioexception);
                    this.downloadTextureFromURL();
                }
            } else {
                this.downloadTextureFromURL();
            }
        } else if (this.downloadFailed) {
            this.loadBrokenTexture(resourceManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBrokenTexture(IResourceManager resourceManager) {
        this.func_147631_c();
        IResource iresource = null;
        try {
            iresource = resourceManager.func_110536_a(RESOURCE_BROKEN_DOWNLOAD);
            BufferedImage bufferedimage = TextureUtil.func_177053_a((InputStream)iresource.func_110527_b());
            boolean flag = false;
            boolean flag1 = false;
            if (iresource.func_110528_c()) {
                try {
                    TextureMetadataSection texturemetadatasection = (TextureMetadataSection)iresource.func_110526_a("texture");
                    if (texturemetadatasection != null) {
                        flag = texturemetadatasection.func_110479_a();
                        flag1 = texturemetadatasection.func_110480_b();
                    }
                }
                catch (RuntimeException runtimeexception) {
                    LogHelperBC.warn("Failed reading metadata of: %s %a", RESOURCE_BROKEN_DOWNLOAD, runtimeexception);
                }
            }
            TextureUtil.func_110989_a((int)this.func_110552_b(), (BufferedImage)bufferedimage, (boolean)flag, (boolean)flag1);
            LogHelperBC.warn("Unable to load resource from URL: " + this.resourceUrl);
            if (this.dlLocation != null) {
                this.dlLocation.width = bufferedimage.getWidth();
                this.dlLocation.height = bufferedimage.getHeight();
                this.dlLocation.sizeSet = true;
            }
        }
        catch (Exception e) {
            LogHelperBC.error("Failed to load broken texture");
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((Closeable)iresource);
        }
    }

    private void checkTextureUploadedToGPU() {
        if (!this.textureUploadedToGPU && this.bufferedImage != null) {
            if (this.field_110568_b != null) {
                this.func_147631_c();
            }
            TextureUtil.func_110987_a((int)super.func_110552_b(), (BufferedImage)this.bufferedImage);
            this.textureUploadedToGPU = true;
        }
        if (this.downloadFailed) {
            this.downloadFailed = false;
            this.loadBrokenTexture(Minecraft.func_71410_x().func_110442_L());
            if (this.dlLocation != null) {
                this.dlLocation.dlFinished = true;
                this.dlLocation.dlFailed = true;
            }
        }
    }

    public int func_110552_b() {
        this.checkTextureUploadedToGPU();
        return super.func_110552_b();
    }

    public void setBufferedImage(BufferedImage bufferedImageIn) {
        this.bufferedImage = bufferedImageIn;
        if (this.imageBuffer != null) {
            this.imageBuffer.func_152634_a();
        }
    }

    protected void downloadTextureFromURL() {
        this.downloadThread = new Thread("Texture Downloader #" + TEXTURE_DOWNLOADER_THREAD_ID.incrementAndGet()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HttpURLConnection httpurlconnection = null;
                LogHelperBC.debug("Downloading http texture from %s to %s", ThreadedImageDownloader.this.resourceUrl, ThreadedImageDownloader.this.cacheFile);
                try {
                    httpurlconnection = (HttpURLConnection)new URL(ThreadedImageDownloader.this.resourceUrl).openConnection(Minecraft.func_71410_x().func_110437_J());
                    httpurlconnection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
                    httpurlconnection.setDoInput(true);
                    httpurlconnection.setDoOutput(false);
                    httpurlconnection.connect();
                    int response = httpurlconnection.getResponseCode();
                    if (response / 100 == 2) {
                        BufferedImage bufferedimage;
                        if (ThreadedImageDownloader.this.cacheFile != null) {
                            FileUtils.copyInputStreamToFile((InputStream)httpurlconnection.getInputStream(), (File)ThreadedImageDownloader.this.cacheFile);
                            bufferedimage = ImageIO.read(ThreadedImageDownloader.this.cacheFile);
                        } else {
                            bufferedimage = TextureUtil.func_177053_a((InputStream)httpurlconnection.getInputStream());
                        }
                        if (ThreadedImageDownloader.this.imageBuffer != null) {
                            bufferedimage = ThreadedImageDownloader.this.imageBuffer.func_78432_a(bufferedimage);
                        }
                        if (ThreadedImageDownloader.this.dlLocation != null) {
                            ((ThreadedImageDownloader)ThreadedImageDownloader.this).dlLocation.width = bufferedimage.getWidth();
                            ((ThreadedImageDownloader)ThreadedImageDownloader.this).dlLocation.height = bufferedimage.getHeight();
                            ((ThreadedImageDownloader)ThreadedImageDownloader.this).dlLocation.sizeSet = true;
                            ((ThreadedImageDownloader)ThreadedImageDownloader.this).dlLocation.dlFailed = false;
                            ((ThreadedImageDownloader)ThreadedImageDownloader.this).dlLocation.dlFinished = true;
                        }
                        ThreadedImageDownloader.this.setBufferedImage(bufferedimage);
                        return;
                    }
                    LogHelperBC.error("Could not download resource. Server returned response code " + httpurlconnection.getResponseCode());
                    ThreadedImageDownloader.this.downloadFailed = true;
                    if (ThreadedImageDownloader.this.dlLocation != null) {
                        ((ThreadedImageDownloader)ThreadedImageDownloader.this).dlLocation.dlFinished = true;
                        ((ThreadedImageDownloader)ThreadedImageDownloader.this).dlLocation.dlFailed = true;
                    }
                }
                catch (Exception exception) {
                    LogHelperBC.error("Couldn't download http texture " + exception);
                    ThreadedImageDownloader.this.downloadFailed = true;
                    if (ThreadedImageDownloader.this.dlLocation != null) {
                        ((ThreadedImageDownloader)ThreadedImageDownloader.this).dlLocation.dlFinished = true;
                        ((ThreadedImageDownloader)ThreadedImageDownloader.this).dlLocation.dlFailed = true;
                    }
                    return;
                }
                finally {
                    if (httpurlconnection != null) {
                        httpurlconnection.disconnect();
                    }
                }
            }
        };
        this.downloadThread.setDaemon(true);
        this.downloadThread.start();
    }
}

