/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Sanity {
    private Sanity() {
    }

    @Nonnull
    public static <Type> Type nullCheck(@Nullable Type object, @Nonnull String failMessage) {
        if (object == null) {
            throw new IllegalArgumentException(failMessage);
        }
        return object;
    }

    @Nonnull
    public static <Type> Type[] nullCheck(@Nullable Type[] array, @Nonnull String failMessage) {
        Sanity.nullCheck(array, failMessage);
        for (Type element : array) {
            Sanity.nullCheck(element, failMessage);
        }
        return array;
    }

    public static void truthiness(boolean bool, @Nonnull String failMessage) {
        if (!bool) {
            throw new IllegalArgumentException(failMessage);
        }
    }

    @Nonnull
    public static String safeMessageCheck(@Nonnull String message) {
        return Sanity.safeMessageCheck(message, "Message");
    }

    @Nonnull
    public static String safeMessageCheck(@Nullable String message, @Nonnull String name) {
        Sanity.nullCheck(message, name + " cannot be null");
        for (char ch : message.toCharArray()) {
            if (ch != '\n' && ch != '\r' && ch != '\u0000') continue;
            throw new IllegalArgumentException(name + " cannot contain CR, LF, or NUL");
        }
        return message;
    }
}

