/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.gui;

import com.google.common.base.Splitter;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.creeperhost.minetogether.CreeperHost;
import net.creeperhost.minetogether.Util;
import net.creeperhost.minetogether.api.Order;
import net.creeperhost.minetogether.common.IOrderValidation;
import net.creeperhost.minetogether.common.RegexValidator;
import net.creeperhost.minetogether.gui.DefferedValidation;
import net.creeperhost.minetogether.gui.GuiGetServer;
import net.creeperhost.minetogether.gui.element.TextFieldDetails;
import net.creeperhost.minetogether.paul.Callbacks;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentBase;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class GuiPersonalDetails
extends GuiGetServer {
    public List<TextFieldDetails> fields = null;
    public TextFieldDetails focusedField;
    public boolean isEmailValid = false;
    private boolean loginMode;
    private GuiButton loginButton;
    private boolean loggingIn;
    private String loggingInError = "";
    private boolean loggedIn;
    private boolean isSure;
    private boolean orderPressed;
    private ITextComponent info2 = null;
    private String prevLoginString;
    private boolean prevLoginVisible;
    private boolean prevLoginEnabled;

    public GuiPersonalDetails(int stepId, Order order) {
        super(stepId, order);
        order.clientID = "";
    }

    @Override
    public String getStepName() {
        return Util.localize("gui.personal_details", new Object[0]);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.loginButton = new GuiButton(80085, this.field_146294_l / 2 - 40, this.field_146295_m / 2 - 10, 80, 20, Util.localize("button.login", new Object[0]));
        this.loginButton.field_146125_m = this.loginMode;
        if (this.orderPressed && !this.isSure) {
            this.loginButton.field_146126_j = Util.localize("button.order", new Object[0]);
            this.loginButton.field_146124_l = true;
            this.loginButton.field_146125_m = true;
            this.buttonNext.field_146125_m = false;
        } else if (this.loggingIn) {
            this.loginButton.field_146126_j = Util.localize("button.logging", new Object[0]);
            this.loginButton.field_146124_l = false;
        } else if (this.loggedIn) {
            this.loginButton.field_146126_j = Util.localize("button.done", new Object[0]);
            this.loginButton.field_146124_l = false;
        } else if (!this.loggingInError.isEmpty()) {
            this.loginButton.field_146126_j = Util.localize("button.logintryagain", new Object[0]);
        }
        this.field_146292_n.add(this.loginButton);
        this.fields = new ArrayList<TextFieldDetails>();
        int x = this.field_146294_l / 2;
        int fieldWidths = 185;
        ArrayList<IOrderValidation> defaultValidators = new ArrayList<IOrderValidation>();
        defaultValidators.add(new IOrderValidation(){

            @Override
            public boolean validationCheckAtPhase(IOrderValidation.ValidationPhase phase) {
                return phase.equals((Object)IOrderValidation.ValidationPhase.CHANGED);
            }

            @Override
            public boolean isValid(String string) {
                return !string.isEmpty();
            }

            @Override
            public boolean isAsync() {
                return false;
            }

            @Override
            public String getValidationMessage() {
                return "Cannot be blank";
            }

            @Override
            public String getName() {
                return "NotBlankValidator";
            }
        });
        ArrayList<IOrderValidation> emailValidators = new ArrayList<IOrderValidation>(defaultValidators);
        emailValidators.add(new RegexValidator("(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)\\])", "Invalid email address"));
        emailValidators.add(new DefferedValidation(){

            @Override
            public boolean validationCheckAtPhase(IOrderValidation.ValidationPhase phase) {
                return phase.equals((Object)IOrderValidation.ValidationPhase.FOCUSLOST);
            }

            @Override
            public boolean isValidReal(String string) {
                return Callbacks.doesEmailExist(string);
            }

            @Override
            public String getMessageReal() {
                return "Email already exists";
            }

            @Override
            public String getName() {
                return "NotEmailExistsValidator";
            }
        });
        this.fields.add(new TextFieldDetails(this, 0, Util.localize("info.e_mail", new Object[0]), this.order.emailAddress, x - 205, 45, fieldWidths, 20, emailValidators));
        this.fields.add(new TextFieldDetails(this, 1, Util.localize("info.password", new Object[0]), this.order.password, x + 5, 45, fieldWidths, 20, defaultValidators, "*"));
        this.fields.add(new TextFieldDetails(this, 2, Util.localize("info.first_name", new Object[0]), this.order.firstName, x - 205, 75, fieldWidths, 20, defaultValidators));
        this.fields.add(new TextFieldDetails(this, 3, Util.localize("info.last_name", new Object[0]), this.order.lastName, x + 5, 75, fieldWidths, 20, defaultValidators));
        this.fields.add(new TextFieldDetails(this, 4, Util.localize("info.address", new Object[0]), this.order.address, x - 205, 105, fieldWidths, 20, defaultValidators));
        this.fields.add(new TextFieldDetails(this, 5, Util.localize("info.city", new Object[0]), this.order.city, x + 5, 105, fieldWidths, 20, defaultValidators));
        this.fields.add(new TextFieldDetails(this, 6, Util.localize("info.zip", new Object[0]), this.order.zip, x - 205, 135, fieldWidths, 20, defaultValidators));
        this.fields.add(new TextFieldDetails(this, 7, Util.localize("info.state", new Object[0]), this.order.state, x + 5, 135, fieldWidths, 20, defaultValidators));
        TextFieldDetails countryField = new TextFieldDetails(this, 8, Util.localize("info.country", new Object[0]), Callbacks.getCountries().get(this.order.country), x - 205, 165, fieldWidths, 20, defaultValidators, false);
        this.fields.add(countryField);
        this.fields.add(new TextFieldDetails(this, 9, Util.localize("info.phone", new Object[0]), this.order.phone, x + 5, 165, fieldWidths, 20, defaultValidators));
        String info2Text = Util.localize("order.info2", new Object[0]);
        String regex = "\\((.*?)\\|(.*?)\\)";
        Pattern pattern = Pattern.compile("\\((.*?)\\|(.*?)\\)");
        Matcher matcher = pattern.matcher(info2Text);
        int lastEnd = 0;
        TextComponentString component = null;
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            String part = info2Text.substring(lastEnd, start);
            if (part.length() > 0) {
                if (component == null) {
                    component = new TextComponentString(part);
                } else {
                    component.func_150258_a(part);
                }
            }
            lastEnd = end;
            TextComponentString link = new TextComponentString(matcher.group(1));
            Style style = link.func_150256_b();
            style.func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, matcher.group(2)));
            style.func_150238_a(TextFormatting.BLUE);
            style.func_150228_d(Boolean.valueOf(true));
            style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString(Util.localize("order.url", new Object[0]))));
            if (component == null) {
                component = link;
                continue;
            }
            component.func_150257_a((ITextComponent)link);
        }
        this.info2 = component;
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.buttonNext.field_146124_l = true;
        this.loginButton.field_146125_m = this.loginMode || this.orderPressed && !this.isSure;
        for (TextFieldDetails field : this.fields) {
            field.checkPendingValidations();
            field.func_146178_a();
            if (field.isValidated) continue;
            this.buttonNext.field_146124_l = false;
        }
        this.buttonNext.field_146124_l = this.buttonNext.field_146124_l && this.isEmailValid;
        this.buttonNext.field_146124_l = this.loggedIn || this.buttonNext.field_146124_l;
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        TextFieldDetails field = this.focusedField;
        if (this.focusedField == null) {
            return;
        }
        if (keyCode == 15) {
            int adjustAm = 1;
            if (GuiPersonalDetails.func_146272_n()) {
                adjustAm = -1;
            }
            int fieldsSize = this.fields.size();
            field.func_146195_b(false);
            int newField = (field.func_175206_d() + adjustAm) % fieldsSize;
            if (newField == -1) {
                newField = fieldsSize - 1;
            }
            TextFieldDetails newF = null;
            while (newF == null) {
                TextFieldDetails tempField = this.fields.get(newField);
                if (tempField.canBeFocused()) {
                    newF = tempField;
                    continue;
                }
                if ((newField = (newField + adjustAm) % fieldsSize) != -1) continue;
                newField = fieldsSize - 1;
            }
            newF.func_146195_b(true);
            return;
        }
        if (field.func_146201_a(typedChar, keyCode)) {
            int id = field.func_175206_d();
            String text = field.func_146179_b().trim();
            switch (id) {
                case 0: {
                    this.order.emailAddress = text;
                    break;
                }
                case 1: {
                    this.order.password = text;
                    break;
                }
                case 2: {
                    this.order.firstName = text;
                    break;
                }
                case 3: {
                    this.order.lastName = text;
                    break;
                }
                case 4: {
                    this.order.address = text;
                    break;
                }
                case 5: {
                    this.order.city = text;
                    break;
                }
                case 6: {
                    this.order.zip = text;
                    break;
                }
                case 7: {
                    this.order.state = text;
                    break;
                }
                case 8: {
                    this.order.country = text;
                    break;
                }
                case 9: {
                    this.order.phone = text;
                }
            }
            return;
        }
        super.func_73869_a(typedChar, keyCode);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (!(this.orderPressed && this.isSure || this.loginMode)) {
            this.func_73732_a(this.field_146289_q, "No data will be sent until you complete the order.", this.field_146294_l / 2, this.field_146295_m - 45, 0xFFFFFF);
        }
        if (!this.orderPressed || this.isSure) {
            for (TextFieldDetails field : this.fields) {
                if (this.loginMode) {
                    if (field.func_175206_d() >= 2) continue;
                    field.func_146194_f();
                    continue;
                }
                field.func_146194_f();
            }
            if (this.loginMode) {
                if (this.loggingIn) {
                    this.func_73732_a(this.field_146289_q, Util.localize("details.login", new Object[0]), this.field_146294_l / 2, this.field_146295_m / 2 - 20, 0xFFFFFF);
                } else if (!this.loggingInError.isEmpty()) {
                    this.func_73732_a(this.field_146289_q, Util.localize("details.loginerror", new Object[0]) + this.loggingInError, this.field_146294_l / 2, this.field_146295_m / 2 - 20, 0xFFFFFF);
                } else if (this.loggedIn) {
                    this.func_73732_a(this.field_146289_q, Util.localize("details.loginsuccess", new Object[0]), this.field_146294_l / 2, this.field_146295_m / 2 - 20, 0xFFFFFF);
                } else {
                    this.func_73732_a(this.field_146289_q, Util.localize("details.accountexists", new Object[0]), this.field_146294_l / 2, this.field_146295_m / 2 - 20, 0xFFFFFF);
                }
            }
        } else {
            HoverEvent event;
            ITextComponent component;
            int info2Start = this.field_146295_m / 2 - 50;
            this.func_73732_a(this.field_146289_q, Util.localize("order.info1", new Object[0]), this.field_146294_l / 2, this.field_146295_m / 2 - 60, 0xFFFFFF);
            this.func_73732_a(this.field_146289_q, this.info2.func_150254_d(), this.field_146294_l / 2, this.field_146295_m / 2 - 50, 0xFFFFFF);
            this.func_73732_a(this.field_146289_q, Util.localize("order.info3", new Object[0]), this.field_146294_l / 2, this.field_146295_m / 2 - 30, 0xFFFFFF);
            this.func_73732_a(this.field_146289_q, Util.localize("order.info4", new Object[0]), this.field_146294_l / 2, this.field_146295_m / 2 - 20, 0xFFFFFF);
            if (mouseY >= info2Start && mouseY <= info2Start + this.field_146289_q.field_78288_b && (component = this.getComponent(mouseX, mouseY)) != null && (event = component.func_150256_b().func_150210_i()) != null && event.func_150701_a() == HoverEvent.Action.SHOW_TEXT) {
                this.func_146283_a(Splitter.on((String)"\n").splitToList((CharSequence)event.func_150702_b().func_150254_d()), mouseX, mouseY);
            }
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        ITextComponent comp;
        ClickEvent clickevent;
        super.func_73864_a(mouseX, mouseY, mouseButton);
        int info2Start = this.field_146295_m / 2 - 50;
        if (this.orderPressed && !this.isSure && mouseY >= info2Start && mouseY <= info2Start + this.field_146289_q.field_78288_b && (clickevent = (comp = this.getComponent(mouseX, mouseY)).func_150256_b().func_150235_h()) != null && clickevent.func_150669_a() == ClickEvent.Action.OPEN_URL) {
            try {
                URI uri = new URI(clickevent.func_150668_b());
                Class<?> oclass = Class.forName("java.awt.Desktop");
                Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
                oclass.getMethod("browse", URI.class).invoke(object, uri);
            }
            catch (Throwable t) {
                CreeperHost.logger.error("Can't open url for " + clickevent, t);
            }
            return;
        }
        for (TextFieldDetails field : this.fields) {
            field.myMouseClicked(mouseX, mouseY, mouseButton);
        }
    }

    private ITextComponent getComponent(int mouseX, int mouseY) {
        int stringWidth = this.field_146289_q.func_78256_a(this.info2.func_150254_d());
        int begin = this.field_146294_l / 2 - stringWidth / 2;
        if (this.info2 instanceof TextComponentBase) {
            TextComponentBase comp = (TextComponentBase)this.info2;
            int prevWidth = begin;
            for (ITextComponent inner : comp) {
                StringBuilder stringbuilder = new StringBuilder();
                String s = inner.func_150261_e();
                if (!s.isEmpty()) {
                    stringbuilder.append(inner.func_150256_b().func_150218_j());
                    stringbuilder.append(s);
                    stringbuilder.append(TextFormatting.RESET);
                }
                int width = this.field_146289_q.func_78256_a(stringbuilder.toString());
                if (mouseX >= prevWidth && mouseX <= prevWidth + width) {
                    return inner;
                }
                prevWidth += width;
            }
        }
        return null;
    }

    @Override
    protected void func_146284_a(final GuiButton button) throws IOException {
        if (button.field_146127_k == 80085) {
            if (this.orderPressed && !this.isSure) {
                this.isSure = true;
                this.func_146284_a(this.buttonNext);
                return;
            }
            this.loggingIn = true;
            button.field_146124_l = false;
            button.field_146126_j = Util.localize("button.logging", new Object[0]);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    String result = Callbacks.doLogin(GuiPersonalDetails.this.order.emailAddress, GuiPersonalDetails.this.order.password);
                    String[] resultSplit = result.split(":");
                    if (resultSplit[0].equals("success")) {
                        GuiPersonalDetails.this.order.currency = resultSplit[1] != null ? resultSplit[1] : "1";
                        GuiPersonalDetails.this.order.clientID = resultSplit[2] != null ? resultSplit[2] : "98874";
                        GuiPersonalDetails.this.loggingIn = false;
                        GuiPersonalDetails.this.loggedIn = true;
                        GuiPersonalDetails.this.loggingInError = "";
                        button.field_146126_j = Util.localize("button.done", new Object[0]);
                    } else {
                        GuiPersonalDetails.this.loggingIn = false;
                        GuiPersonalDetails.this.loggedIn = false;
                        GuiPersonalDetails.this.loggingInError = result;
                        button.field_146124_l = true;
                        button.field_146126_j = Util.localize("button.logintryagain", new Object[0]);
                    }
                }
            };
            Thread thread = new Thread(runnable);
            thread.start();
            return;
        }
        if (button.field_146127_k == this.buttonNext.field_146127_k && !this.isSure) {
            this.orderPressed = true;
            this.buttonNext.field_146125_m = false;
            this.prevLoginString = this.loginButton.field_146126_j;
            this.loginButton.field_146126_j = Util.localize("button.order", new Object[0]);
            this.prevLoginVisible = this.loginButton.field_146125_m;
            this.loginButton.field_146125_m = true;
            this.prevLoginEnabled = this.loginButton.field_146124_l;
            this.loginButton.field_146124_l = true;
            return;
        }
        if (button.field_146127_k == this.buttonNext.field_146127_k && !this.isSure) {
            this.orderPressed = true;
            this.buttonNext.field_146125_m = false;
            this.prevLoginString = this.loginButton.field_146126_j;
            this.loginButton.field_146126_j = Util.localize("button.order", new Object[0]);
            this.prevLoginVisible = this.loginButton.field_146125_m;
            this.loginButton.field_146125_m = true;
            this.prevLoginEnabled = this.loginButton.field_146124_l;
            this.loginButton.field_146124_l = true;
            return;
        }
        if (button.field_146127_k == this.buttonPrev.field_146127_k && this.orderPressed) {
            this.orderPressed = false;
            this.buttonNext.field_146125_m = true;
            this.loginButton.field_146126_j = this.prevLoginString;
            this.loginButton.field_146125_m = this.prevLoginVisible;
            this.loginButton.field_146124_l = this.prevLoginEnabled;
            return;
        }
        super.func_146284_a(button);
    }

    public void validationChanged(TextFieldDetails details, boolean valid, IOrderValidation validator, IOrderValidation.ValidationPhase phase) {
        if (details.func_175206_d() == 0) {
            if (!valid && validator.getName().equals("NotEmailExistsValidator") && !validator.isAsync()) {
                this.isEmailValid = false;
                this.loginMode = true;
            } else {
                this.loginMode = false;
                this.isEmailValid = phase.equals((Object)IOrderValidation.ValidationPhase.FOCUSLOST);
            }
        }
    }

    public void validationChangedDeferred(TextFieldDetails textFieldDetails, DefferedValidation pendingValidation) {
        textFieldDetails.func_146184_c(true);
        if (!pendingValidation.isValid("")) {
            this.validationChanged(textFieldDetails, false, pendingValidation, pendingValidation.getPhase());
        } else {
            this.validationChanged(textFieldDetails, true, null, pendingValidation.getPhase());
        }
    }
}

