/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.util.text_components;

import com.feed_the_beast.ftblib.lib.util.StringUtils;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class TextComponentParser {
    private String text;
    private Function<String, ITextComponent> substitutes;
    private ITextComponent component;
    private StringBuilder builder;
    private Style style;

    public static ITextComponent parse(String text, @Nullable Function<String, ITextComponent> substitutes) {
        return new TextComponentParser(text, substitutes).parse();
    }

    private TextComponentParser(String txt, @Nullable Function<String, ITextComponent> sub) {
        this.text = txt;
        this.substitutes = sub;
    }

    private ITextComponent parse() {
        if (this.text.isEmpty()) {
            return new TextComponentString("");
        }
        char[] c = this.text.toCharArray();
        boolean hasSpecialCodes = false;
        for (char c1 : c) {
            if (c1 != '{' && c1 != '&' && c1 != '\u00a7') continue;
            hasSpecialCodes = true;
            break;
        }
        if (!hasSpecialCodes) {
            return new TextComponentString(this.text);
        }
        this.component = new TextComponentString("");
        this.style = new Style();
        this.builder = new StringBuilder();
        boolean sub = false;
        for (int i = 0; i < c.length; ++i) {
            boolean end;
            boolean escape = i > 0 && c[i - 1] == '\\';
            boolean bl = end = i == c.length - 1;
            if (sub && (end || c[i] == '{' || c[i] == '}')) {
                if (c[i] == '{') {
                    throw new IllegalArgumentException("Invalid formatting! Can't nest multiple substitutes!");
                }
                this.finishPart();
                sub = false;
                continue;
            }
            if (!escape) {
                if (c[i] == '&') {
                    c[i] = 167;
                }
                if (c[i] == '\u00a7') {
                    TextFormatting formatting;
                    this.finishPart();
                    if (end) {
                        throw new IllegalArgumentException("Invalid formatting! Can't end string with & or \u00a7!");
                    }
                    if ((formatting = (TextFormatting)StringUtils.CODE_TO_FORMATTING.get(c[++i])) == null) {
                        throw new IllegalArgumentException("Illegal formatting! Unknown color code character: " + c[i] + "!");
                    }
                    switch (formatting) {
                        case OBFUSCATED: {
                            this.style.func_150237_e(Boolean.valueOf(!this.style.func_150233_f()));
                            break;
                        }
                        case BOLD: {
                            this.style.func_150227_a(Boolean.valueOf(!this.style.func_150223_b()));
                            break;
                        }
                        case STRIKETHROUGH: {
                            this.style.func_150225_c(Boolean.valueOf(!this.style.func_150236_d()));
                            break;
                        }
                        case UNDERLINE: {
                            this.style.func_150228_d(Boolean.valueOf(!this.style.func_150234_e()));
                            break;
                        }
                        case ITALIC: {
                            this.style.func_150217_b(Boolean.valueOf(!this.style.func_150242_c()));
                            break;
                        }
                        case RESET: {
                            this.style = new Style();
                            break;
                        }
                        default: {
                            this.style.func_150238_a(formatting);
                            break;
                        }
                    }
                    continue;
                }
                if (c[i] == '{') {
                    this.finishPart();
                    if (end) {
                        throw new IllegalArgumentException("Invalid formatting! Can't end string with {!");
                    }
                    sub = true;
                }
            }
            if (c[i] == '\\' && !escape) continue;
            this.builder.append(c[i]);
        }
        this.finishPart();
        return this.component;
    }

    private void finishPart() {
        String string = this.builder.toString();
        this.builder.setLength(0);
        if (string.isEmpty()) {
            return;
        }
        if (string.length() < 2 || string.charAt(0) != '{') {
            TextComponentString component1 = new TextComponentString(string);
            component1.func_150255_a(this.style.func_150232_l());
            this.component.func_150257_a((ITextComponent)component1);
            return;
        }
        ITextComponent component1 = this.substitutes.apply(string.substring(1));
        if (component1 == null) {
            throw new IllegalArgumentException("Invalid formatting! Unknown substitute " + string);
        }
        Style style0 = component1.func_150256_b().func_150232_l();
        Style style1 = this.style.func_150232_l();
        style1.func_150209_a(style0.func_150210_i());
        style1.func_150241_a(style0.func_150235_h());
        style1.func_179989_a(style0.func_179986_j());
        component1.func_150255_a(style1);
        this.component.func_150257_a(component1);
    }
}

