/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.config;

import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.ConfigValueInstance;
import com.feed_the_beast.ftblib.lib.gui.IOpenableGui;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiSelectItemStack;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.item.ItemStackSerializer;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class ConfigItemStack
extends ConfigValue {
    public static final String ID = "item_stack";
    private ItemStack value;
    private boolean singleItemOnly;

    public ConfigItemStack(ItemStack is, boolean b) {
        this.value = is.func_190926_b() ? ItemStack.field_190927_a : is;
        this.singleItemOnly = b;
        if (this.singleItemOnly && this.value.func_190916_E() > 1) {
            this.value.func_190920_e(1);
        }
    }

    public ConfigItemStack(ItemStack is) {
        this(is, false);
    }

    public String func_176610_l() {
        return ID;
    }

    public ItemStack getStack() {
        return this.value;
    }

    public void setStack(ItemStack is) {
        ItemStack itemStack = this.value = is.func_190926_b() ? ItemStack.field_190927_a : is;
        if (this.getSingleItemOnly() && this.value.func_190916_E() > 1) {
            this.value.func_190920_e(1);
        }
    }

    public boolean getSingleItemOnly() {
        return this.singleItemOnly;
    }

    public void setSingleItemOnly(boolean v) {
        this.singleItemOnly = v;
    }

    @Override
    public String getString() {
        return this.getStack().serializeNBT().toString();
    }

    @Override
    public boolean getBoolean() {
        return this.getInt() > 0;
    }

    @Override
    public int getInt() {
        return this.getStack().func_190916_E();
    }

    @Override
    public ConfigItemStack copy() {
        return new ConfigItemStack(this.getStack(), this.getSingleItemOnly());
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String key) {
        this.value = this.getStack();
        if (!this.value.func_190926_b()) {
            nbt.func_74782_a(key, (NBTBase)this.value.serializeNBT());
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String key) {
        NBTTagCompound nbt1 = nbt.func_74775_l(key);
        if (nbt1.func_82582_d()) {
            this.setStack(ItemStack.field_190927_a);
        } else {
            this.setStack(new ItemStack(nbt1));
        }
    }

    @Override
    public void writeData(DataOut data) {
        data.writeItemStack(this.getStack());
        data.writeBoolean(this.getSingleItemOnly());
    }

    @Override
    public void readData(DataIn data) {
        this.setStack(data.readItemStack());
        this.setSingleItemOnly(data.readBoolean());
    }

    @Override
    public boolean isEmpty() {
        return this.getStack().func_190926_b();
    }

    @Override
    public ITextComponent getStringForGUI() {
        this.value = this.getStack();
        if (this.value.func_190916_E() <= 1) {
            return new TextComponentString(this.value.func_82833_r());
        }
        return new TextComponentString(this.value.func_190916_E() + "x " + this.value.func_82833_r());
    }

    @Override
    public void onClicked(IOpenableGui gui, ConfigValueInstance inst, MouseButton button) {
        if (inst.getCanEdit()) {
            new GuiSelectItemStack(gui, this.getStack().func_77946_l(), this.getSingleItemOnly(), this::setStack).openGui();
        }
    }

    @Override
    public boolean setValueFromString(@Nullable ICommandSender sender, String string, boolean simulate) {
        if (string.isEmpty()) {
            return false;
        }
        try {
            ItemStack stack = ItemStackSerializer.parseItemThrowingException(string);
            if (stack.func_190916_E() > 1 && this.getSingleItemOnly()) {
                return false;
            }
            if (!simulate) {
                this.setStack(stack);
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public void setValueFromOtherValue(ConfigValue value) {
        if (value instanceof ConfigItemStack) {
            this.setStack(((ConfigItemStack)value).getStack().func_77946_l());
        } else {
            super.setValueFromOtherValue(value);
        }
    }

    public static class SimpleStack
    extends ConfigItemStack {
        private final Supplier<ItemStack> get;
        private final Consumer<ItemStack> set;

        public SimpleStack(boolean single, Supplier<ItemStack> g, Consumer<ItemStack> s) {
            super(ItemStack.field_190927_a, single);
            this.get = g;
            this.set = s;
        }

        public SimpleStack(Supplier<ItemStack> g, Consumer<ItemStack> s) {
            this(false, g, s);
        }

        @Override
        public ItemStack getStack() {
            return this.get.get();
        }

        @Override
        public void setStack(ItemStack v) {
            this.set.accept(v);
        }
    }
}

