/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.monkmod;

import com.rwtema.monkmod.ClientRunnable;
import com.rwtema.monkmod.MonkManager;
import com.rwtema.monkmod.MonkTextures;
import com.rwtema.monkmod.advancements.MonkAdvancements;
import com.rwtema.monkmod.advancements.MonkCriterionTrigger;
import com.rwtema.monkmod.command.CommandMonkLevelManip;
import com.rwtema.monkmod.config.MonkConfiguration;
import com.rwtema.monkmod.data.MonkData;
import com.rwtema.monkmod.factory.Factory;
import com.rwtema.monkmod.item.ItemMonkBase;
import com.rwtema.monkmod.network.MonkNetwork;
import com.rwtema.monkmod.render.HUDProgress;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.command.ICommand;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Logger;

@Mod(modid="monk", name="Monk Mod", version="1.4", acceptedMinecraftVersions="[1.12.2]")
public class MonkMod {
    public static final String MODID = "monk";
    public static final String NAME = "Monk Mod";
    public static final String VERSION = "1.4";
    public static final MonkCriterionTrigger TRIGGER = (MonkCriterionTrigger)CriteriaTriggers.func_192118_a((ICriterionTrigger)new MonkCriterionTrigger());
    public static final ItemMonkBase ITEM_MONK_BASE = new ItemMonkBase();
    public static int MAX_LEVEL;
    public static Logger logger;
    public static final int config_version = 3;
    @Mod.Instance(value="monk")
    public static MonkMod instance;
    public static boolean debug;
    public static Configuration config;

    @Mod.EventHandler
    public void preInit(@Nonnull FMLPreInitializationEvent event) {
        logger = event.getModLog();
        config = new Configuration(event.getSuggestedConfigurationFile());
        CapabilityManager.INSTANCE.register(MonkData.class, (Capability.IStorage)new Capability.IStorage<MonkData>(){

            @Nullable
            public NBTBase writeNBT(Capability<MonkData> capability, @Nonnull MonkData instance, EnumFacing side) {
                return instance.serializeNBT();
            }

            public void readNBT(Capability<MonkData> capability, @Nonnull MonkData instance, EnumFacing side, NBTBase nbt) {
                instance.deserializeNBT((NBTTagCompound)nbt);
            }
        }, () -> {
            throw new RuntimeException();
        });
        MinecraftForge.EVENT_BUS.register(MonkManager.class);
        MinecraftForge.EVENT_BUS.register((Object)HUDProgress.INSTANCE);
        Factory.init();
        MonkConfiguration.load();
        ResourceLocation location = new ResourceLocation(MODID, "monk_level");
        ITEM_MONK_BASE.setRegistryName(location);
        ITEM_MONK_BASE.func_77655_b(location.toString());
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)ITEM_MONK_BASE);
        new ClientRunnable(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public void run() {
                MonkTextures.init();
            }
        }.run();
        MonkNetwork.init();
        if (config.hasChanged()) {
            config.save();
        }
    }

    @Mod.EventHandler
    public void onServerAboutToStartEvent(@Nonnull FMLServerAboutToStartEvent event) {
        MonkAdvancements.registerAdvancements(event.getServer());
    }

    @Mod.EventHandler
    public void onServerStart(@Nonnull FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandMonkLevelManip());
    }

    static {
        debug = false;
        try {
            World.class.getDeclaredMethod("getBlockState", BlockPos.class);
            debug = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

