/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.tileentity;

import net.minecraft.nbt.NBTTagCompound;
import org.cyclops.cyclopscore.datastructure.EnumFacingMap;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.integrateddynamics.api.block.cable.ICable;
import org.cyclops.integrateddynamics.capability.cable.CableConfig;
import org.cyclops.integrateddynamics.capability.cable.CableTile;
import org.cyclops.integrateddynamics.capability.network.NetworkCarrierConfig;
import org.cyclops.integrateddynamics.capability.network.NetworkCarrierDefault;
import org.cyclops.integrateddynamics.capability.path.PathElementConfig;
import org.cyclops.integrateddynamics.capability.path.PathElementTile;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;

public class TileCableConnectable
extends CyclopsTileEntity
implements CyclopsTileEntity.ITickingTile {
    protected final CyclopsTileEntity.ITickingTile tickingTileComponent = new CyclopsTileEntity.TickingTileComponent((CyclopsTileEntity)this);
    @NBTPersist
    private EnumFacingMap<Boolean> connected = EnumFacingMap.newMap();
    private final ICable cable = new CableTile<TileCableConnectable>(this){

        @Override
        protected boolean isForceDisconnectable() {
            return false;
        }

        @Override
        protected EnumFacingMap<Boolean> getForceDisconnected() {
            return null;
        }

        @Override
        protected EnumFacingMap<Boolean> getConnected() {
            return ((TileCableConnectable)this.tile).connected;
        }
    };

    public TileCableConnectable() {
        this.addCapabilityInternal(CableConfig.CAPABILITY, this.cable);
        this.addCapabilityInternal(NetworkCarrierConfig.CAPABILITY, new NetworkCarrierDefault());
        this.addCapabilityInternal(PathElementConfig.CAPABILITY, new PathElementTile<TileCableConnectable>(this, this.cable));
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.connected.clear();
    }

    protected void updateTileEntity() {
        super.updateTileEntity();
        if (this.connected.isEmpty()) {
            this.cable.updateConnections();
        }
        if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
            NetworkHelpers.revalidateNetworkElements(this.func_145831_w(), this.func_174877_v());
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
            NetworkHelpers.invalidateNetworkElements(this.func_145831_w(), this.func_174877_v());
        }
    }

    public ICable getCable() {
        return this.cable;
    }

    public void func_73660_a() {
        this.tickingTileComponent.func_73660_a();
    }
}

