/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.part.aspect.property;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectProperties;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectPropertyTypeInstance;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.part.aspect.property.AspectPropertyTypeInstance;

public class AspectProperties
implements IAspectProperties {
    private final Map<IAspectPropertyTypeInstance, IValue> values = Maps.newLinkedHashMap();

    public AspectProperties(Collection<IAspectPropertyTypeInstance> propertyTypes) {
        for (IAspectPropertyTypeInstance propertyType : propertyTypes) {
            this.values.put(propertyType, (IValue)propertyType.getType().getDefault());
        }
    }

    public AspectProperties() {
    }

    @Override
    @Deprecated
    public Collection<IAspectPropertyTypeInstance> getTypes() {
        return Collections.unmodifiableCollection(this.values.keySet());
    }

    @Override
    public <T extends IValueType<V>, V extends IValue> V getValue(IAspectPropertyTypeInstance<T, V> type) {
        IValue value = this.values.get(type);
        if (value == null) {
            value = type.getType().getDefault();
        }
        return (V)value;
    }

    @Override
    public <T extends IValueType<V>, V extends IValue> void setValue(IAspectPropertyTypeInstance<T, V> type, V value) {
        this.values.put(type, value);
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList map = new NBTTagList();
        for (Map.Entry<IAspectPropertyTypeInstance, IValue> entry : this.values.entrySet()) {
            NBTTagCompound nbtEntry = new NBTTagCompound();
            nbtEntry.func_74778_a("key", entry.getKey().getType().getUnlocalizedName());
            nbtEntry.func_74778_a("label", entry.getKey().getUnlocalizedName());
            nbtEntry.func_74778_a("value", ValueHelpers.serializeRaw(entry.getValue()));
            map.func_74742_a((NBTBase)nbtEntry);
        }
        tag.func_74782_a("map", (NBTBase)map);
        return tag;
    }

    public void fromNBT(NBTTagCompound tag) {
        this.values.clear();
        NBTTagList map = tag.func_150295_c("map", MinecraftHelpers.NBTTag_Types.NBTTagCompound.ordinal());
        for (int i = 0; i < map.func_74745_c(); ++i) {
            NBTTagCompound nbtEntry = map.func_150305_b(i);
            String valueTypeName = nbtEntry.func_74779_i("key");
            IValueType type = ValueTypes.REGISTRY.getValueType(valueTypeName);
            if (type == null) {
                IntegratedDynamics.clog(Level.ERROR, String.format("Could not find value type with name %s, skipping loading.", valueTypeName));
                continue;
            }
            Object value = type.deserialize(nbtEntry.func_74779_i("value"));
            String label = nbtEntry.func_74779_i("label");
            if (value == null) {
                IntegratedDynamics.clog(Level.ERROR, String.format("The value type %s could not load its value, using default.", valueTypeName));
                value = type.getDefault();
            }
            this.values.put(new AspectPropertyTypeInstance(type, label), (IValue)value);
        }
    }

    @Override
    public IAspectProperties clone() {
        AspectProperties clone = new AspectProperties(this.getTypes());
        for (IAspectPropertyTypeInstance type : this.getTypes()) {
            clone.setValue(type, this.getValue(type));
        }
        return clone;
    }
}

