/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.api.evaluate.expression;

import com.google.common.collect.Lists;
import java.util.List;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;

public abstract class VariableAdapter<V extends IValue>
implements IVariable<V> {
    private List<IVariable<?>> dependents = Lists.newLinkedList();

    @Override
    public boolean canInvalidate() {
        return true;
    }

    @Override
    public void invalidate() {
        for (IVariable<?> dependent : this.dependents) {
            if (!dependent.canInvalidate()) continue;
            dependent.invalidate();
        }
        this.dependents.clear();
    }

    @Override
    public void addDependent(IVariable<?> dependent) {
        this.dependents.add(dependent);
    }
}

