/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.api.tileentity.IAirListener;
import me.desht.pneumaticcraft.client.sound.MovingSounds;
import me.desht.pneumaticcraft.common.block.BlockElevatorBase;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.config.ConfigHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlayMovingSound;
import me.desht.pneumaticcraft.common.network.PacketServerTickTime;
import me.desht.pneumaticcraft.common.thirdparty.computercraft.LuaConstant;
import me.desht.pneumaticcraft.common.thirdparty.computercraft.LuaMethod;
import me.desht.pneumaticcraft.common.tileentity.ICamouflageableTE;
import me.desht.pneumaticcraft.common.tileentity.IGUITextFieldSensitive;
import me.desht.pneumaticcraft.common.tileentity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControlled;
import me.desht.pneumaticcraft.common.tileentity.TileEntityElevatorCaller;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import me.desht.pneumaticcraft.lib.Sounds;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public class TileEntityElevatorBase
extends TileEntityPneumaticBase
implements IGUITextFieldSensitive,
IRedstoneControlled,
IMinWorkingPressure,
IAirListener,
ICamouflageableTE {
    private static final List<String> REDSTONE_LABELS = ImmutableList.of((Object)"gui.tab.redstoneBehaviour.elevator.button.redstone", (Object)"gui.tab.redstoneBehaviour.elevator.button.elevatorCallers");
    @DescSynced
    public final boolean[] sidesConnected = new boolean[6];
    public float oldExtension;
    @DescSynced
    @LazySynced
    public float extension;
    @DescSynced
    private float targetExtension;
    private boolean isStopped;
    private TileEntityElevatorBase coreElevator;
    private List<TileEntityElevatorBase> multiElevators;
    @GuiSynced
    public int redstoneMode;
    public int[] floorHeights = new int[0];
    private HashMap<Integer, String> floorNames = new HashMap();
    @GuiSynced
    private int maxFloorHeight;
    private int redstoneInputLevel;
    @DescSynced
    private ItemStack camoStack = ItemStack.field_190927_a;
    private IBlockState camoState;

    public TileEntityElevatorBase() {
        super(5.0f, 7.0f, 10000, 4);
        this.addApplicableUpgrade(IItemRegistry.EnumUpgrade.SPEED, IItemRegistry.EnumUpgrade.CHARGING);
    }

    @Override
    public void func_73660_a() {
        this.oldExtension = this.extension;
        if (this.func_145831_w().field_72995_K && this.func_145831_w().func_82737_E() % 60L == 0L) {
            this.coreElevator = null;
        }
        if (this.isCoreElevator()) {
            NetworkRegistry.TargetPoint tp;
            super.func_73660_a();
            if (!this.func_145831_w().field_72995_K && this.isControlledByRedstone()) {
                float oldTargetExtension = this.targetExtension;
                float maxExtension = this.getMaxElevatorHeight();
                int redstoneInput = this.redstoneInputLevel;
                if (this.multiElevators != null) {
                    for (TileEntityElevatorBase base : this.multiElevators) {
                        redstoneInput = Math.max(this.redstoneInputLevel, base.redstoneInputLevel);
                    }
                }
                this.targetExtension = (float)redstoneInput * maxExtension / 15.0f;
                if (this.targetExtension > this.oldExtension && this.getPressure() < 3.0f) {
                    this.targetExtension = this.oldExtension;
                }
                if (oldTargetExtension != this.targetExtension) {
                    this.sendDescPacketFromAllElevators();
                }
            }
            float speedMultiplier = this.getSpeedMultiplierFromUpgrades();
            if (this.func_145831_w().field_72995_K) {
                speedMultiplier = (float)((double)speedMultiplier * PacketServerTickTime.tickTimeMultiplier);
            }
            SoundEvent soundName = null;
            if (this.extension < this.targetExtension) {
                float moveBy;
                if (!this.func_145831_w().field_72995_K && this.getPressure() < 3.0f) {
                    this.targetExtension = this.extension;
                    this.sendDescPacket(256.0);
                }
                if (this.extension + (moveBy = this.extension < this.targetExtension - 0.5f ? 0.05f * speedMultiplier : 0.02f * speedMultiplier) > this.targetExtension) {
                    this.extension = this.targetExtension;
                    if (!this.func_145831_w().field_72995_K) {
                        this.updateFloors();
                    }
                }
                if (this.isStopped) {
                    soundName = Sounds.ELEVATOR_START;
                    this.isStopped = false;
                    tp = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 32.0);
                    NetworkHandler.sendToAllAround(new PacketPlayMovingSound(MovingSounds.Sound.ELEVATOR, this.getCoreElevator()), tp);
                }
                float startingExtension = this.extension;
                while (this.extension < startingExtension + moveBy) {
                    this.extension += 0.02f;
                }
                this.addAir((int)((this.oldExtension - this.extension) * 300.0f * (this.getSpeedUsageMultiplierFromUpgrades() / speedMultiplier)));
            }
            if (this.extension > this.targetExtension) {
                float chargingSlowdown = 1.0f - (float)Math.min(4, this.getUpgrades(IItemRegistry.EnumUpgrade.CHARGING)) * 0.1f;
                this.extension = this.extension > this.targetExtension + 0.5f ? (this.extension -= 0.05f * speedMultiplier * chargingSlowdown) : (this.extension -= 0.02f * speedMultiplier * chargingSlowdown);
                if (this.extension < this.targetExtension) {
                    this.extension = this.targetExtension;
                    if (!this.func_145831_w().field_72995_K) {
                        this.updateFloors();
                    }
                }
                if (this.isStopped) {
                    soundName = Sounds.ELEVATOR_START;
                    this.isStopped = false;
                    tp = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 32.0);
                    NetworkHandler.sendToAllAround(new PacketPlayMovingSound(MovingSounds.Sound.ELEVATOR, this.getCoreElevator()), tp);
                }
                if (this.getUpgrades(IItemRegistry.EnumUpgrade.CHARGING) > 0) {
                    float mul = 0.15f * (float)Math.min(4, this.getUpgrades(IItemRegistry.EnumUpgrade.CHARGING));
                    this.addAir((int)((this.oldExtension - this.extension) * 300.0f * mul * (this.getSpeedUsageMultiplierFromUpgrades() / speedMultiplier)));
                }
            }
            if (this.oldExtension == this.extension && !this.isStopped) {
                soundName = Sounds.ELEVATOR_STOP;
                this.isStopped = true;
            }
            if (soundName != null && this.func_145831_w().field_72995_K) {
                this.func_145831_w().func_184134_a((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, soundName, SoundCategory.BLOCKS, 0.5f, 1.0f, true);
            }
        } else {
            this.extension = 0.0f;
        }
        if (!this.func_145831_w().field_72995_K && this.oldExtension != this.extension) {
            this.sendDescPacket(256.0);
        }
    }

    @Override
    public void handleGUIButtonPress(int buttonID, EntityPlayer player) {
        if (buttonID == 0) {
            ++this.redstoneMode;
            if (this.redstoneMode > 1) {
                this.redstoneMode = 0;
            }
            if (this.multiElevators != null) {
                for (TileEntityElevatorBase base : this.multiElevators) {
                    while (base.redstoneMode != this.redstoneMode) {
                        base.handleGUIButtonPress(buttonID, player);
                    }
                }
            }
            int i = -1;
            TileEntity te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(EnumFacing.DOWN));
            while (te instanceof TileEntityElevatorBase) {
                ((TileEntityElevatorBase)te).redstoneMode = this.redstoneMode;
                te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177982_a(0, --i, 0));
            }
        }
    }

    private boolean isControlledByRedstone() {
        return this.redstoneMode == 0;
    }

    @Override
    public boolean redstoneAllows() {
        return true;
    }

    private void updateRedstoneInputLevel() {
        if (this.multiElevators == null) {
            return;
        }
        int maxRedstone = 0;
        for (TileEntityElevatorBase base : this.multiElevators) {
            int i = 0;
            while (this.func_145831_w().func_180495_p(base.func_174877_v().func_177982_a(0, i, 0)).func_177230_c() == Blockss.ELEVATOR_BASE) {
                maxRedstone = Math.max(maxRedstone, PneumaticCraftUtils.getRedstoneLevel(this.func_145831_w(), base.func_174877_v().func_177982_a(0, i, 0)));
                --i;
            }
        }
        for (TileEntityElevatorBase base : this.multiElevators) {
            base.redstoneInputLevel = maxRedstone;
        }
    }

    public float getMaxElevatorHeight() {
        int max = this.maxFloorHeight;
        if (this.multiElevators != null) {
            for (TileEntityElevatorBase base : this.multiElevators) {
                max = Math.max(max, base.maxFloorHeight);
            }
        }
        return max;
    }

    public void updateMaxElevatorHeight() {
        int i = -1;
        while (this.func_145831_w().func_180495_p(this.func_174877_v().func_177982_a(0, ++i + 1, 0)).func_177230_c() == Blockss.ELEVATOR_FRAME) {
        }
        int elevatorBases = 0;
        while (this.func_145831_w().func_180495_p(this.func_174877_v().func_177982_a(0, -(++elevatorBases), 0)).func_177230_c() == Blockss.ELEVATOR_BASE) {
        }
        this.maxFloorHeight = Math.min(i, elevatorBases * ConfigHandler.machineProperties.elevatorBaseBlocksPerBase);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.extension = tag.func_74760_g("extension");
        this.targetExtension = tag.func_74760_g("targetExtension");
        this.redstoneMode = tag.func_74762_e("redstoneMode");
        if (!tag.func_74764_b("maxFloorHeight")) {
            this.updateMaxElevatorHeight();
        } else {
            this.maxFloorHeight = tag.func_74762_e("maxFloorHeight");
        }
        for (int i = 0; i < 6; ++i) {
            this.sidesConnected[i] = tag.func_74767_n("sideConnected" + i);
        }
        this.camoStack = ICamouflageableTE.readCamoStackFromNBT(tag);
        this.camoState = ICamouflageableTE.getStateForStack(this.camoStack);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74776_a("extension", this.extension);
        tag.func_74776_a("targetExtension", this.targetExtension);
        tag.func_74768_a("redstoneMode", this.redstoneMode);
        tag.func_74768_a("maxFloorHeight", this.maxFloorHeight);
        for (int i = 0; i < 6; ++i) {
            tag.func_74757_a("sideConnected" + i, this.sidesConnected[i]);
        }
        ICamouflageableTE.writeCamoStackToNBT(this.camoStack, tag);
        return tag;
    }

    @Override
    public void readFromPacket(NBTTagCompound tag) {
        super.readFromPacket(tag);
        this.floorHeights = tag.func_74759_k("floorHeights");
        this.floorNames.clear();
        NBTTagList floorNameList = tag.func_150295_c("floorNames", 10);
        for (int i = 0; i < floorNameList.func_74745_c(); ++i) {
            NBTTagCompound floorName = floorNameList.func_150305_b(i);
            this.floorNames.put(floorName.func_74762_e("floorHeight"), floorName.func_74779_i("floorName"));
        }
    }

    @Override
    public void writeToPacket(NBTTagCompound tag) {
        super.writeToPacket(tag);
        tag.func_74783_a("floorHeights", this.floorHeights);
        NBTTagList floorNameList = new NBTTagList();
        for (int key : this.floorNames.keySet()) {
            NBTTagCompound floorNameTag = new NBTTagCompound();
            floorNameTag.func_74768_a("floorHeight", key);
            floorNameTag.func_74778_a("floorName", this.floorNames.get(key));
            floorNameList.func_74742_a((NBTBase)floorNameTag);
        }
        tag.func_74782_a("floorNames", (NBTBase)floorNameList);
    }

    @Override
    public void onNeighborTileUpdate() {
        super.onNeighborTileUpdate();
        this.updateConnections();
        this.connectAsMultiblock();
    }

    private void connectAsMultiblock() {
        this.multiElevators = null;
        if (this.isCoreElevator()) {
            this.multiElevators = new ArrayList<TileEntityElevatorBase>();
            Stack<TileEntityElevatorBase> todo = new Stack<TileEntityElevatorBase>();
            todo.add(this);
            while (!todo.isEmpty()) {
                TileEntityElevatorBase curElevator = (TileEntityElevatorBase)todo.pop();
                if (!curElevator.isCoreElevator()) continue;
                this.multiElevators.add(curElevator);
                curElevator.multiElevators = this.multiElevators;
                for (int i = 2; i < 6; ++i) {
                    TileEntity te = curElevator.getTileCache()[i].getTileEntity();
                    if (this.multiElevators.contains(te) || !(te instanceof TileEntityElevatorBase)) continue;
                    todo.push((TileEntityElevatorBase)te);
                }
            }
        }
    }

    @Override
    public void onNeighborBlockUpdate() {
        super.onNeighborBlockUpdate();
        this.getCoreElevator().updateRedstoneInputLevel();
        this.updateConnections();
    }

    @Override
    public void onDescUpdate() {
        this.camoState = ICamouflageableTE.getStateForStack(this.camoStack);
        this.rerenderTileEntity();
    }

    private void updateConnections() {
        List<Pair<EnumFacing, IAirHandler>> connections = this.getAirHandler(null).getConnectedPneumatics();
        Arrays.fill(this.sidesConnected, false);
        for (Pair<EnumFacing, IAirHandler> entry : connections) {
            this.sidesConnected[((EnumFacing)entry.getKey()).ordinal()] = true;
        }
        if (this.func_145831_w().func_180495_p(this.func_174877_v().func_177972_a(EnumFacing.UP)).func_177230_c() != Blockss.ELEVATOR_BASE) {
            this.coreElevator = this;
            int i = -1;
            TileEntity te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(EnumFacing.DOWN));
            while (te instanceof TileEntityElevatorBase) {
                ((TileEntityElevatorBase)te).coreElevator = this;
                te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177982_a(0, --i, 0));
            }
        }
    }

    public void moveInventoryToThis() {
        TileEntity te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(EnumFacing.UP));
        if (te instanceof TileEntityElevatorBase) {
            this.camoStack = ((TileEntityElevatorBase)te).camoStack;
            this.sendDescriptionPacket();
            for (int i = 0; i < this.upgradeHandler.getSlots(); ++i) {
                ItemStack stack = ((TileEntityElevatorBase)te).getUpgradesInventory().getStackInSlot(i);
                ItemStack excess = ItemHandlerHelper.insertItem((IItemHandler)this.upgradeHandler, (ItemStack)stack, (boolean)false);
                if (!excess.func_190926_b()) {
                    PneumaticCraftUtils.dropItemOnGround(excess, this.field_145850_b, this.func_174877_v());
                }
                ((TileEntityElevatorBase)te).getUpgradesInventory().setStackInSlot(i, ItemStack.field_190927_a);
            }
        }
    }

    public void updateFloors() {
        ArrayList<Integer> floorList = new ArrayList<Integer>();
        ArrayList<BlockPos> callerList = new ArrayList<BlockPos>();
        if (this.multiElevators != null) {
            int i = 0;
            boolean shouldBreak = false;
            block0: while (!shouldBreak) {
                boolean registeredThisFloor = false;
                for (TileEntityElevatorBase base : this.multiElevators) {
                    for (EnumFacing dir : EnumFacing.field_176754_o) {
                        if (base.field_145850_b.func_180495_p(base.func_174877_v().func_177972_a(dir).func_177981_b(i + 2)).func_177230_c() != Blockss.ELEVATOR_CALLER) continue;
                        callerList.add(new BlockPos(base.func_174877_v().func_177958_n() + dir.func_82601_c(), base.func_174877_v().func_177956_o() + i + 2, base.func_174877_v().func_177952_p() + dir.func_82599_e()));
                        if (!registeredThisFloor) {
                            floorList.add(i);
                        }
                        registeredThisFloor = true;
                    }
                }
                ++i;
                for (TileEntityElevatorBase base : this.multiElevators) {
                    if (base.field_145850_b.func_180495_p(base.func_174877_v().func_177981_b(i)).func_177230_c() == Blockss.ELEVATOR_FRAME) continue;
                    shouldBreak = true;
                    continue block0;
                }
            }
            for (TileEntityElevatorBase base : this.multiElevators) {
                base.floorHeights = new int[floorList.size()];
                for (i = 0; i < base.floorHeights.length; ++i) {
                    base.floorHeights[i] = (Integer)floorList.get(i);
                }
            }
        }
        double buttonHeight = 0.06;
        double buttonSpacing = 0.02;
        TileEntityElevatorCaller.ElevatorButton[] elevatorButtons = new TileEntityElevatorCaller.ElevatorButton[this.floorHeights.length];
        int columns = (elevatorButtons.length - 1) / 12 + 1;
        for (int j = 0; j < columns; ++j) {
            for (int i = j * 12; i < this.floorHeights.length && i < j * 12 + 12; ++i) {
                elevatorButtons[i] = new TileEntityElevatorCaller.ElevatorButton(0.2 + 0.6 / (double)columns * (double)j, 0.5 + (double)(Math.min(this.floorHeights.length, 12) - 2) * (buttonSpacing + buttonHeight) / 2.0 - (double)(i % 12) * (buttonHeight + buttonSpacing), 0.58 / (double)columns, buttonHeight, i, this.floorHeights[i]);
                elevatorButtons[i].setColor((float)this.floorHeights[i] == this.targetExtension ? 0.0f : 1.0f, 1.0f, (float)this.floorHeights[i] == this.targetExtension ? 0.0f : 1.0f);
                String floorName = this.floorNames.get(this.floorHeights[i]);
                if (floorName != null) {
                    elevatorButtons[i].buttonText = floorName;
                    continue;
                }
                this.floorNames.put(this.floorHeights[i], elevatorButtons[i].buttonText);
            }
        }
        if (this.multiElevators != null) {
            for (TileEntityElevatorBase base : this.multiElevators) {
                base.floorNames = new HashMap<Integer, String>(this.floorNames);
            }
        }
        for (BlockPos p : callerList) {
            TileEntity te = this.func_145831_w().func_175625_s(p);
            if (!(te instanceof TileEntityElevatorCaller)) continue;
            int callerFloorHeight = p.func_177956_o() - this.func_174877_v().func_177956_o() - 2;
            int callerFloor = -1;
            for (TileEntityElevatorCaller.ElevatorButton floor : elevatorButtons) {
                if (floor.floorHeight != callerFloorHeight) continue;
                callerFloor = floor.floorNumber;
                break;
            }
            if (callerFloor == -1) {
                Log.error("Error while updating elevator floors! This will cause a indexOutOfBoundsException, index = -1");
            }
            ((TileEntityElevatorCaller)te).setEmittingRedstone(PneumaticCraftUtils.areFloatsEqual(this.targetExtension, this.extension, 0.1f) && PneumaticCraftUtils.areFloatsEqual(this.extension, callerFloorHeight, 0.1f));
            ((TileEntityElevatorCaller)te).setFloors(elevatorButtons, callerFloor);
        }
    }

    public void goToFloor(int floor) {
        if (this.getCoreElevator().isControlledByRedstone()) {
            this.getCoreElevator().handleGUIButtonPress(0, null);
        }
        if (floor >= 0 && floor < this.floorHeights.length) {
            this.setTargetHeight(this.floorHeights[floor]);
        }
        this.updateFloors();
        this.sendDescPacketFromAllElevators();
    }

    private void setTargetHeight(float height) {
        height = Math.min(height, this.getMaxElevatorHeight());
        if (this.multiElevators != null) {
            for (TileEntityElevatorBase base : this.multiElevators) {
                base.targetExtension = height;
            }
        }
    }

    public float getTargetExtension() {
        return this.targetExtension;
    }

    private void sendDescPacketFromAllElevators() {
        if (this.multiElevators != null) {
            for (TileEntityElevatorBase base : this.multiElevators) {
                base.sendDescPacket(256.0);
            }
        } else {
            this.sendDescPacket(256.0);
        }
    }

    @Override
    public String getName() {
        return Blockss.ELEVATOR_BASE.func_149739_a();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)((float)(this.func_174877_v().func_177956_o() + 1) + this.extension), (double)(this.func_174877_v().func_177952_p() + 1));
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    private TileEntityElevatorBase getCoreElevator() {
        if (this.coreElevator == null) {
            this.coreElevator = BlockElevatorBase.getCoreTileEntity(this.func_145831_w(), this.func_174877_v());
        }
        return this.coreElevator;
    }

    public boolean isCoreElevator() {
        return this.getCoreElevator() == this;
    }

    @Override
    public boolean isConnectedTo(EnumFacing side) {
        return side != EnumFacing.UP && side != EnumFacing.DOWN || this.func_145831_w().func_180495_p(this.func_174877_v().func_177972_a(side)).func_177230_c() != Blockss.ELEVATOR_BASE;
    }

    @Override
    public IAirHandler getAirHandler(EnumFacing sideRequested) {
        if (this.isCoreElevator()) {
            return super.getAirHandler(sideRequested);
        }
        return this.getCoreElevator().getAirHandler(sideRequested);
    }

    @Override
    public void addConnectedPneumatics(List<Pair<EnumFacing, IAirHandler>> connectedMachines) {
        TileEntity te = this.getTileCache()[EnumFacing.DOWN.ordinal()].getTileEntity();
        if (te instanceof TileEntityElevatorBase) {
            connectedMachines.addAll(((TileEntityElevatorBase)te).airHandler.getConnectedPneumatics());
        }
    }

    @Override
    public void onAirDispersion(IAirHandler handler, EnumFacing dir, int airAdded) {
    }

    @Override
    public int getMaxDispersion(IAirHandler handler, EnumFacing dir) {
        return Integer.MAX_VALUE;
    }

    @Override
    public void setText(int textFieldID, String text) {
        this.setFloorName(textFieldID, text);
    }

    @Override
    public String getText(int textFieldID) {
        return this.getFloorName(textFieldID);
    }

    public String getFloorName(int floor) {
        return floor < this.floorHeights.length ? this.floorNames.get(this.floorHeights[floor]) : "";
    }

    public void setFloorName(int floor, String name) {
        if (floor < this.floorHeights.length) {
            this.floorNames.put(this.floorHeights[floor], name);
            this.updateFloors();
        }
    }

    @Override
    public boolean isGuiUseableByPlayer(EntityPlayer par1EntityPlayer) {
        return this.func_145831_w().func_175625_s(this.func_174877_v()) == this;
    }

    @Override
    public String getType() {
        return "elevator";
    }

    @Override
    protected void addLuaMethods() {
        super.addLuaMethods();
        this.luaMethods.add(new LuaConstant("getMinWorkingPressure", 3.0f));
        this.luaMethods.add(new LuaMethod("setHeight"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 1) {
                    TileEntityElevatorBase.this.setTargetHeight(((Double)args[0]).floatValue());
                    if (TileEntityElevatorBase.this.getCoreElevator().isControlledByRedstone()) {
                        TileEntityElevatorBase.this.getCoreElevator().handleGUIButtonPress(0, null);
                    }
                    TileEntityElevatorBase.this.getCoreElevator().sendDescPacketFromAllElevators();
                    return null;
                }
                throw new IllegalArgumentException("setHeight does take one argument (height)");
            }
        });
        this.luaMethods.add(new LuaMethod("getCurrentHeight"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 0) {
                    return new Object[]{Float.valueOf(((TileEntityElevatorBase)TileEntityElevatorBase.this).getCoreElevator().extension)};
                }
                throw new IllegalArgumentException("getCurrentHeight method takes no arguments!");
            }
        });
        this.luaMethods.add(new LuaMethod("getTargetHeight"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 0) {
                    return new Object[]{Float.valueOf(TileEntityElevatorBase.this.getCoreElevator().targetExtension)};
                }
                throw new IllegalArgumentException("getTargetHeight method takes no arguments!");
            }
        });
        this.luaMethods.add(new LuaMethod("setExternalControl"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 1) {
                    if (((Boolean)args[0]).booleanValue() && TileEntityElevatorBase.this.getCoreElevator().isControlledByRedstone() || !((Boolean)args[0]).booleanValue() && !TileEntityElevatorBase.this.getCoreElevator().isControlledByRedstone()) {
                        TileEntityElevatorBase.this.getCoreElevator().handleGUIButtonPress(0, null);
                    }
                    return null;
                }
                throw new IllegalArgumentException("setExternalControl does take one argument! (bool)");
            }
        });
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public float getMinWorkingPressure() {
        return 3.0f;
    }

    @Override
    public IBlockState getCamouflage() {
        return this.camoState;
    }

    @Override
    public void setCamouflage(IBlockState state) {
        this.camoState = state;
        this.camoStack = ICamouflageableTE.getStackForState(state);
        this.sendDescriptionPacket();
        this.func_70296_d();
    }

    @Override
    public String getRedstoneTabTitle() {
        return "gui.tab.redstoneBehaviour.elevator.controlBy";
    }

    @Override
    protected List<String> getRedstoneButtonLabels() {
        return REDSTONE_LABELS;
    }
}

