/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.api.item.IPressurizable;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.common.GuiHandler;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.inventory.ChargeableItemHandler;
import me.desht.pneumaticcraft.common.inventory.ContainerChargingStationItemInventory;
import me.desht.pneumaticcraft.common.item.IChargingStationGUIHolderItem;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.tileentity.FilteredItemStackHandler;
import me.desht.pneumaticcraft.common.tileentity.ICamouflageableTE;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControl;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import me.desht.pneumaticcraft.common.util.GlobalTileEntityCacheManager;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.apache.commons.lang3.tuple.Pair;

public class TileEntityChargingStation
extends TileEntityPneumaticBase
implements IRedstoneControl,
ICamouflageableTE {
    private static final List<String> REDSTONE_LABELS = ImmutableList.of((Object)"gui.tab.redstoneBehaviour.button.never", (Object)"gui.tab.redstoneBehaviour.chargingStation.button.doneDischarging", (Object)"gui.tab.redstoneBehaviour.chargingStation.button.charging", (Object)"gui.tab.redstoneBehaviour.chargingStation.button.discharging");
    @DescSynced
    private ChargingStationHandler inventory;
    private ChargeableItemHandler chargeableInventory;
    private CombinedInvWrapper invWrapper;
    private boolean droppingItems = false;
    private static final int INVENTORY_SIZE = 1;
    public static final int CHARGE_INVENTORY_INDEX = 0;
    private static final float ANIMATION_AIR_SPEED = 0.001f;
    @GuiSynced
    public boolean charging;
    @GuiSynced
    public boolean disCharging;
    @GuiSynced
    public int redstoneMode;
    private boolean oldRedstoneStatus;
    public float renderAirProgress;
    @DescSynced
    private ItemStack camoStack = ItemStack.field_190927_a;
    private IBlockState camoState;

    public TileEntityChargingStation() {
        super(20.0f, 25.0f, 1000, 4);
        this.inventory = new ChargingStationHandler();
        this.addApplicableUpgrade(IItemRegistry.EnumUpgrade.SPEED, IItemRegistry.EnumUpgrade.DISPENSER);
    }

    @Override
    public void onDescUpdate() {
        this.camoState = ICamouflageableTE.getStateForStack(this.camoStack);
        this.func_145831_w().func_175704_b(this.func_174877_v(), this.func_174877_v());
    }

    @Nonnull
    public ItemStack getChargingItem() {
        return this.inventory.getStackInSlot(0);
    }

    @Override
    public void func_73660_a() {
        List<Pair<EnumFacing, IAirHandler>> teList;
        this.disCharging = false;
        this.charging = false;
        ArrayList<IPressurizable> chargingItems = new ArrayList<IPressurizable>();
        ArrayList<ItemStack> chargedStacks = new ArrayList<ItemStack>();
        if (this.getChargingItem().func_77973_b() instanceof IPressurizable) {
            chargingItems.add((IPressurizable)this.getChargingItem().func_77973_b());
            chargedStacks.add(this.getChargingItem());
        }
        if (this.getUpgrades(IItemRegistry.EnumUpgrade.DISPENSER) > 0) {
            List entitiesPadding = this.func_145831_w().func_72872_a(Entity.class, new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 2), (double)(this.func_174877_v().func_177952_p() + 1)));
            for (Entity entity : entitiesPadding) {
                if (entity instanceof IPressurizable) {
                    chargingItems.add((IPressurizable)entity);
                    chargedStacks.add(ItemStack.field_190927_a);
                    continue;
                }
                if (entity instanceof EntityItem) {
                    ItemStack entityStack = ((EntityItem)entity).func_92059_d();
                    if (!(entityStack.func_77973_b() instanceof IPressurizable)) continue;
                    chargingItems.add((IPressurizable)entityStack.func_77973_b());
                    chargedStacks.add(entityStack);
                    continue;
                }
                if (!(entity instanceof EntityPlayer)) continue;
                InventoryPlayer inv = ((EntityPlayer)entity).field_71071_by;
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    ItemStack stack = inv.func_70301_a(i);
                    if (!(stack.func_77973_b() instanceof IPressurizable)) continue;
                    chargingItems.add((IPressurizable)stack.func_77973_b());
                    chargedStacks.add(stack);
                }
            }
        }
        int airToTransfer = (int)(10.0f * this.getSpeedMultiplierFromUpgrades());
        for (int i = 0; i < chargingItems.size() && this.airHandler.getAir() > 0; ++i) {
            IPressurizable chargingItem = (IPressurizable)chargingItems.get(i);
            ItemStack chargingStack = (ItemStack)chargedStacks.get(i);
            float itemPressure = chargingItem.getPressure(chargingStack);
            float itemVolume = chargingItem.getVolume(chargingStack);
            float delta = Math.abs(this.getPressure() - itemPressure) / 2.0f;
            int airInItem = (int)(itemPressure * itemVolume);
            if (itemPressure > this.getPressure() + 0.01f && itemPressure > 0.0f) {
                int airToMove = Math.min(Math.min(airToTransfer, airInItem), (int)(delta * (float)this.airHandler.getVolume()));
                if (!this.func_145831_w().field_72995_K) {
                    chargingItem.addAir(chargingStack, -airToMove);
                    this.addAir(airToMove);
                }
                this.disCharging = true;
                this.renderAirProgress -= 0.001f;
                if (!(this.renderAirProgress < 0.0f)) continue;
                this.renderAirProgress += 1.0f;
                continue;
            }
            if (!(itemPressure < this.getPressure() - 0.01f) || !(itemPressure < chargingItem.maxPressure(chargingStack))) continue;
            int maxAirInItem = (int)(chargingItem.maxPressure(chargingStack) * itemVolume);
            int airToMove = Math.min(Math.min(airToTransfer, this.airHandler.getAir()), maxAirInItem - airInItem);
            airToMove = Math.min((int)(delta * itemVolume), airToMove);
            if (!this.func_145831_w().field_72995_K) {
                chargingItem.addAir(chargingStack, airToMove);
                this.addAir(-airToMove);
            }
            this.charging = true;
            this.renderAirProgress += 0.001f;
            if (!(this.renderAirProgress > 1.0f)) continue;
            this.renderAirProgress -= 1.0f;
        }
        if (!this.func_145831_w().field_72995_K && this.oldRedstoneStatus != this.shouldEmitRedstone()) {
            this.oldRedstoneStatus = this.shouldEmitRedstone();
            this.updateNeighbours();
        }
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K && (teList = this.getAirHandler(null).getConnectedPneumatics()).size() == 0) {
            this.getAirHandler(null).airLeak(this.getRotation());
        }
    }

    @Override
    public boolean isConnectedTo(EnumFacing side) {
        return this.getRotation() == side;
    }

    @Override
    public void handleGUIButtonPress(int buttonID, EntityPlayer player) {
        if (buttonID == 0) {
            ++this.redstoneMode;
            if (this.redstoneMode > 3) {
                this.redstoneMode = 0;
            }
            this.updateNeighbours();
        } else if ((buttonID == 1 || buttonID == 2) && this.getChargingItem().func_77973_b() instanceof IChargingStationGUIHolderItem) {
            player.openGui((Object)PneumaticCraftRepressurized.instance, buttonID == 1 ? ((IChargingStationGUIHolderItem)this.getChargingItem().func_77973_b()).getGuiID().ordinal() : GuiHandler.EnumGuiId.CHARGING_STATION.ordinal(), this.func_145831_w(), this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
        }
    }

    public boolean shouldEmitRedstone() {
        switch (this.redstoneMode) {
            case 0: {
                return false;
            }
            case 1: {
                return !this.charging && !this.disCharging && this.getChargingItem().func_77973_b() instanceof IPressurizable;
            }
            case 2: {
                return this.charging;
            }
            case 3: {
                return this.disCharging;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 1), (double)(this.func_174877_v().func_177952_p() + 1));
    }

    public ChargeableItemHandler getChargeableInventory() {
        return this.func_145831_w().field_72995_K ? new ChargeableItemHandler(this) : this.chargeableInventory;
    }

    @Override
    public IItemHandlerModifiable getPrimaryInventory() {
        return this.invWrapper == null || this.droppingItems ? this.inventory : this.invWrapper;
    }

    @Override
    public void getContentsToDrop(NonNullList<ItemStack> drops) {
        this.droppingItems = true;
        super.getContentsToDrop(drops);
        this.droppingItems = false;
    }

    @Override
    public String getName() {
        return Blockss.CHARGING_STATION.func_149739_a();
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.redstoneMode = tag.func_74762_e("redstoneMode");
        this.inventory = new ChargingStationHandler();
        this.inventory.deserializeNBT(tag.func_74775_l("Items"));
        ItemStack chargeSlot = this.getChargingItem();
        if (chargeSlot.func_77973_b() instanceof IChargingStationGUIHolderItem) {
            this.setChargeableInventory(new ChargeableItemHandler(this));
        }
        this.camoStack = ICamouflageableTE.readCamoStackFromNBT(tag);
        this.camoState = ICamouflageableTE.getStateForStack(this.camoStack);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        if (this.chargeableInventory != null) {
            this.chargeableInventory.writeToNBT();
        }
        tag.func_74768_a("redstoneMode", this.redstoneMode);
        tag.func_74782_a("Items", (NBTBase)this.inventory.serializeNBT());
        ICamouflageableTE.writeCamoStackToNBT(this.camoStack, tag);
        return tag;
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.chargeableInventory != null) {
            this.chargeableInventory.saveInventory();
        }
    }

    private void setChargeableInventory(ChargeableItemHandler handler) {
        this.chargeableInventory = handler;
        this.invWrapper = this.chargeableInventory == null ? null : new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory, this.chargeableInventory});
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    protected List<String> getRedstoneButtonLabels() {
        return REDSTONE_LABELS;
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    @Override
    public IBlockState getCamouflage() {
        return this.camoState;
    }

    @Override
    public void setCamouflage(IBlockState state) {
        this.camoState = state;
        this.camoStack = ICamouflageableTE.getStackForState(state);
        this.sendDescriptionPacket();
        this.func_70296_d();
    }

    public void func_145843_s() {
        super.func_145843_s();
        GlobalTileEntityCacheManager.getInstance().chargingStations.remove(this);
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        GlobalTileEntityCacheManager.getInstance().chargingStations.add(this);
    }

    private class ChargingStationHandler
    extends FilteredItemStackHandler {
        ChargingStationHandler() {
            super(TileEntityChargingStation.this, 1);
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        @Override
        public boolean test(Integer slot, ItemStack itemStack) {
            return slot == 0 && (itemStack.func_190926_b() || itemStack.func_77973_b() instanceof IPressurizable);
        }

        @Override
        protected void onContentsChanged(int slot) {
            ItemStack stack;
            TileEntityChargingStation teCS = (TileEntityChargingStation)this.te;
            if (teCS.func_145831_w().field_72995_K || slot != 0) {
                return;
            }
            if (teCS.chargeableInventory != null) {
                teCS.chargeableInventory.saveInventory();
                teCS.setChargeableInventory(null);
            }
            if ((stack = this.getStackInSlot(slot)).func_77973_b() instanceof IChargingStationGUIHolderItem) {
                teCS.chargeableInventory = new ChargeableItemHandler(teCS);
                teCS.invWrapper = new CombinedInvWrapper(new IItemHandlerModifiable[]{teCS.inventory, teCS.chargeableInventory});
            }
            List players = teCS.func_145831_w().field_73010_i;
            for (EntityPlayer player : players) {
                if (!(player.field_71070_bA instanceof ContainerChargingStationItemInventory) || ((ContainerChargingStationItemInventory)player.field_71070_bA).te != this.te || stack.func_77973_b() instanceof IChargingStationGUIHolderItem) continue;
                player.openGui((Object)PneumaticCraftRepressurized.instance, GuiHandler.EnumGuiId.CHARGING_STATION.ordinal(), teCS.func_145831_w(), teCS.func_174877_v().func_177958_n(), teCS.func_174877_v().func_177956_o(), teCS.func_174877_v().func_177952_p());
            }
        }
    }
}

