/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.programs;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.common.recipes.AssemblyRecipe;
import me.desht.pneumaticcraft.common.recipes.programs.AssemblyProgram;
import me.desht.pneumaticcraft.common.recipes.programs.ProgramDrill;
import me.desht.pneumaticcraft.common.recipes.programs.ProgramLaser;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyController;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyDrill;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyIOUnit;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyLaser;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyPlatform;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ProgramDrillLaser
extends AssemblyProgram {
    @Override
    public AssemblyProgram.EnumMachine[] getRequiredMachines() {
        return new AssemblyProgram.EnumMachine[]{AssemblyProgram.EnumMachine.PLATFORM, AssemblyProgram.EnumMachine.IO_UNIT_EXPORT, AssemblyProgram.EnumMachine.IO_UNIT_IMPORT, AssemblyProgram.EnumMachine.DRILL, AssemblyProgram.EnumMachine.LASER};
    }

    @Override
    public boolean executeStep(TileEntityAssemblyController controller, TileEntityAssemblyPlatform platform, TileEntityAssemblyIOUnit ioUnitImport, TileEntityAssemblyIOUnit ioUnitExport, TileEntityAssemblyDrill drill, TileEntityAssemblyLaser laser) {
        boolean useAir = true;
        if (!platform.getHeldStack().func_190926_b()) {
            if (this.canItemBeDrilled(platform.getHeldStack())) {
                drill.goDrilling();
            } else if (drill.isIdle() && this.canItemBeLasered(platform.getHeldStack())) {
                laser.startLasering();
            } else if (drill.isIdle() && laser.isIdle()) {
                useAir = ioUnitExport.pickupItem(null);
            }
        } else if (!ioUnitExport.isIdle()) {
            useAir = ioUnitExport.pickupItem(null);
        } else {
            ArrayList<AssemblyRecipe> recipes = new ArrayList<AssemblyRecipe>();
            recipes.addAll(this.getRecipeList());
            recipes.addAll(new ProgramDrill().getRecipeList());
            recipes.addAll(new ProgramLaser().getRecipeList());
            useAir = ioUnitImport.pickupItem(recipes);
        }
        return useAir;
    }

    private boolean canItemBeLasered(ItemStack item) {
        for (AssemblyRecipe recipe : AssemblyRecipe.laserRecipes) {
            if (!ProgramDrillLaser.isValidInput(recipe, item)) continue;
            return true;
        }
        return false;
    }

    private boolean canItemBeDrilled(ItemStack item) {
        for (AssemblyRecipe recipe : AssemblyRecipe.drillRecipes) {
            if (!ProgramDrillLaser.isValidInput(recipe, item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
    }

    @Override
    public List<AssemblyRecipe> getRecipeList() {
        return AssemblyRecipe.drillLaserRecipes;
    }

    @Override
    protected int getItemMeta() {
        return 2;
    }
}

