/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import me.desht.pneumaticcraft.common.block.BlockPneumaticCraftCamo;
import me.desht.pneumaticcraft.common.item.ItemPressurizable;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.tileentity.ICamouflageableTE;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Sounds;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ItemCamoApplicator
extends ItemPressurizable {
    public ItemCamoApplicator() {
        super("camo_applicator", 30000, 3000);
    }

    public String func_77653_i(ItemStack stack) {
        IBlockState camoState = ItemCamoApplicator.getCamoState(stack);
        String disp = super.func_77653_i(stack);
        if (camoState != null) {
            return disp + ": " + TextFormatting.YELLOW + ItemCamoApplicator.getCamoStateDisplayName(camoState);
        }
        return disp;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (!worldIn.field_72995_K && playerIn.func_70093_af() && ItemCamoApplicator.getCamoState(stack) != null) {
            ItemCamoApplicator.setCamoState(stack, null);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) return EnumActionResult.SUCCESS;
        if (player.func_70093_af()) {
            IBlockState state = world.func_180495_p(pos);
            if (state.func_177230_c() instanceof BlockPneumaticCraftCamo) {
                NetworkHandler.sendToAllAround(new PacketPlaySound(SoundEvents.field_187556_aj, SoundCategory.PLAYERS, pos, 1.0f, 2.0f, false), world);
                player.func_146105_b((ITextComponent)new TextComponentTranslation("message.camo.invalidBlock", new Object[]{ItemCamoApplicator.getCamoStateDisplayName(state)}), true);
                return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
            } else {
                ItemCamoApplicator.setCamoState(stack, state);
            }
            return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
        } else {
            ItemStack camoStack;
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof ICamouflageableTE)) {
                return EnumActionResult.PASS;
            }
            IBlockState camoState = ItemCamoApplicator.getCamoState(stack);
            float pressure = this.getPressure(stack);
            if ((double)pressure < 0.1 && !player.field_71075_bZ.field_75098_d) {
                return EnumActionResult.FAIL;
            }
            if (camoState != null && !player.field_71075_bZ.field_75098_d && !PneumaticCraftUtils.consumeInventoryItem(player.field_71071_by, camoStack = ICamouflageableTE.getStackForState(camoState))) {
                String name = camoStack.func_82833_r();
                player.func_146105_b((ITextComponent)new TextComponentTranslation("message.camo.notEnoughBlocks", new Object[]{name}), true);
                NetworkHandler.sendToAllAround(new PacketPlaySound(SoundEvents.field_187556_aj, SoundCategory.PLAYERS, pos, 1.0f, 2.0f, false), world);
                return EnumActionResult.FAIL;
            }
            IBlockState existingCamo = ((ICamouflageableTE)te).getCamouflage();
            if (existingCamo == camoState) {
                NetworkHandler.sendToAllAround(new PacketPlaySound(SoundEvents.field_187556_aj, SoundCategory.PLAYERS, pos, 1.0f, 2.0f, false), world);
                return EnumActionResult.SUCCESS;
            }
            if (existingCamo != null && !player.field_71075_bZ.field_75098_d) {
                ItemStack camoStack2 = ICamouflageableTE.getStackForState(existingCamo);
                EntityItem entity = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, camoStack2);
                world.func_72838_d((Entity)entity);
                entity.func_70100_b_(player);
            }
            this.addAir(stack, -50);
            ((ICamouflageableTE)te).setCamouflage(camoState);
            NetworkHandler.sendToAllAround(new PacketPlaySound(Sounds.SHORT_HISS, SoundCategory.PLAYERS, pos, 1.0f, 1.0f, false), world);
            return EnumActionResult.SUCCESS;
        }
    }

    private static void setCamoState(ItemStack stack, IBlockState state) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        if (state == null) {
            tag.func_82580_o("CamoState");
        } else {
            Block block = state.func_177230_c();
            NBTTagCompound stateTag = new NBTTagCompound();
            stateTag.func_74778_a("block", block.getRegistryName().toString());
            stateTag.func_74768_a("meta", block.func_176201_c(state));
            stack.func_77982_d(stateTag);
            tag.func_74782_a("CamoState", (NBTBase)stateTag);
        }
        stack.func_77982_d(tag);
    }

    private static IBlockState getCamoState(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("CamoState")) {
            NBTTagCompound stateTag = stack.func_77978_p().func_74775_l("CamoState");
            Block b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(stateTag.func_74779_i("block")));
            return b != null ? b.func_176203_a(stateTag.func_74762_e("meta")) : null;
        }
        return null;
    }

    public static String getCamoStateDisplayName(IBlockState state) {
        Block b;
        Item item;
        if (state != null && (item = Item.func_150898_a((Block)(b = state.func_177230_c()))) != null) {
            return new ItemStack(item, 1, b.func_176201_c(state)).func_82833_r();
        }
        return "<?>";
    }

    private static String getCamoStateDisplayName(ItemStack stack) {
        return ItemCamoApplicator.getCamoStateDisplayName(ItemCamoApplicator.getCamoState(stack));
    }
}

