/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.heat.behaviour;

import java.util.HashSet;
import java.util.Stack;
import me.desht.pneumaticcraft.common.heat.behaviour.HeatBehaviourTransition;
import me.desht.pneumaticcraft.common.util.FluidUtils;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.Fluid;

public abstract class HeatBehaviourLiquidTransition
extends HeatBehaviourTransition {
    @Override
    public boolean isApplicable() {
        Fluid fluid = this.getFluid();
        return fluid != null && fluid.getTemperature() >= this.getMinFluidTemp() && fluid.getTemperature() <= this.getMaxFluidTemp() && super.isApplicable();
    }

    protected abstract int getMinFluidTemp();

    protected abstract int getMaxFluidTemp();

    protected abstract Block getTransitionedSourceBlock();

    protected abstract Block getTransitionedFlowingBlock();

    @Override
    protected void transformBlock() {
        this.transformSourceBlock(this.getTransitionedSourceBlock(), this.getTransitionedFlowingBlock());
        this.onTransition(this.getPos());
    }

    protected void transformSourceBlock(Block turningBlockSource, Block turningBlockFlowing) {
        if (FluidUtils.isSourceBlock(this.getWorld(), this.getPos())) {
            this.getWorld().func_175656_a(this.getPos(), turningBlockSource.func_176223_P());
        } else {
            HashSet<BlockPos> traversed = new HashSet<BlockPos>();
            Stack<BlockPos> pending = new Stack<BlockPos>();
            pending.push(this.getPos());
            traversed.add(this.getPos());
            while (!pending.isEmpty()) {
                BlockPos pos = (BlockPos)pending.pop();
                for (EnumFacing d : EnumFacing.field_82609_l) {
                    BlockPos newPos = pos.func_177972_a(d);
                    Block checkingBlock = this.getWorld().func_180495_p(newPos).func_177230_c();
                    if (checkingBlock != this.getBlockState().func_177230_c() && (this.getBlockState().func_177230_c() != Blocks.field_150358_i || checkingBlock != Blocks.field_150355_j) && (this.getBlockState().func_177230_c() != Blocks.field_150356_k || checkingBlock != Blocks.field_150353_l) || !traversed.add(newPos)) continue;
                    if (FluidUtils.isSourceBlock(this.getWorld(), newPos)) {
                        this.getWorld().func_175656_a(newPos, turningBlockSource.func_176223_P());
                        this.onTransition(newPos);
                        return;
                    }
                    this.getWorld().func_175656_a(newPos, turningBlockFlowing.func_176223_P());
                    this.onTransition(newPos);
                    pending.push(newPos);
                }
            }
        }
    }
}

