/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.server.component;

import com.google.common.io.Files;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import li.cil.oc.OpenComputers$;
import li.cil.oc.Settings$;
import li.cil.oc.api.Network;
import li.cil.oc.api.driver.DeviceInfo;
import li.cil.oc.api.fs.Label;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ComponentConnector;
import li.cil.oc.api.network.EnvironmentHost;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.api.prefab.AbstractManagedEnvironment;
import li.cil.oc.server.PacketSender$;
import li.cil.oc.server.component.package$;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.DimensionManager;
import scala.Array$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.convert.WrapAsJava$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\tuf\u0001B\u0001\u0003\u00015\u0011Q\u0001\u0012:jm\u0016T!a\u0001\u0003\u0002\u0013\r|W\u000e]8oK:$(BA\u0003\u0007\u0003\u0019\u0019XM\u001d<fe*\u0011q\u0001C\u0001\u0003_\u000eT!!\u0003\u0006\u0002\u0007\rLGNC\u0001\f\u0003\ta\u0017n\u0001\u0001\u0014\u0007\u0001qa\u0003\u0005\u0002\u0010)5\t\u0001C\u0003\u0002\u0012%\u00051\u0001O]3gC\nT!a\u0005\u0004\u0002\u0007\u0005\u0004\u0018.\u0003\u0002\u0016!\tQ\u0012IY:ue\u0006\u001cG/T1oC\u001e,G-\u00128wSJ|g.\\3oiB\u0011qCG\u0007\u00021)\u0011\u0011DE\u0001\u0007IJLg/\u001a:\n\u0005mA\"A\u0003#fm&\u001cW-\u00138g_\"AQ\u0004\u0001BC\u0002\u0013\u0005a$\u0001\u0005dCB\f7-\u001b;z+\u0005y\u0002C\u0001\u0011$\u001b\u0005\t#\"\u0001\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\n#aA%oi\"Aa\u0005\u0001B\u0001B\u0003%q$A\u0005dCB\f7-\u001b;zA!A\u0001\u0006\u0001BC\u0002\u0013\u0005a$\u0001\u0007qY\u0006$H/\u001a:D_VtG\u000f\u0003\u0005+\u0001\t\u0005\t\u0015!\u0003 \u00035\u0001H.\u0019;uKJ\u001cu.\u001e8uA!AA\u0006\u0001BC\u0002\u0013\u0005Q&A\u0003mC\n,G.F\u0001/!\ty#'D\u00011\u0015\t\t$#\u0001\u0002gg&\u00111\u0007\r\u0002\u0006\u0019\u0006\u0014W\r\u001c\u0005\tk\u0001\u0011\t\u0011)A\u0005]\u00051A.\u00192fY\u0002B\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001O\u0001\u0005Q>\u001cH\u000fE\u0002!smJ!AO\u0011\u0003\r=\u0003H/[8o!\tat(D\u0001>\u0015\tq$#A\u0004oKR<xN]6\n\u0005\u0001k$aD#om&\u0014xN\\7f]RDun\u001d;\t\u0011\t\u0003!Q1A\u0005\u0002\r\u000bQa]8v]\u0012,\u0012\u0001\u0012\t\u0004Ae*\u0005C\u0001$J\u001d\t\u0001s)\u0003\u0002IC\u00051\u0001K]3eK\u001aL!AS&\u0003\rM#(/\u001b8h\u0015\tA\u0015\u0005\u0003\u0005N\u0001\t\u0005\t\u0015!\u0003E\u0003\u0019\u0019x.\u001e8eA!Aq\n\u0001BC\u0002\u0013\u0005a$A\u0003ta\u0016,G\r\u0003\u0005R\u0001\t\u0005\t\u0015!\u0003 \u0003\u0019\u0019\b/Z3eA!)1\u000b\u0001C\u0001)\u00061A(\u001b8jiz\"r!V,Y3j[F\f\u0005\u0002W\u00015\t!\u0001C\u0003\u001e%\u0002\u0007q\u0004C\u0003)%\u0002\u0007q\u0004C\u0003-%\u0002\u0007a\u0006C\u00038%\u0002\u0007\u0001\bC\u0003C%\u0002\u0007A\tC\u0003P%\u0002\u0007q\u0004C\u0004_\u0001\t\u0007I\u0011I0\u0002\t9|G-Z\u000b\u0002AB\u0011A(Y\u0005\u0003Ev\u0012!cQ8na>tWM\u001c;D_:tWm\u0019;pe\"1A\r\u0001Q\u0001\n\u0001\fQA\\8eK\u0002BQA\u001a\u0001\u0005\n\u001d\f\u0001b]1wKB\u000bG\u000f[\u000b\u0002QB\u0011\u0011N\\\u0007\u0002U*\u00111\u000e\\\u0001\u0003S>T\u0011!\\\u0001\u0005U\u00064\u0018-\u0003\u0002pU\n!a)\u001b7f\u0011\u001d\t\bA1A\u0005\u000eI\f!b]3di>\u00148+\u001b>f+\u0005\u0019x\"\u0001;\u001e\u0005\t\u0001\u0001B\u0002<\u0001A\u000351/A\u0006tK\u000e$xN]*ju\u0016\u0004\u0003b\u0002=\u0001\u0005\u0004%I!_\u0001\u0005I\u0006$\u0018-F\u0001{!\r\u000130`\u0005\u0003y\u0006\u0012Q!\u0011:sCf\u0004\"\u0001\t@\n\u0005}\f#\u0001\u0002\"zi\u0016Dq!a\u0001\u0001A\u0003%!0A\u0003eCR\f\u0007\u0005\u0003\u0005\u0002\b\u0001\u0011\r\u0011\"\u0003\u001f\u0003-\u0019Xm\u0019;pe\u000e{WO\u001c;\t\u000f\u0005-\u0001\u0001)A\u0005?\u0005a1/Z2u_J\u001cu.\u001e8uA!A\u0011q\u0002\u0001C\u0002\u0013%a$A\ttK\u000e$xN]:QKJ\u0004F.\u0019;uKJDq!a\u0005\u0001A\u0003%q$\u0001\ntK\u000e$xN]:QKJ\u0004F.\u0019;uKJ\u0004\u0003\u0002CA\f\u0001\u0001\u0007I\u0011\u0002\u0010\u0002\u000f!,\u0017\r\u001a)pg\"I\u00111\u0004\u0001A\u0002\u0013%\u0011QD\u0001\fQ\u0016\fG\rU8t?\u0012*\u0017\u000f\u0006\u0003\u0002 \u0005\u0015\u0002c\u0001\u0011\u0002\"%\u0019\u00111E\u0011\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003O\tI\"!AA\u0002}\t1\u0001\u001f\u00132\u0011\u001d\tY\u0003\u0001Q!\n}\t\u0001\u0002[3bIB{7\u000f\t\u0005\n\u0003_\u0001!\u0019!C\u0003\u0003c\tqB]3bIN+7\r^8s\u0007>\u001cHo]\u000b\u0003\u0003g\u0001B\u0001I>\u00026A\u0019\u0001%a\u000e\n\u0007\u0005e\u0012E\u0001\u0004E_V\u0014G.\u001a\u0005\t\u0003{\u0001\u0001\u0015!\u0004\u00024\u0005\u0001\"/Z1e'\u0016\u001cGo\u001c:D_N$8\u000f\t\u0005\n\u0003\u0003\u0002!\u0019!C\u0003\u0003c\t\u0001c\u001e:ji\u0016\u001cVm\u0019;pe\u000e{7\u000f^:\t\u0011\u0005\u0015\u0003\u0001)A\u0007\u0003g\t\u0011c\u001e:ji\u0016\u001cVm\u0019;pe\u000e{7\u000f^:!\u0011%\tI\u0005\u0001b\u0001\n\u000b\t\t$A\u0007sK\u0006$')\u001f;f\u0007>\u001cHo\u001d\u0005\t\u0003\u001b\u0002\u0001\u0015!\u0004\u00024\u0005q!/Z1e\u0005f$XmQ8tiN\u0004\u0003\"CA)\u0001\t\u0007IQAA\u0019\u000399(/\u001b;f\u0005f$XmQ8tiND\u0001\"!\u0016\u0001A\u00035\u00111G\u0001\u0010oJLG/\u001a\"zi\u0016\u001cun\u001d;tA!Q\u0011\u0011\f\u0001\t\u0006\u0004%i!a\u0017\u0002\u0015\u0011,g/[2f\u0013:4w.\u0006\u0002\u0002^AA\u0011qLA5\u0003[\ni'\u0004\u0002\u0002b)!\u00111MA3\u0003%IW.\\;uC\ndWMC\u0002\u0002h\u0005\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\tY'!\u0019\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002p\u0005UTBAA9\u0015\r\t\u0019\b\\\u0001\u0005Y\u0006tw-C\u0002K\u0003cB!\"!\u001f\u0001\u0011\u0003\u0005\u000bUBA/\u0003-!WM^5dK&sgm\u001c\u0011\t\u000f\u0005u\u0004\u0001\"\u0011\u0002\u0000\u0005iq-\u001a;EKZL7-Z%oM>$\"!!!\u0011\r\u0005\r\u0015\u0011R#F\u001b\t\t)IC\u0002\u0002\b2\fA!\u001e;jY&!\u00111NAC\u0011\u001d\ti\t\u0001C\u0001\u0003\u001f\u000b\u0001bZ3u\u0019\u0006\u0014W\r\u001c\u000b\u0007\u0003#\u000bI*!+\u0011\t\u0001Z\u00181\u0013\t\u0004A\u0005U\u0015bAALC\t1\u0011I\\=SK\u001aD\u0001\"a'\u0002\f\u0002\u0007\u0011QT\u0001\bG>tG/\u001a=u!\u0011\ty*!*\u000e\u0005\u0005\u0005&bAAR%\u00059Q.Y2iS:,\u0017\u0002BAT\u0003C\u0013qaQ8oi\u0016DH\u000f\u0003\u0005\u0002,\u0006-\u0005\u0019AAW\u0003\u0011\t'oZ:\u0011\t\u0005}\u0015qV\u0005\u0005\u0003c\u000b\tKA\u0005Be\u001e,X.\u001a8ug\"b\u00111RA[\u0003w\u000bi,a0\u0002BB!\u0011qTA\\\u0013\u0011\tI,!)\u0003\u0011\r\u000bG\u000e\u001c2bG.\fa\u0001Z5sK\u000e$\u0018$A\u0001\u0002\u0007\u0011|7-\t\u0002\u0002D\u0006Ad-\u001e8di&|g\u000eK\u0015;gR\u0014\u0018N\\4![5\u0002s)\u001a;!i\",\u0007eY;se\u0016tG\u000f\t7bE\u0016d\u0007e\u001c4!i\",\u0007\u0005\u001a:jm\u0016t\u0003bBAd\u0001\u0011\u0005\u0011\u0011Z\u0001\tg\u0016$H*\u00192fYR1\u0011\u0011SAf\u0003\u001bD\u0001\"a'\u0002F\u0002\u0007\u0011Q\u0014\u0005\t\u0003W\u000b)\r1\u0001\u0002.\"B\u0011QYA[\u0003\u007f\u000b\t.\t\u0002\u0002T\u0006ag-\u001e8di&|g\u000e\u000b<bYV,'h\u001d;sS:<\u0017FO:ue&tw\rI\u0017.AM+Go\u001d\u0011uQ\u0016\u0004C.\u00192fY\u0002zg\r\t;iK\u0002\"'/\u001b<f]\u0001\u0012V\r^;s]N\u0004C\u000f[3!]\u0016<\bE^1mk\u0016d\u0003e\u001e5jG\"\u0004S.Y=!E\u0016\u0004CO];oG\u0006$X\r\u001a\u0018\t\u000f\u0005]\u0007\u0001\"\u0001\u0002Z\u0006Yq-\u001a;DCB\f7-\u001b;z)\u0019\t\t*a7\u0002^\"A\u00111TAk\u0001\u0004\ti\n\u0003\u0005\u0002,\u0006U\u0007\u0019AAWQ1\t).!.\u0002<\u0006u\u0016qXAqC\t\t\u0019/A$gk:\u001cG/[8oQ%Rd.^7cKJ\u0004S&\f\u0011SKR,(O\\:!i\",\u0007\u0005^8uC2\u00043-\u00199bG&$\u0018\u0010I8gAQDW\r\t3sSZ,G\u0006I5oA\tLH/Z:/\u0011\u001d\t9\u000f\u0001C\u0001\u0003S\fQbZ3u'\u0016\u001cGo\u001c:TSj,GCBAI\u0003W\fi\u000f\u0003\u0005\u0002\u001c\u0006\u0015\b\u0019AAO\u0011!\tY+!:A\u0002\u00055\u0006\u0006DAs\u0003k\u000bY,!0\u0002@\u0006E\u0018EAAz\u0003A3WO\\2uS>t\u0007&\u000b\u001eok6\u0014WM\u001d\u0011.[\u0001\u0012V\r^;s]N\u0004C\u000f[3!g&TX\rI8gA\u0005\u00043/\u001b8hY\u0016\u00043/Z2u_J\u0004sN\u001c\u0011uQ\u0016\u0004CM]5wK2\u0002\u0013N\u001c\u0011csR,7O\f\u0005\b\u0003o\u0004A\u0011AA}\u0003=9W\r\u001e)mCR$XM]\"pk:$HCBAI\u0003w\fi\u0010\u0003\u0005\u0002\u001c\u0006U\b\u0019AAO\u0011!\tY+!>A\u0002\u00055\u0006\u0006DA{\u0003k\u000bY,!0\u0002@\n\u0005\u0011E\u0001B\u0002\u0003\u00053WO\\2uS>t\u0007&\u000b\u001eok6\u0014WM\u001d\u0011.[\u0001\u0012V\r^;s]N\u0004C\u000f[3!]Vl'-\u001a:!_\u001a\u0004\u0003\u000f\\1ui\u0016\u00148\u000fI5oAQDW\r\t3sSZ,g\u0006C\u0004\u0003\b\u0001!\tA!\u0003\u0002\u0015I,\u0017\rZ*fGR|'\u000f\u0006\u0004\u0002\u0012\n-!Q\u0002\u0005\t\u00037\u0013)\u00011\u0001\u0002\u001e\"A\u00111\u0016B\u0003\u0001\u0004\ti\u000b\u000b\u0007\u0003\u0006\u0005U\u00161XA_\u0003\u007f\u0013\t\"\t\u0002\u0003\u0014\u0005!f-\u001e8di&|g\u000eK:fGR|'O\u000f8v[\n,'/\u000b\u001etiJLgn\u001a\u0011.[\u0001\u0012V-\u00193!i\",\u0007eY;se\u0016tG\u000fI2p]R,g\u000e^:!_\u001a\u0004C\u000f[3!gB,7-\u001b4jK\u0012\u00043/Z2u_Jt\u0003b\u0002B\f\u0001\u0011\u0005!\u0011D\u0001\foJLG/Z*fGR|'\u000f\u0006\u0004\u0002\u0012\nm!Q\u0004\u0005\t\u00037\u0013)\u00021\u0001\u0002\u001e\"A\u00111\u0016B\u000b\u0001\u0004\ti\u000b\u000b\u0007\u0003\u0016\u0005U\u00161XA_\u0003\u007f\u0013\t#\t\u0002\u0003$\u0005qf-\u001e8di&|g\u000eK:fGR|'O\u000f8v[\n,'\u000f\f\u0011wC2,XMO:ue&tw-\u000b\u0011.[\u0001:&/\u001b;fAQDW\rI:qK\u000eLg-[3eA\r|g\u000e^3oiN\u0004Co\u001c\u0011uQ\u0016\u00043\u000f]3dS\u001aLW\r\u001a\u0011tK\u000e$xN\u001d\u0018\t\u000f\t\u001d\u0002\u0001\"\u0001\u0003*\u0005A!/Z1e\u0005f$X\r\u0006\u0004\u0002\u0012\n-\"Q\u0006\u0005\t\u00037\u0013)\u00031\u0001\u0002\u001e\"A\u00111\u0016B\u0013\u0001\u0004\ti\u000b\u000b\u0007\u0003&\u0005U\u00161XA_\u0003\u007f\u0013\t$\t\u0002\u00034\u0005ie-\u001e8di&|g\u000eK8gMN,GO\u000f8v[\n,'/\u000b\u001eok6\u0014WM\u001d\u0011.[\u0001\u0012V-\u00193!C\u0002\u001a\u0018N\\4mK\u0002\u0012\u0017\u0010^3!CR\u0004C\u000f[3!gB,7-\u001b4jK\u0012\u0004sN\u001a4tKRt\u0003b\u0002B\u001c\u0001\u0011\u0005!\u0011H\u0001\noJLG/\u001a\"zi\u0016$b!!%\u0003<\tu\u0002\u0002CAN\u0005k\u0001\r!!(\t\u0011\u0005-&Q\u0007a\u0001\u0003[CCB!\u000e\u00026\u0006m\u0016QXA`\u0005\u0003\n#Aa\u0011\u0002+\u001a,hn\u0019;j_:DsN\u001a4tKRTd.^7cKJd\u0003E^1mk\u0016Td.^7cKJL\u0003%L\u0017!/JLG/\u001a\u0011bAMLgn\u001a7fA\tLH/\u001a\u0011u_\u0002\"\b.\u001a\u0011ta\u0016\u001c\u0017NZ5fI\u0002zgMZ:fi:B\u0011Ba\u0012\u0001\u0005\u0004%iA!\u0013\u0002\u0015!+\u0017\r\u001a)pgR\u000bw-\u0006\u0002\u0003L=\u0011!QJ\u0011\u0003\u0003/A\u0001B!\u0015\u0001A\u00035!1J\u0001\f\u0011\u0016\fG\rU8t)\u0006<\u0007\u0005C\u0004\u0003V\u0001!\tEa\u0016\u0002\t1|\u0017\r\u001a\u000b\u0005\u0003?\u0011I\u0006\u0003\u0005\u0003\\\tM\u0003\u0019\u0001B/\u0003\rq'\r\u001e\t\u0005\u0005?\u0012Y'\u0004\u0002\u0003b)!!1\fB2\u0015\u0011\u0011)Ga\u001a\u0002\u00135Lg.Z2sC\u001a$(B\u0001B5\u0003\rqW\r^\u0005\u0005\u0005[\u0012\tG\u0001\bO\u0005R#\u0016mZ\"p[B|WO\u001c3\t\u000f\tE\u0004\u0001\"\u0011\u0003t\u0005!1/\u0019<f)\u0011\tyB!\u001e\t\u0011\tm#q\u000ea\u0001\u0005;BqA!\u001f\u0001\t\u0013\u0011Y(\u0001\bwC2LG-\u0019;f'\u0016\u001cGo\u001c:\u0015\u0007}\u0011i\bC\u0004\u0003\u0000\t]\u0004\u0019A\u0010\u0002\rM,7\r^8s\u0011\u001d\u0011\u0019\t\u0001C\u0005\u0005\u000b\u000b1b\u00195fG.\u001cVm\u0019;peR\u0019qDa\"\t\u000f\t%%\u0011\u0011a\u0001?\u00051qN\u001a4tKRDqAa!\u0001\t\u0013\u0011i\tF\u0003 \u0005\u001f\u0013\t\n\u0003\u0005\u0002,\n-\u0005\u0019AAW\u0011\u001d\u0011\u0019Ja#A\u0002}\t\u0011A\u001c\u0005\b\u0005/\u0003A\u0011\u0002BM\u00031iwN^3U_N+7\r^8s)\u0015y\"1\u0014BO\u0011!\tYJ!&A\u0002\u0005u\u0005b\u0002B@\u0005+\u0003\ra\b\u0005\b\u0005C\u0003A\u0011\u0002BR\u0003=\u0019Xm\u0019;peR{\u0007*Z1e!>\u001cHcA\u0010\u0003&\"9!q\u0010BP\u0001\u0004y\u0002b\u0002BU\u0001\u0011%!1V\u0001\rg\u0016\u001cGo\u001c:PM\u001a\u001cX\r\u001e\u000b\u0004?\t5\u0006b\u0002B@\u0005O\u0003\ra\b\u0005\b\u0005c\u0003A\u0011\u0002BZ\u00031ygMZ:fiN+7\r^8s)\ry\"Q\u0017\u0005\b\u0005\u0013\u0013y\u000b1\u0001 \u0011\u001d\u0011I\f\u0001C\u0005\u0005w\u000bA\u0002Z5tW\u0006\u001bG/\u001b<jif$\"!a\b")
public class Drive
extends AbstractManagedEnvironment
implements DeviceInfo {
    private final int capacity;
    private final int platterCount;
    private final Label label;
    private final Option<EnvironmentHost> host;
    private final Option<String> sound;
    private final int speed;
    private final ComponentConnector node;
    private final int sectorSize;
    private final byte[] data;
    private final int sectorCount;
    private final int sectorsPerPlatter;
    private int headPos;
    private final double[] readSectorCosts;
    private final double[] writeSectorCosts;
    private final double[] readByteCosts;
    private final double[] writeByteCosts;
    private Map<String, String> deviceInfo;
    private final String HeadPosTag;
    private volatile boolean bitmap$0;

    private Map deviceInfo$lzycompute() {
        Drive drive = this;
        synchronized (drive) {
            if (!this.bitmap$0) {
                this.deviceInfo = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"class"), (Object)"disk"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"description"), (Object)"Hard disk drive"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"vendor"), (Object)"MightyPirates GmbH & Co. KG"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"product"), (Object)new StringBuilder().append((Object)"MPD").append((Object)((Object)BoxesRunTime.boxToInteger((int)(this.capacity() / 1024))).toString()).append((Object)"L").append((Object)((Object)BoxesRunTime.boxToInteger((int)this.platterCount())).toString()).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"capacity"), (Object)((Object)BoxesRunTime.boxToInteger((int)((int)((double)this.capacity() * 1.024)))).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"size"), (Object)((Object)BoxesRunTime.boxToInteger((int)this.capacity())).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clock"), (Object)new StringBuilder().append((Object)((Object)BoxesRunTime.boxToInteger((int)((int)((double)2000 / this.readSectorCosts()[this.speed()]) / 100))).toString()).append((Object)"/").append((Object)((Object)BoxesRunTime.boxToInteger((int)((int)((double)2000 / this.writeSectorCosts()[this.speed()]) / 100))).toString()).append((Object)"/").append((Object)((Object)BoxesRunTime.boxToInteger((int)((int)((double)2000 / this.readByteCosts()[this.speed()]) / 100))).toString()).append((Object)"/").append((Object)((Object)BoxesRunTime.boxToInteger((int)((int)((double)2000 / this.writeByteCosts()[this.speed()]) / 100))).toString()).toString())}));
                this.bitmap$0 = true;
            }
            return this.deviceInfo;
        }
    }

    public int capacity() {
        return this.capacity;
    }

    public int platterCount() {
        return this.platterCount;
    }

    public Label label() {
        return this.label;
    }

    public Option<String> sound() {
        return this.sound;
    }

    public int speed() {
        return this.speed;
    }

    @Override
    public ComponentConnector node() {
        return this.node;
    }

    private File savePath() {
        return new File(DimensionManager.getCurrentSaveRootDirectory(), new StringBuilder().append((Object)Settings$.MODULE$.savePath()).append((Object)this.node().address()).append((Object)".bin").toString());
    }

    private final int sectorSize() {
        return 512;
    }

    private byte[] data() {
        return this.data;
    }

    private int sectorCount() {
        return this.sectorCount;
    }

    private int sectorsPerPlatter() {
        return this.sectorsPerPlatter;
    }

    private int headPos() {
        return this.headPos;
    }

    private void headPos_$eq(int x$1) {
        this.headPos = x$1;
    }

    public final double[] readSectorCosts() {
        return this.readSectorCosts;
    }

    public final double[] writeSectorCosts() {
        return this.writeSectorCosts;
    }

    public final double[] readByteCosts() {
        return this.readByteCosts;
    }

    public final double[] writeByteCosts() {
        return this.writeByteCosts;
    }

    private final Map<String, String> deviceInfo() {
        return this.bitmap$0 ? this.deviceInfo : this.deviceInfo$lzycompute();
    }

    @Override
    public java.util.Map<String, String> getDeviceInfo() {
        return WrapAsJava$.MODULE$.mapAsJavaMap(this.deviceInfo());
    }

    @Callback(direct=true, doc="function():string -- Get the current label of the drive.")
    public synchronized Object[] getLabel(Context context, Arguments args) {
        return this.label() == null ? null : package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.label().getLabel()}));
    }

    @Callback(doc="function(value:string):string -- Sets the label of the drive. Returns the new value, which may be truncated.")
    public synchronized Object[] setLabel(Context context, Arguments args) {
        if (this.label() == null) {
            throw new Exception("drive does not support labeling");
        }
        if (args.checkAny(0) == null) {
            this.label().setLabel(null);
        } else {
            this.label().setLabel(args.checkString(0));
        }
        return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.label().getLabel()}));
    }

    @Callback(direct=true, doc="function():number -- Returns the total capacity of the drive, in bytes.")
    public Object[] getCapacity(Context context, Arguments args) {
        return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.capacity())}));
    }

    @Callback(direct=true, doc="function():number -- Returns the size of a single sector on the drive, in bytes.")
    public Object[] getSectorSize(Context context, Arguments args) {
        return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)512)}));
    }

    @Callback(direct=true, doc="function():number -- Returns the number of platters in the drive.")
    public Object[] getPlatterCount(Context context, Arguments args) {
        return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.platterCount())}));
    }

    @Callback(direct=true, doc="function(sector:number):string -- Read the current contents of the specified sector.")
    public synchronized Object[] readSector(Context context, Arguments args) {
        context.consumeCallBudget(this.readSectorCosts()[this.speed()]);
        int sector = this.moveToSector(context, this.checkSector(args, 0));
        this.diskActivity();
        byte[] sectorData = new byte[512];
        Array$.MODULE$.copy((Object)this.data(), this.sectorOffset(sector), (Object)sectorData, 0, 512);
        return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sectorData}));
    }

    @Callback(direct=true, doc="function(sector:number, value:string) -- Write the specified contents to the specified sector.")
    public synchronized Object[] writeSector(Context context, Arguments args) {
        context.consumeCallBudget(this.writeSectorCosts()[this.speed()]);
        byte[] sectorData = args.checkByteArray(1);
        int sector = this.moveToSector(context, this.checkSector(args, 0));
        this.diskActivity();
        Array$.MODULE$.copy((Object)sectorData, 0, (Object)this.data(), this.sectorOffset(sector), scala.math.package$.MODULE$.min(512, sectorData.length));
        return null;
    }

    @Callback(direct=true, doc="function(offset:number):number -- Read a single byte at the specified offset.")
    public synchronized Object[] readByte(Context context, Arguments args) {
        context.consumeCallBudget(this.readByteCosts()[this.speed()]);
        int offset = args.checkInteger(0) - 1;
        this.moveToSector(context, this.checkSector(offset));
        this.diskActivity();
        return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)this.data()[offset])}));
    }

    @Callback(direct=true, doc="function(offset:number, value:number) -- Write a single byte to the specified offset.")
    public synchronized Object[] writeByte(Context context, Arguments args) {
        context.consumeCallBudget(this.writeByteCosts()[this.speed()]);
        int offset = args.checkInteger(0) - 1;
        byte value = (byte)args.checkInteger(1);
        this.moveToSector(context, this.checkSector(offset));
        this.diskActivity();
        this.data()[offset] = value;
        return null;
    }

    private final String HeadPosTag() {
        return "headPos";
    }

    @Override
    public synchronized void load(NBTTagCompound nbt) {
        super.load(nbt);
        if (this.node().address() != null) {
            try {
                File path = this.savePath();
                if (path.exists()) {
                    ByteArrayInputStream bin = new ByteArrayInputStream(Files.toByteArray((File)path));
                    GZIPInputStream zin = new GZIPInputStream(bin);
                    int read = 0;
                    for (int offset = 0; read >= 0 && offset < this.data().length; offset += read) {
                        read = zin.read(this.data(), offset, this.data().length - offset);
                    }
                }
            }
            catch (Throwable throwable) {
                OpenComputers$.MODULE$.log().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed loading drive contents for '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.node().address()})), throwable);
            }
        }
        this.headPos_$eq(RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(nbt.func_74762_e("headPos")), 0)), this.sectorToHeadPos(this.sectorCount())));
        if (this.label() != null) {
            this.label().load(nbt);
        }
    }

    @Override
    public synchronized void save(NBTTagCompound nbt) {
        super.save(nbt);
        if (this.node().address() != null) {
            try {
                File path = this.savePath();
                path.getParentFile().mkdirs();
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                GZIPOutputStream zos = new GZIPOutputStream(bos);
                zos.write(this.data());
                zos.close();
                Files.write((byte[])bos.toByteArray(), (File)path);
            }
            catch (Throwable throwable) {
                OpenComputers$.MODULE$.log().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed saving drive contents for '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.node().address()})), throwable);
            }
        }
        nbt.func_74768_a("headPos", this.headPos());
        if (this.label() != null) {
            this.label().save(nbt);
        }
    }

    private int validateSector(int sector) {
        if (sector < 0 || sector >= this.sectorCount()) {
            throw new IllegalArgumentException("invalid offset, not in a usable sector");
        }
        return sector;
    }

    private int checkSector(int offset) {
        return this.validateSector(this.offsetSector(offset));
    }

    private int checkSector(Arguments args, int n) {
        return this.validateSector(args.checkInteger(n) - 1);
    }

    private int moveToSector(Context context, int sector) {
        int newHeadPos = this.sectorToHeadPos(sector);
        if (this.headPos() != newHeadPos) {
            int delta = scala.math.package$.MODULE$.abs(this.headPos() - newHeadPos);
            Object object = delta > Settings$.MODULE$.get().sectorSeekThreshold() ? BoxesRunTime.boxToBoolean((boolean)context.pause(Settings$.MODULE$.get().sectorSeekTime())) : BoxedUnit.UNIT;
            this.headPos_$eq(newHeadPos);
        }
        return sector;
    }

    private int sectorToHeadPos(int sector) {
        return sector % this.sectorsPerPlatter();
    }

    private int sectorOffset(int sector) {
        return sector * 512;
    }

    private int offsetSector(int offset) {
        return offset / 512;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void diskActivity() {
        Tuple2 tuple2 = new Tuple2(this.sound(), this.host);
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                String s = (String)some.x();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    EnvironmentHost h = (EnvironmentHost)some2.x();
                    PacketSender$.MODULE$.sendFileSystemActivity(this.node(), h, s);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public Drive(int capacity, int platterCount, Label label, Option<EnvironmentHost> host, Option<String> sound, int speed) {
        this.capacity = capacity;
        this.platterCount = platterCount;
        this.label = label;
        this.host = host;
        this.sound = sound;
        this.speed = speed;
        this.node = (ComponentConnector)Network.newNode(this, Visibility.Network).withComponent("drive", Visibility.Neighbors).withConnector().create();
        this.data = new byte[capacity];
        this.sectorCount = capacity / 512;
        this.sectorsPerPlatter = this.sectorCount() / platterCount;
        this.headPos = 0;
        this.readSectorCosts = new double[]{0.1, 0.05, 0.03333333333333333, 0.025, 0.02, 0.016666666666666666};
        this.writeSectorCosts = new double[]{0.2, 0.1, 0.06666666666666667, 0.05, 0.04, 0.03333333333333333};
        this.readByteCosts = new double[]{0.020833333333333332, 0.015625, 0.0125, 0.010416666666666666, 0.008928571428571428, 0.0078125};
        this.writeByteCosts = new double[]{0.041666666666666664, 0.03125, 0.025, 0.020833333333333332, 0.017857142857142856, 0.015625};
    }
}

