/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.schema;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import org.dave.compactmachines3.reference.EnumMachineSize;
import org.dave.compactmachines3.schema.BlockInformation;
import org.dave.compactmachines3.schema.Schema;

public class SchemaSerializer
implements JsonSerializer<Schema>,
JsonDeserializer<Schema> {
    public Schema deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!json.isJsonObject()) {
            return null;
        }
        JsonObject jsonRoot = json.getAsJsonObject();
        Type type = new TypeToken<List<BlockInformation>>(){}.getType();
        EnumMachineSize size = EnumMachineSize.getFromMeta(jsonRoot.get("size").getAsInt());
        Schema result = new Schema(jsonRoot.get("name").getAsString());
        result.setBlocks((List)context.deserialize((JsonElement)jsonRoot.get("blocks").getAsJsonArray(), type));
        result.setSize(size);
        JsonArray spawnPos = jsonRoot.getAsJsonArray("spawn");
        double[] spawnPosition = new double[]{spawnPos.get(0).getAsDouble(), spawnPos.get(1).getAsDouble(), spawnPos.get(2).getAsDouble()};
        result.setSpawnPosition(spawnPosition);
        return result;
    }

    public JsonElement serialize(Schema src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject root = new JsonObject();
        root.addProperty("name", src.getName());
        root.addProperty("size", (Number)src.getSize().getMeta());
        root.add("blocks", context.serialize(src.getBlocks()));
        JsonArray spawnArray = new JsonArray();
        spawnArray.add((Number)src.getSpawnPosition()[0]);
        spawnArray.add((Number)src.getSpawnPosition()[1]);
        spawnArray.add((Number)src.getSpawnPosition()[2]);
        root.add("spawn", (JsonElement)spawnArray);
        return root;
    }
}

