/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLContainer;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.InjectedModContainer;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryInternal;
import net.minecraftforge.registries.IForgeRegistryModifiable;
import net.minecraftforge.registries.RegistryDelegate;
import net.minecraftforge.registries.RegistryManager;
import org.apache.commons.lang3.Validate;

public class ForgeRegistry<V extends IForgeRegistryEntry<V>>
implements IForgeRegistryInternal<V>,
IForgeRegistryModifiable<V> {
    public static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("forge.debugRegistryEntries", "false"));
    private final RegistryManager stage;
    private final BiMap<Integer, V> ids = HashBiMap.create();
    private final BiMap<nf, V> names = HashBiMap.create();
    private final Class<V> superType;
    private final Map<nf, nf> aliases = Maps.newHashMap();
    final Map<nf, ?> slaves = Maps.newHashMap();
    private final nf defaultKey;
    private final IForgeRegistry.CreateCallback<V> create;
    private final IForgeRegistry.AddCallback<V> add;
    private final IForgeRegistry.ClearCallback<V> clear;
    private final IForgeRegistry.ValidateCallback<V> validate;
    private final IForgeRegistry.MissingFactory<V> missing;
    private final BitSet availabilityMap;
    private final Set<nf> dummies = Sets.newHashSet();
    private final Set<Integer> blocked = Sets.newHashSet();
    private final Multimap<nf, V> overrides = ArrayListMultimap.create();
    private final BiMap<OverrideOwner, V> owners = HashBiMap.create();
    private final IForgeRegistry.DummyFactory<V> dummyFactory;
    private final boolean isDelegated;
    private final int min;
    private final int max;
    private final boolean allowOverrides;
    private final boolean isModifiable;
    private V defaultValue = null;
    boolean isFrozen = false;

    ForgeRegistry(Class<V> superType, nf defaultKey, int min, int max, @Nullable IForgeRegistry.CreateCallback<V> create, @Nullable IForgeRegistry.AddCallback<V> add, @Nullable IForgeRegistry.ClearCallback<V> clear, @Nullable IForgeRegistry.ValidateCallback<V> validate, RegistryManager stage, boolean allowOverrides, boolean isModifiable, @Nullable IForgeRegistry.DummyFactory<V> dummyFactory, @Nullable IForgeRegistry.MissingFactory<V> missing) {
        this.stage = stage;
        this.superType = superType;
        this.defaultKey = defaultKey;
        this.min = min;
        this.max = max;
        this.availabilityMap = new BitSet(Math.min(max + 1, 4095));
        this.create = create;
        this.add = add;
        this.clear = clear;
        this.validate = validate;
        this.missing = missing;
        this.isDelegated = IForgeRegistryEntry.Impl.class.isAssignableFrom(superType);
        this.allowOverrides = allowOverrides;
        this.isModifiable = isModifiable;
        this.dummyFactory = dummyFactory;
        if (this.create != null) {
            this.create.onCreate(this, stage);
        }
    }

    @Override
    public void register(V value) {
        this.add(-1, value);
    }

    @Override
    public Iterator<V> iterator() {
        return new Iterator<V>(){
            int cur = -1;
            V next = null;
            {
                this.next();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public V next() {
                Object ret = this.next;
                do {
                    this.cur = ForgeRegistry.this.availabilityMap.nextSetBit(this.cur + 1);
                    this.next = (IForgeRegistryEntry)ForgeRegistry.this.ids.get((Object)this.cur);
                } while (this.next == null && this.cur != -1);
                return ret;
            }
        };
    }

    @Override
    public Class<V> getRegistrySuperType() {
        return this.superType;
    }

    @Override
    public void registerAll(V ... values) {
        for (V value : values) {
            this.register(value);
        }
    }

    @Override
    public boolean containsKey(nf key) {
        while (key != null) {
            if (this.names.containsKey((Object)key)) {
                return true;
            }
            key = this.aliases.get(key);
        }
        return false;
    }

    @Override
    public boolean containsValue(V value) {
        return this.names.containsValue(value);
    }

    @Override
    public V getValue(nf key) {
        IForgeRegistryEntry ret = (IForgeRegistryEntry)this.names.get((Object)key);
        key = this.aliases.get(key);
        while (ret == null && key != null) {
            ret = (IForgeRegistryEntry)this.names.get((Object)key);
            key = this.aliases.get(key);
        }
        return (V)(ret == null ? this.defaultValue : ret);
    }

    @Override
    public nf getKey(V value) {
        return (nf)this.names.inverse().get(value);
    }

    @Override
    public Set<nf> getKeys() {
        return Collections.unmodifiableSet(this.names.keySet());
    }

    @Override
    @Deprecated
    public List<V> getValues() {
        return ImmutableList.copyOf((Collection)this.names.values());
    }

    @Override
    @Nonnull
    public Collection<V> getValuesCollection() {
        return Collections.unmodifiableSet(this.names.values());
    }

    @Override
    public Set<Map.Entry<nf, V>> getEntries() {
        return Collections.unmodifiableSet(this.names.entrySet());
    }

    @Override
    public <T> T getSlaveMap(nf name, Class<T> type) {
        return (T)this.slaves.get(name);
    }

    @Override
    public void setSlaveMap(nf name, Object obj) {
        this.slaves.put(name, obj);
    }

    public int getID(V value) {
        Integer ret = (Integer)this.ids.inverse().get(value);
        if (ret == null && this.defaultValue != null) {
            ret = (Integer)this.ids.inverse().get(this.defaultValue);
        }
        return ret == null ? -1 : ret;
    }

    public int getID(nf name) {
        return this.getID((IForgeRegistryEntry)this.names.get((Object)name));
    }

    private int getIDRaw(V value) {
        Integer ret = (Integer)this.ids.inverse().get(value);
        return ret == null ? -1 : ret;
    }

    private int getIDRaw(nf name) {
        return this.getIDRaw((IForgeRegistryEntry)this.names.get((Object)name));
    }

    public V getValue(int id) {
        IForgeRegistryEntry ret = (IForgeRegistryEntry)this.ids.get((Object)id);
        return (V)(ret == null ? this.defaultValue : ret);
    }

    void validateKey() {
        if (this.defaultKey != null) {
            Validate.notNull(this.defaultValue, (String)("Missing default of ForgeRegistry: " + this.defaultKey + " Type: " + this.superType), (Object[])new Object[0]);
        }
    }

    ForgeRegistry<V> copy(RegistryManager stage) {
        return new ForgeRegistry<V>(this.superType, this.defaultKey, this.min, this.max, this.create, this.add, this.clear, this.validate, stage, this.allowOverrides, this.isModifiable, this.dummyFactory, this.missing);
    }

    int add(int id, V value) {
        ModContainer mc = Loader.instance().activeModContainer();
        String owner = mc == null || mc instanceof InjectedModContainer && ((InjectedModContainer)mc).wrappedContainer instanceof FMLContainer ? null : mc.getModId().toLowerCase();
        return this.add(id, value, owner);
    }

    int add(int id, V value, String owner) {
        Integer foundId;
        nf key = value == null ? null : value.getRegistryName();
        Preconditions.checkNotNull((Object)key, (String)"Can't use a null-name for the registry, object %s.", value);
        Preconditions.checkNotNull(value, (String)"Can't add null-object to the registry, name %s.", (Object)key);
        int idToUse = id;
        if (idToUse < 0 || this.availabilityMap.get(idToUse)) {
            idToUse = this.availabilityMap.nextClearBit(this.min);
        }
        if (idToUse > this.max) {
            throw new RuntimeException(String.format("Invalid id %d - maximum id range exceeded.", idToUse));
        }
        V oldEntry = this.getRaw(key);
        if (oldEntry == value) {
            FMLLog.bigWarning("Registry {}: The object {} has been registered twice for the same name {}.", this.superType.getSimpleName(), value, key);
            return this.getID(value);
        }
        if (oldEntry != null) {
            if (!this.allowOverrides) {
                throw new IllegalArgumentException(String.format("The name %s has been registered twice, for %s and %s.", key, this.getRaw(key), value));
            }
            if (owner == null) {
                throw new IllegalStateException(String.format("Could not determine owner for the override on %s. Value: %s", key, value));
            }
            if (DEBUG) {
                FMLLog.log.debug("Registry {} Override: {} {} -> {}", (Object)this.superType.getSimpleName(), (Object)key, oldEntry, value);
            }
            idToUse = this.getID(oldEntry);
        }
        if ((foundId = (Integer)this.ids.inverse().get(value)) != null) {
            IForgeRegistryEntry otherThing = (IForgeRegistryEntry)this.ids.get((Object)foundId);
            throw new IllegalArgumentException(String.format("The object %s{%x} has been registered twice, using the names %s and %s. (Other object at this id is %s{%x})", value, System.identityHashCode(value), this.getKey(value), key, otherThing, System.identityHashCode(otherThing)));
        }
        if (this.isLocked()) {
            throw new IllegalStateException(String.format("The object %s (name %s) is being added too late.", value, key));
        }
        if (this.defaultKey != null && this.defaultKey.equals((Object)key)) {
            if (this.defaultValue != null) {
                throw new IllegalStateException(String.format("Attemped to override already set default value. This is not allowed: The object %s (name %s)", value, key));
            }
            this.defaultValue = value;
        }
        this.names.put((Object)key, value);
        this.ids.put((Object)idToUse, value);
        this.availabilityMap.set(idToUse);
        this.owners.put((Object)new OverrideOwner(owner == null ? key.b() : owner, key), value);
        if (this.isDelegated) {
            this.getDelegate(value).setName(key);
            if (oldEntry != null) {
                if (!this.overrides.get((Object)key).contains(oldEntry)) {
                    this.overrides.put((Object)key, oldEntry);
                }
                this.overrides.get((Object)key).remove(value);
                if (this.stage == RegistryManager.ACTIVE) {
                    this.getDelegate(oldEntry).changeReference(value);
                }
            }
        }
        if (this.add != null) {
            this.add.onAdd(this, this.stage, idToUse, value, oldEntry);
        }
        if (this.dummies.remove(key) && DEBUG) {
            FMLLog.log.debug("Registry {} Dummy Remove: {}", (Object)this.superType.getSimpleName(), (Object)key);
        }
        if (DEBUG) {
            FMLLog.log.trace("Registry {} add: {} {} {} (req. id {})", (Object)this.superType.getSimpleName(), (Object)key, (Object)idToUse, value, (Object)id);
        }
        return idToUse;
    }

    private V getRaw(nf key) {
        IForgeRegistryEntry ret = (IForgeRegistryEntry)this.names.get((Object)key);
        key = this.aliases.get(key);
        while (ret == null && key != null) {
            ret = (IForgeRegistryEntry)this.names.get((Object)key);
            key = this.aliases.get(key);
        }
        return (V)ret;
    }

    @Deprecated
    public V getRaw(int id) {
        return (V)((IForgeRegistryEntry)this.ids.get((Object)id));
    }

    void addAlias(nf from, nf to) {
        if (this.isLocked()) {
            throw new IllegalStateException(String.format("Attempted to register the alias %s -> %s to late", from, to));
        }
        this.aliases.put(from, to);
        if (DEBUG) {
            FMLLog.log.trace("Registry {} alias: {} -> {}", (Object)this.superType.getSimpleName(), (Object)from, (Object)to);
        }
    }

    void addDummy(nf key) {
        if (this.isLocked()) {
            throw new IllegalStateException(String.format("Attempted to register the dummy %s to late", key));
        }
        this.dummies.add(key);
        if (DEBUG) {
            FMLLog.log.trace("Registry {} dummy: {}", (Object)this.superType.getSimpleName(), (Object)key);
        }
    }

    private RegistryDelegate<V> getDelegate(V thing) {
        if (this.isDelegated) {
            return (RegistryDelegate)((IForgeRegistryEntry.Impl)thing).delegate;
        }
        throw new IllegalStateException("Tried to get existing delegate from registry that is not delegated.");
    }

    void resetDelegates() {
        if (!this.isDelegated) {
            return;
        }
        for (IForgeRegistryEntry value : this) {
            this.getDelegate(value).changeReference(value);
        }
        for (IForgeRegistryEntry value : this.overrides.values()) {
            this.getDelegate(value).changeReference(value);
        }
    }

    V getDefault() {
        return this.defaultValue;
    }

    boolean isDummied(nf key) {
        return this.dummies.contains(key);
    }

    void validateContent(nf registryName) {
        try {
            ReflectionHelper.findMethod(BitSet.class, "trimToSize", null, new Class[0]).invoke((Object)this.availabilityMap, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (IForgeRegistryEntry obj : this) {
            int id = this.getID(obj);
            nf name = this.getKey(obj);
            if (name == null) {
                throw new IllegalStateException(String.format("Registry entry for %s %s, id %d, doesn't yield a name.", registryName, obj, id));
            }
            if (id > this.max) {
                throw new IllegalStateException(String.format("Registry entry for %s %s, name %s uses the too large id %d.", registryName, obj, name, id));
            }
            if (this.getValue(id) != obj) {
                throw new IllegalStateException(String.format("Registry entry for id %d, name %s, doesn't yield the expected %s %s.", id, name, registryName, obj));
            }
            if (this.getValue(name) != obj) {
                throw new IllegalStateException(String.format("Registry entry for name %s, id %d, doesn't yield the expected %s %s.", name, id, registryName, obj));
            }
            if (this.getID(name) != id) {
                throw new IllegalStateException(String.format("Registry entry for name %s doesn't yield the expected id %d.", name, id));
            }
            if (this.validate == null) continue;
            this.validate.onValidate(this, this.stage, id, name, obj);
        }
    }

    void sync(nf name, ForgeRegistry<V> from) {
        if (DEBUG) {
            FMLLog.log.debug("Registry {} Sync: {} -> {}", (Object)this.superType.getSimpleName(), (Object)this.stage.getName(), (Object)from.stage.getName());
        }
        if (this == from) {
            throw new IllegalArgumentException("WTF We are the same!?!?!");
        }
        if (from.superType != this.superType) {
            throw new IllegalArgumentException("Attempted to copy to incompatible registry: " + name + " " + from.superType + " -> " + this.superType);
        }
        this.isFrozen = false;
        if (this.clear != null) {
            this.clear.onClear(this, this.stage);
        }
        this.aliases.clear();
        from.aliases.forEach(this::addAlias);
        this.ids.clear();
        this.names.clear();
        this.availabilityMap.clear(0, this.availabilityMap.length());
        this.defaultValue = null;
        this.overrides.clear();
        this.owners.clear();
        boolean errored = false;
        for (Map.Entry entry : from.names.entrySet()) {
            ArrayList overrides = Lists.newArrayList((Iterable)from.overrides.get(entry.getKey()));
            int id = from.getID((nf)entry.getKey());
            if (overrides.isEmpty()) {
                int realId = this.add(id, (IForgeRegistryEntry)entry.getValue());
                if (id == realId || id == -1) continue;
                FMLLog.log.warn("Registry {}: Object did not get ID it asked for. Name: {} Expected: {} Got: {}", (Object)this.superType.getSimpleName(), entry.getKey(), (Object)id, (Object)realId);
                errored = true;
                continue;
            }
            overrides.add(entry.getValue());
            for (IForgeRegistryEntry value : overrides) {
                OverrideOwner owner = (OverrideOwner)from.owners.inverse().get((Object)value);
                if (owner == null) {
                    FMLLog.log.warn("Registry {}: Override did not have an associated owner object. Name: {} Value: {}", (Object)this.superType.getSimpleName(), entry.getKey(), (Object)value);
                    errored = true;
                    continue;
                }
                int realId = this.add(id, value, owner.owner);
                if (id == realId || id == -1) continue;
                FMLLog.log.warn("Registry {}: Object did not get ID it asked for. Name: {} Expected: {} Got: {}", (Object)this.superType.getSimpleName(), entry.getKey(), (Object)id, (Object)realId);
                errored = true;
            }
        }
        this.dummies.clear();
        from.dummies.forEach(this::addDummy);
        if (errored) {
            throw new RuntimeException("One of more entry values did not copy to the correct id. Check log for details!");
        }
    }

    @Override
    public void clear() {
        if (!this.isModifiable) {
            throw new UnsupportedOperationException("Attempted to clear a non-modifiable Forge Registry");
        }
        if (this.isLocked()) {
            throw new IllegalStateException("Attempted to clear the registry to late.");
        }
        if (this.clear != null) {
            this.clear.onClear(this, this.stage);
        }
        this.aliases.clear();
        this.dummies.clear();
        this.ids.clear();
        this.names.clear();
        this.availabilityMap.clear(0, this.availabilityMap.length());
    }

    @Override
    public V remove(nf key) {
        if (!this.isModifiable) {
            throw new UnsupportedOperationException("Attempted to remove from a non-modifiable Forge Registry");
        }
        if (this.isLocked()) {
            throw new IllegalStateException("Attempted to remove from the registry to late.");
        }
        IForgeRegistryEntry value = (IForgeRegistryEntry)this.names.remove((Object)key);
        if (value != null) {
            Integer id = (Integer)this.ids.inverse().remove((Object)value);
            if (id == null) {
                throw new IllegalStateException("Removed a entry that did not have an associated id: " + key + " " + value.toString() + " This should never happen unless hackery!");
            }
            if (DEBUG) {
                FMLLog.log.trace("Registry {} remove: {} {}", (Object)this.superType.getSimpleName(), (Object)key, (Object)id);
            }
        }
        return (V)value;
    }

    void block(int id) {
        this.blocked.add(id);
        this.availabilityMap.set(id);
    }

    @Override
    public boolean isLocked() {
        return this.isFrozen;
    }

    public void freeze() {
        this.isFrozen = true;
    }

    public void unfreeze() {
        this.isFrozen = false;
    }

    RegistryEvent.Register<V> getRegisterEvent(nf name) {
        return new RegistryEvent.Register(name, this);
    }

    void dump(nf name) {
        ArrayList ids = Lists.newArrayList();
        this.getKeys().forEach(n2 -> ids.add(this.getID((nf)n2)));
        Collections.sort(ids);
        FMLLog.log.trace("Registry Name : {}", (Object)name);
        ids.forEach(id -> FMLLog.log.trace("  Registry: {} {} {}", id, (Object)this.getKey(this.getValue((int)id)), this.getValue((int)id)));
    }

    public void loadIds(Map<nf, Integer> ids, Map<nf, String> overrides, Map<nf, Integer> missing, Map<nf, Integer[]> remapped, ForgeRegistry<V> old, nf name) {
        nf itemName;
        HashMap ovs = Maps.newHashMap(overrides);
        for (Map.Entry<nf, Integer> entry : ids.entrySet()) {
            Object obj;
            itemName = entry.getKey();
            int newId = entry.getValue();
            int currId = super.getIDRaw(itemName);
            if (currId == -1) {
                FMLLog.log.info("Registry {}: Found a missing id from the world {}", (Object)this.superType.getSimpleName(), (Object)itemName);
                missing.put(itemName, newId);
                continue;
            }
            if (currId != newId) {
                FMLLog.log.debug("Registry {}: Fixed {} id mismatch {}: {} (init) -> {} (map).", (Object)this.superType.getSimpleName(), (Object)name, (Object)itemName, (Object)currId, (Object)newId);
                remapped.put(itemName, new Integer[]{currId, newId});
            }
            Preconditions.checkState(((obj = super.getRaw(itemName)) != null ? 1 : 0) != 0, (Object)"objectKey has an ID but no object. Reflection/ASM hackery? Registry bug?");
            ArrayList lst = Lists.newArrayList((Iterable)old.overrides.get((Object)itemName));
            String primaryName = null;
            if (old.overrides.containsKey((Object)itemName)) {
                if (!overrides.containsKey(itemName)) {
                    lst.add(obj);
                    obj = (IForgeRegistryEntry)old.overrides.get((Object)itemName).iterator().next();
                    primaryName = ((OverrideOwner)old.owners.inverse().get(obj)).owner;
                } else {
                    primaryName = overrides.get(itemName);
                }
            }
            for (IForgeRegistryEntry value : lst) {
                int realId;
                OverrideOwner owner = (OverrideOwner)old.owners.inverse().get((Object)value);
                if (owner == null) {
                    FMLLog.log.warn("Registry {}: Override did not have an associated owner object. Name: {} Value: {}", (Object)this.superType.getSimpleName(), (Object)entry.getKey(), (Object)value);
                    continue;
                }
                if (primaryName.equals(owner.owner) || newId == (realId = this.add(newId, value, owner.owner))) continue;
                FMLLog.log.warn("Registry {}: Object did not get ID it asked for. Name: {} Expected: {} Got: {}", (Object)this.superType.getSimpleName(), (Object)entry.getKey(), (Object)newId, (Object)realId);
            }
            int realId = this.add(newId, obj, primaryName == null ? itemName.b() : primaryName);
            if (realId != newId) {
                FMLLog.log.warn("Registry {}: Object did not get ID it asked for. Name: {} Expected: {} Got: {}", (Object)this.superType.getSimpleName(), (Object)entry.getKey(), (Object)newId, (Object)realId);
            }
            ovs.remove(itemName);
        }
        for (Map.Entry<Object, Integer> entry : ovs.entrySet()) {
            int realId;
            String current;
            itemName = (nf)entry.getKey();
            String owner = (String)((Object)entry.getValue());
            if (owner.equals(current = ((OverrideOwner)this.owners.inverse().get(this.getRaw((nf)itemName))).owner)) continue;
            IForgeRegistryEntry _new = (IForgeRegistryEntry)this.owners.get((Object)new OverrideOwner(owner, itemName));
            if (_new == null) {
                FMLLog.log.warn("Registry {}: Skipping override for {}, Unknown owner {}", (Object)this.superType.getSimpleName(), (Object)itemName, (Object)owner);
                continue;
            }
            FMLLog.log.info("Registry {}: Activating override {} for {}", (Object)this.superType.getSimpleName(), (Object)owner, (Object)itemName);
            int newId = this.getID(itemName);
            if (newId == (realId = this.add(newId, _new, owner))) continue;
            FMLLog.log.warn("Registry {}: Object did not get ID it asked for. Name: {} Expected: {} Got: {}", (Object)this.superType.getSimpleName(), entry.getKey(), (Object)newId, (Object)realId);
        }
    }

    boolean markDummy(nf key, int id) {
        int realId;
        if (this.dummyFactory == null) {
            return false;
        }
        V dummy = this.dummyFactory.createDummy(key);
        if (DEBUG) {
            FMLLog.log.debug("Registry Dummy Add: {} {} -> {}", (Object)key, (Object)id, dummy);
        }
        this.availabilityMap.clear(id);
        if (this.containsKey(key)) {
            IForgeRegistryEntry value = (IForgeRegistryEntry)this.names.remove((Object)key);
            if (value == null) {
                throw new IllegalStateException("ContainsKey for " + key + " was true, but removing by name returned no value.. This should never happen unless hackery!");
            }
            Integer oldid = (Integer)this.ids.inverse().remove((Object)value);
            if (oldid == null) {
                throw new IllegalStateException("Removed a entry that did not have an associated id: " + key + " " + value.toString() + " This should never happen unless hackery!");
            }
            if (oldid != id) {
                FMLLog.log.debug("Registry {}: Dummy ID mismatch {} {} -> {}", (Object)this.superType.getSimpleName(), (Object)key, (Object)oldid, (Object)id);
            }
            if (DEBUG) {
                FMLLog.log.debug("Registry {} remove: {} {}", (Object)this.superType.getSimpleName(), (Object)key, (Object)oldid);
            }
        }
        if ((realId = this.add(id, dummy)) != id) {
            FMLLog.log.warn("Registry {}: Object did not get ID it asked for. Name: {} Expected: {} Got: {}", (Object)this.superType.getSimpleName(), (Object)key, (Object)id, (Object)realId);
        }
        this.dummies.add(key);
        return true;
    }

    public Snapshot makeSnapshot() {
        Snapshot ret = new Snapshot();
        this.ids.forEach((id, value) -> ret.ids.put(this.getKey(value), (Integer)id));
        ret.aliases.putAll(this.aliases);
        ret.blocked.addAll(this.blocked);
        ret.dummied.addAll(this.dummies);
        ret.overrides.putAll(this.getOverrideOwners());
        return ret;
    }

    Map<nf, String> getOverrideOwners() {
        HashMap ret = Maps.newHashMap();
        for (nf key : this.overrides.keySet()) {
            IForgeRegistryEntry obj = (IForgeRegistryEntry)this.names.get((Object)key);
            OverrideOwner owner = (OverrideOwner)this.owners.inverse().get((Object)obj);
            if (owner == null && DEBUG) {
                FMLLog.log.debug("Registry {} {}: Invalid override {} {}", (Object)this.superType.getSimpleName(), (Object)this.stage.getName(), (Object)key, (Object)obj);
            }
            ret.put(key, owner.owner);
        }
        return ret;
    }

    public RegistryEvent.MissingMappings<?> getMissingEvent(nf name, Map<nf, Integer> map) {
        ArrayList lst = Lists.newArrayList();
        ForgeRegistry pool = RegistryManager.ACTIVE.getRegistry(name);
        map.forEach((? super K rl2, ? super V id) -> lst.add(new RegistryEvent.MissingMappings.Mapping(this, pool, (nf)rl2, (int)id)));
        return new RegistryEvent.MissingMappings(name, this, lst);
    }

    void processMissingEvent(nf name, ForgeRegistry<V> pool, List<RegistryEvent.MissingMappings.Mapping<V>> mappings, Map<nf, Integer> missing, Map<nf, Integer[]> remaps, Collection<nf> defaulted, Collection<nf> failed, boolean injectNetworkDummies) {
        FMLLog.log.debug("Processing missing event for {}:", (Object)name);
        int ignored = 0;
        for (RegistryEvent.MissingMappings.Mapping<V> remap : mappings) {
            RegistryEvent.MissingMappings.Action action = remap.getAction();
            if (action == RegistryEvent.MissingMappings.Action.REMAP) {
                int currId = this.getID(remap.getTarget());
                nf newName = pool.getKey(remap.getTarget());
                FMLLog.log.debug("  Remapping {} -> {}.", (Object)remap.key, (Object)newName);
                missing.remove(remap.key);
                int realId = this.add(remap.id, remap.getTarget());
                if (realId != remap.id) {
                    FMLLog.log.warn("Registered object did not get ID it asked for. Name: {} Type: {} Expected: {} Got: {}", (Object)newName, this.getRegistrySuperType(), (Object)remap.id, (Object)realId);
                }
                this.addAlias(remap.key, newName);
                if (currId == realId) continue;
                FMLLog.log.info("  Fixed id mismatch {}: {} (init) -> {} (map).", (Object)newName, (Object)currId, (Object)realId);
                remaps.put(newName, new Integer[]{currId, realId});
                continue;
            }
            if (action == RegistryEvent.MissingMappings.Action.DEFAULT) {
                V m;
                V v = m = this.missing == null ? null : (V)this.missing.createMissing(remap.key, injectNetworkDummies);
                if (m == null) {
                    defaulted.add(remap.key);
                } else {
                    this.add(remap.id, m, remap.key.b());
                }
            } else if (action == RegistryEvent.MissingMappings.Action.IGNORE) {
                FMLLog.log.debug("  Ignoring {}", (Object)remap.key);
                ++ignored;
            } else if (action == RegistryEvent.MissingMappings.Action.FAIL) {
                FMLLog.log.debug("  Failing {}!", (Object)remap.key);
                failed.add(remap.key);
            } else if (action == RegistryEvent.MissingMappings.Action.WARN) {
                FMLLog.log.warn("  {} may cause world breakage!", (Object)remap.key);
            }
            this.block(remap.id);
        }
        if (failed.isEmpty() && ignored > 0) {
            FMLLog.log.debug("There were {} missing mappings that have been ignored", (Object)ignored);
        }
    }

    private static class OverrideOwner {
        final String owner;
        final nf key;

        private OverrideOwner(String owner, nf key) {
            this.owner = owner;
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof OverrideOwner)) {
                return false;
            }
            OverrideOwner oo2 = (OverrideOwner)o;
            return this.owner.equals(oo2.owner) && this.key.equals((Object)oo2.key);
        }

        public int hashCode() {
            return 31 * this.key.hashCode() + this.owner.hashCode();
        }
    }

    public static class Snapshot {
        public final Map<nf, Integer> ids = Maps.newHashMap();
        public final Map<nf, nf> aliases = Maps.newHashMap();
        public final Set<Integer> blocked = Sets.newHashSet();
        public final Set<nf> dummied = Sets.newHashSet();
        public final Map<nf, String> overrides = Maps.newHashMap();

        public fy write() {
            fy data = new fy();
            ge ids = new ge();
            this.ids.entrySet().stream().sorted((o1, o2) -> ((nf)o1.getKey()).a((nf)o2.getKey())).forEach(e2 -> {
                fy tag = new fy();
                tag.a("K", ((nf)e2.getKey()).toString());
                tag.a("V", ((Integer)e2.getValue()).intValue());
                ids.a((gn)tag);
            });
            data.a("ids", (gn)ids);
            ge aliases = new ge();
            this.aliases.entrySet().stream().sorted((o1, o2) -> ((nf)o1.getKey()).a((nf)o2.getKey())).forEach(e2 -> {
                fy tag = new fy();
                tag.a("K", ((nf)e2.getKey()).toString());
                tag.a("V", ((nf)e2.getKey()).toString());
                aliases.a((gn)tag);
            });
            data.a("aliases", (gn)aliases);
            ge overrides = new ge();
            this.overrides.entrySet().stream().sorted((o1, o2) -> ((nf)o1.getKey()).a((nf)o2.getKey())).forEach(e2 -> {
                fy tag = new fy();
                tag.a("K", ((nf)e2.getKey()).toString());
                tag.a("V", (String)e2.getValue());
                overrides.a((gn)tag);
            });
            data.a("overrides", (gn)overrides);
            int[] blocked = this.blocked.stream().mapToInt(x -> x).sorted().toArray();
            data.a("blocked", blocked);
            ge dummied = new ge();
            this.dummied.stream().sorted().forEach(e2 -> dummied.a((gn)new gm(e2.toString())));
            data.a("dummied", (gn)dummied);
            return data;
        }

        public static Snapshot read(fy nbt) {
            int[] blocked;
            Snapshot ret = new Snapshot();
            if (nbt == null) {
                return ret;
            }
            ge list = nbt.c("ids", 10);
            list.forEach(e2 -> {
                fy comp = (fy)e2;
                ret.ids.put(new nf(comp.l("K")), comp.h("V"));
            });
            list = nbt.c("aliases", 10);
            list.forEach(e2 -> {
                fy comp = (fy)e2;
                String v = comp.l("V");
                if (v.indexOf(58) == -1) {
                    ret.overrides.put(new nf(comp.l("K")), v);
                } else {
                    nf aliasv = new nf(v);
                    nf aliask = new nf(comp.l("K"));
                    if (aliasv.equals((Object)aliask)) {
                        FMLLog.log.warn("Found unrecoverable 4894 bugged alias/override: {} -> {}, skipping.", (Object)aliask, (Object)aliasv);
                    } else {
                        ret.aliases.put(aliask, aliasv);
                    }
                }
            });
            list = nbt.c("overrides", 10);
            list.forEach(e2 -> {
                fy comp = (fy)e2;
                ret.overrides.put(new nf(comp.l("K")), comp.l("V"));
            });
            for (int i2 : blocked = nbt.n("blocked")) {
                ret.blocked.add(i2);
            }
            list = nbt.c("dummied", 10);
            list.forEach(e2 -> ret.dummied.add(new nf(((fy)e2).l("K"))));
            list = nbt.c("dummied", 8);
            list.forEach(e2 -> ret.dummied.add(new nf(((gm)e2).c_())));
            return ret;
        }
    }
}

