/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.tool.IConfigurableTool;
import blusunrize.immersiveengineering.api.tool.ITool;
import blusunrize.immersiveengineering.client.ClientProxy;
import blusunrize.immersiveengineering.client.models.ModelEarmuffs;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemEarmuffs
extends ItemArmor
implements ISpecialArmor,
IConfigurableTool,
ITool,
IEItemInterfaces.IColouredItem {
    @SideOnly(value=Side.CLIENT)
    ModelBiped armorModel;
    public static LinkedHashSet<String> affectedSoundCategories = Sets.newLinkedHashSet();

    public ItemEarmuffs() {
        super(ItemArmor.ArmorMaterial.LEATHER, 0, EntityEquipmentSlot.HEAD);
        String name = "earmuffs";
        this.func_77655_b("immersiveengineering." + name);
        this.func_77637_a(ImmersiveEngineering.creativeTab);
        IEContent.registeredIEItems.add((Item)this);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        if (type == "overlay") {
            return "immersiveengineering:textures/models/earmuffs_overlay.png";
        }
        return "immersiveengineering:textures/models/earmuffs.png";
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        ModelEarmuffs model = ModelEarmuffs.getModel();
        return model;
    }

    @Override
    public boolean hasCustomItemColours() {
        return true;
    }

    @Override
    public int getColourForIEItem(ItemStack stack, int renderPass) {
        if (renderPass == 1) {
            return 0xFFFFFF;
        }
        if (!ItemNBTHelper.hasKey(stack, "IE:EarmuffColour")) {
            return 4746388;
        }
        return ItemNBTHelper.getInt(stack, "IE:EarmuffColour");
    }

    public boolean func_82816_b_(ItemStack stack) {
        return true;
    }

    public int func_82814_b(ItemStack stack) {
        if (!ItemNBTHelper.hasKey(stack, "IE:EarmuffColour")) {
            return 4746388;
        }
        return ItemNBTHelper.getInt(stack, "IE:EarmuffColour");
    }

    public void func_82815_c(ItemStack stack) {
        if (ItemNBTHelper.hasKey(stack, "IE:EarmuffColour")) {
            ItemNBTHelper.remove(stack, "IE:EarmuffColour");
        }
    }

    public void func_82813_b(ItemStack stack, int color) {
        ItemNBTHelper.setInt(stack, "IE:EarmuffColour", color);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        String hexCol = Integer.toHexString(this.getColourForIEItem(stack, 0));
        list.add(I18n.func_135052_a((String)"desc.immersiveengineering.info.colour", (Object[])new Object[]{"<hexcol=" + hexCol + ":#" + hexCol + ">"}));
    }

    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer(ItemStack stack) {
        return ClientProxy.itemFont;
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        return HashMultimap.create();
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
    }

    public static float getVolumeMod(ItemStack stack) {
        if (!ItemNBTHelper.hasKey(stack, "IE:Earmuffs:Volume")) {
            return 0.1f;
        }
        return ItemNBTHelper.getFloat(stack, "IE:Earmuffs:Volume");
    }

    @Override
    public boolean canConfigure(ItemStack stack) {
        return true;
    }

    @Override
    public IConfigurableTool.ToolConfig.ToolConfigBoolean[] getBooleanOptions(ItemStack stack) {
        IConfigurableTool.ToolConfig.ToolConfigBoolean[] array = new IConfigurableTool.ToolConfig.ToolConfigBoolean[affectedSoundCategories.size()];
        int i = -1;
        for (String cat : affectedSoundCategories) {
            int n = 60 + ++i / 4 * 55;
            array[i] = new IConfigurableTool.ToolConfig.ToolConfigBoolean(cat, n, 32 + 10 * (i % 4), !ItemNBTHelper.getBoolean(stack, "IE:Earmuffs:Cat_" + cat));
        }
        return array;
    }

    @Override
    public IConfigurableTool.ToolConfig.ToolConfigFloat[] getFloatOptions(ItemStack stack) {
        return new IConfigurableTool.ToolConfig.ToolConfigFloat[]{new IConfigurableTool.ToolConfig.ToolConfigFloat("reductionValue", 60, 20, 1.0f - ItemEarmuffs.getVolumeMod(stack))};
    }

    @Override
    public String fomatConfigName(ItemStack stack, IConfigurableTool.ToolConfig config) {
        if (config instanceof IConfigurableTool.ToolConfig.ToolConfigFloat) {
            return I18n.func_135052_a((String)"gui.immersiveengineering.config.earmuffs.noisegate", (Object[])new Object[0]);
        }
        return I18n.func_135052_a((String)("gui.immersiveengineering.config.earmuffs.soundcategory." + config.name), (Object[])new Object[0]);
    }

    @Override
    public String fomatConfigDescription(ItemStack stack, IConfigurableTool.ToolConfig config) {
        return null;
    }

    @Override
    public void applyConfigOption(ItemStack stack, String key, Object value) {
        if (value instanceof Boolean) {
            ItemNBTHelper.setBoolean(stack, "IE:Earmuffs:Cat_" + key, (Boolean)value == false);
        } else if (value instanceof Float) {
            ItemNBTHelper.setFloat(stack, "IE:Earmuffs:Volume", 1.0f - ((Float)value).floatValue());
        }
    }

    @Override
    public boolean isTool(ItemStack item) {
        return true;
    }

    static {
        affectedSoundCategories.add("ambient");
        affectedSoundCategories.add("weather");
        affectedSoundCategories.add("record");
        affectedSoundCategories.add("block");
        affectedSoundCategories.add("neutral");
        affectedSoundCategories.add("hostile");
        affectedSoundCategories.add("player");
    }
}

