/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei.orechid;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.client.integration.jei.JEIBotaniaPlugin;

public class OrechidRecipeWrapper
implements IRecipeWrapper,
Comparable<OrechidRecipeWrapper> {
    private final int weight;
    private final List<List<ItemStack>> outputStacks;

    protected ItemStack getInputStack() {
        return new ItemStack(Blocks.field_150348_b, 64);
    }

    public OrechidRecipeWrapper(Map.Entry<String, Integer> entry) {
        this.weight = entry.getValue();
        int amount = Math.max(1, Math.round((float)this.weight * 64.0f / this.getTotalOreWeight()));
        List<ItemStack> stackList = OreDictionary.getOres((String)entry.getKey()).stream().filter(s -> s.func_77973_b() instanceof ItemBlock).map(ItemStack::func_77946_l).collect(Collectors.toList());
        stackList.forEach(s -> s.func_190920_e(amount));
        this.outputStacks = Collections.singletonList(stackList);
    }

    public Map<String, Integer> getOreWeights() {
        return BotaniaAPI.oreWeights;
    }

    private float getTotalOreWeight() {
        return this.getOreWeights().entrySet().stream().filter(e -> JEIBotaniaPlugin.doesOreExist((String)e.getKey())).map(Map.Entry::getValue).reduce(Integer::sum).orElse(this.weight * 64 * 64).intValue();
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInput(ItemStack.class, (Object)this.getInputStack());
        ingredients.setOutputLists(ItemStack.class, this.outputStacks);
    }

    @Override
    public int compareTo(OrechidRecipeWrapper o) {
        return Integer.compare(o.weight, this.weight);
    }
}

