/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei;

import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.IRecipesGui;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.recipe.RecipeBrew;
import vazkii.botania.api.recipe.RecipeElvenTrade;
import vazkii.botania.api.recipe.RecipeManaInfusion;
import vazkii.botania.api.recipe.RecipePetals;
import vazkii.botania.api.recipe.RecipePureDaisy;
import vazkii.botania.api.recipe.RecipeRuneAltar;
import vazkii.botania.api.state.enums.AltarVariant;
import vazkii.botania.api.state.enums.PoolVariant;
import vazkii.botania.client.core.handler.CorporeaInputHandler;
import vazkii.botania.client.gui.crafting.ContainerCraftingHalo;
import vazkii.botania.client.integration.jei.brewery.BreweryRecipeCategory;
import vazkii.botania.client.integration.jei.brewery.BreweryRecipeWrapper;
import vazkii.botania.client.integration.jei.crafting.SpecialFloatingFlowerWrapper;
import vazkii.botania.client.integration.jei.elventrade.ElvenTradeRecipeCategory;
import vazkii.botania.client.integration.jei.elventrade.ElvenTradeRecipeWrapper;
import vazkii.botania.client.integration.jei.manapool.ManaPoolRecipeCategory;
import vazkii.botania.client.integration.jei.manapool.ManaPoolRecipeWrapper;
import vazkii.botania.client.integration.jei.orechid.OrechidIgnemRecipeCategory;
import vazkii.botania.client.integration.jei.orechid.OrechidIgnemRecipeWrapper;
import vazkii.botania.client.integration.jei.orechid.OrechidRecipeCategory;
import vazkii.botania.client.integration.jei.orechid.OrechidRecipeWrapper;
import vazkii.botania.client.integration.jei.petalapothecary.PetalApothecaryRecipeCategory;
import vazkii.botania.client.integration.jei.petalapothecary.PetalApothecaryRecipeWrapper;
import vazkii.botania.client.integration.jei.puredaisy.PureDaisyRecipeCategory;
import vazkii.botania.client.integration.jei.puredaisy.PureDaisyRecipeWrapper;
import vazkii.botania.client.integration.jei.runicaltar.RunicAltarRecipeCategory;
import vazkii.botania.client.integration.jei.runicaltar.RunicAltarRecipeWrapper;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.crafting.recipe.SpecialFloatingFlowerRecipe;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.block.ItemBlockSpecialFlower;
import vazkii.botania.common.item.brew.ItemBrewBase;

@JEIPlugin
public class JEIBotaniaPlugin
implements IModPlugin {
    public void registerItemSubtypes(@Nonnull ISubtypeRegistry subtypeRegistry) {
        subtypeRegistry.registerSubtypeInterpreter(Item.func_150898_a((Block)ModBlocks.specialFlower), ItemBlockSpecialFlower::getType);
        subtypeRegistry.registerSubtypeInterpreter(Item.func_150898_a((Block)ModBlocks.floatingSpecialFlower), ItemBlockSpecialFlower::getType);
        subtypeRegistry.registerSubtypeInterpreter(ModItems.brewVial, ItemBrewBase::getSubtype);
        subtypeRegistry.registerSubtypeInterpreter(ModItems.brewFlask, ItemBrewBase::getSubtype);
        subtypeRegistry.registerSubtypeInterpreter(ModItems.incenseStick, ItemBrewBase::getSubtype);
        subtypeRegistry.registerSubtypeInterpreter(ModItems.bloodPendant, ItemBrewBase::getSubtype);
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new BreweryRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new PureDaisyRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new RunicAltarRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new PetalApothecaryRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new ElvenTradeRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new ManaPoolRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new OrechidRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new OrechidIgnemRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public static boolean doesOreExist(String key) {
        return OreDictionary.doesOreNameExist((String)key) && OreDictionary.getOres((String)key).stream().anyMatch(s -> s.func_77973_b() instanceof ItemBlock);
    }

    public void register(@Nonnull IModRegistry registry) {
        registry.handleRecipes(RecipeBrew.class, BreweryRecipeWrapper::new, "botania.brewery");
        registry.handleRecipes(RecipePureDaisy.class, PureDaisyRecipeWrapper::new, "botania.pureDaisy");
        registry.handleRecipes(RecipeRuneAltar.class, RunicAltarRecipeWrapper::new, "botania.runicAltar");
        registry.handleRecipes(RecipePetals.class, PetalApothecaryRecipeWrapper::new, "botania.petals");
        registry.handleRecipes(RecipeElvenTrade.class, ElvenTradeRecipeWrapper::new, "botania.elvenTrade");
        registry.handleRecipes(RecipeManaInfusion.class, ManaPoolRecipeWrapper::new, "botania.manaPool");
        registry.handleRecipes(SpecialFloatingFlowerRecipe.class, SpecialFloatingFlowerWrapper::new, "minecraft.crafting");
        registry.addRecipes(BotaniaAPI.brewRecipes, "botania.brewery");
        registry.addRecipes(BotaniaAPI.pureDaisyRecipes, "botania.pureDaisy");
        registry.addRecipes(BotaniaAPI.petalRecipes, "botania.petals");
        registry.addRecipes(BotaniaAPI.elvenTradeRecipes, "botania.elvenTrade");
        registry.addRecipes(BotaniaAPI.runeAltarRecipes, "botania.runicAltar");
        registry.addRecipes(BotaniaAPI.manaInfusionRecipes, "botania.manaPool");
        registry.addRecipes((Collection)BotaniaAPI.oreWeights.entrySet().stream().filter(e -> JEIBotaniaPlugin.doesOreExist((String)e.getKey())).map(OrechidRecipeWrapper::new).sorted().collect(Collectors.toList()), "botania.orechid");
        registry.addRecipes((Collection)BotaniaAPI.oreWeightsNether.entrySet().stream().filter(e -> JEIBotaniaPlugin.doesOreExist((String)e.getKey())).map(OrechidIgnemRecipeWrapper::new).sorted().collect(Collectors.toList()), "botania.orechid_ignem");
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.brewery), new String[]{"botania.brewery"});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.alfPortal), new String[]{"botania.elvenTrade"});
        for (PoolVariant poolVariant : PoolVariant.values()) {
            registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.pool, 1, poolVariant.ordinal()), new String[]{"botania.manaPool"});
        }
        for (Enum enum_ : AltarVariant.values()) {
            if (enum_ == AltarVariant.MOSSY) continue;
            registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.altar, 1, enum_.ordinal()), new String[]{"botania.petals"});
        }
        registry.addRecipeCatalyst((Object)ItemBlockSpecialFlower.ofType("orechid"), new String[]{"botania.orechid"});
        registry.addRecipeCatalyst((Object)ItemBlockSpecialFlower.ofType(new ItemStack(ModBlocks.floatingSpecialFlower), "orechid"), new String[]{"botania.orechid"});
        registry.addRecipeCatalyst((Object)ItemBlockSpecialFlower.ofType("orechidIgnem"), new String[]{"botania.orechid_ignem"});
        registry.addRecipeCatalyst((Object)ItemBlockSpecialFlower.ofType(new ItemStack(ModBlocks.floatingSpecialFlower), "orechidIgnem"), new String[]{"botania.orechid_ignem"});
        registry.addRecipeCatalyst((Object)ItemBlockSpecialFlower.ofType("puredaisy"), new String[]{"botania.pureDaisy"});
        registry.addRecipeCatalyst((Object)ItemBlockSpecialFlower.ofType(new ItemStack(ModBlocks.floatingSpecialFlower), "puredaisy"), new String[]{"botania.pureDaisy"});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.runeAltar), new String[]{"botania.runicAltar"});
        registry.addRecipeCatalyst((Object)new ItemStack(ModItems.autocraftingHalo), new String[]{"minecraft.crafting"});
        registry.addRecipeCatalyst((Object)new ItemStack(ModItems.craftingHalo), new String[]{"minecraft.crafting"});
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(ContainerCraftingHalo.class, "minecraft.crafting", 1, 9, 10, 36);
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        CorporeaInputHandler.jeiPanelSupplier = () -> {
            Object o = jeiRuntime.getIngredientListOverlay().getIngredientUnderMouse();
            if (o == null && Minecraft.func_71410_x().field_71462_r == jeiRuntime.getRecipesGui()) {
                o = jeiRuntime.getRecipesGui().getIngredientUnderMouse();
            }
            if (o instanceof ItemStack) {
                return (ItemStack)o;
            }
            return ItemStack.field_190927_a;
        };
        CorporeaInputHandler.supportedGuiFilter = gui -> gui instanceof GuiContainer || gui instanceof IRecipesGui;
    }
}

