/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.util.helper;

import WayofTime.bloodmagic.BloodMagic;
import WayofTime.bloodmagic.ritual.EnumRuneType;
import WayofTime.bloodmagic.ritual.IRitualStone;
import WayofTime.bloodmagic.ritual.Ritual;
import WayofTime.bloodmagic.ritual.RitualComponent;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;

public class RitualHelper {
    @CapabilityInject(value=IRitualStone.Tile.class)
    static Capability<IRitualStone.Tile> RUNE_CAPABILITY = null;

    public static boolean canCrystalActivate(Ritual ritual, int crystalLevel) {
        return ritual.getCrystalLevel() <= crystalLevel && BloodMagic.RITUAL_MANAGER.enabled(BloodMagic.RITUAL_MANAGER.getId(ritual), false);
    }

    public static String getValidRitual(World world, BlockPos pos) {
        for (Ritual ritual : BloodMagic.RITUAL_MANAGER.getRituals()) {
            for (EnumFacing direction : EnumFacing.field_176754_o) {
                if (!RitualHelper.checkValidRitual(world, pos, ritual, direction)) continue;
                return BloodMagic.RITUAL_MANAGER.getId(ritual);
            }
        }
        return "";
    }

    public static EnumFacing getDirectionOfRitual(World world, BlockPos pos, Ritual ritual) {
        for (EnumFacing direction : EnumFacing.field_176754_o) {
            if (!RitualHelper.checkValidRitual(world, pos, ritual, direction)) continue;
            return direction;
        }
        return null;
    }

    public static boolean checkValidRitual(World world, BlockPos pos, Ritual ritual, EnumFacing direction) {
        if (ritual == null) {
            return false;
        }
        ArrayList components = Lists.newArrayList();
        ritual.gatherComponents(components::add);
        for (RitualComponent component : components) {
            BlockPos newPos = pos.func_177971_a((Vec3i)component.getOffset(direction));
            if (RitualHelper.isRuneType(world, newPos, component.getRuneType())) continue;
            return false;
        }
        return true;
    }

    public static boolean isRuneType(World world, BlockPos pos, EnumRuneType type) {
        if (world == null) {
            return false;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        TileEntity tile = world.func_175625_s(pos);
        if (block instanceof IRitualStone) {
            return ((IRitualStone)block).isRuneType(world, pos, type);
        }
        if (tile instanceof IRitualStone.Tile) {
            return ((IRitualStone.Tile)tile).isRuneType(type);
        }
        if (tile != null && tile.hasCapability(RUNE_CAPABILITY, null)) {
            return ((IRitualStone.Tile)tile.getCapability(RUNE_CAPABILITY, null)).isRuneType(type);
        }
        return false;
    }

    public static boolean isRune(World world, BlockPos pos) {
        if (world == null) {
            return false;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        TileEntity tile = world.func_175625_s(pos);
        if (block instanceof IRitualStone) {
            return true;
        }
        if (tile instanceof IRitualStone.Tile) {
            return true;
        }
        return tile != null && tile.hasCapability(RUNE_CAPABILITY, null);
    }

    public static void setRuneType(World world, BlockPos pos, EnumRuneType type) {
        if (world == null) {
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        TileEntity tile = world.func_175625_s(pos);
        if (state.func_177230_c() instanceof IRitualStone) {
            ((IRitualStone)state.func_177230_c()).setRuneType(world, pos, type);
        } else if (tile instanceof IRitualStone.Tile) {
            ((IRitualStone.Tile)tile).setRuneType(type);
        } else if (tile != null && tile.hasCapability(RUNE_CAPABILITY, null)) {
            ((IRitualStone.Tile)tile.getCapability(RUNE_CAPABILITY, null)).setRuneType(type);
            world.func_184138_a(pos, state, state, 3);
        }
    }
}

