/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.tile;

import WayofTime.bloodmagic.alchemyArray.AlchemyArrayEffect;
import WayofTime.bloodmagic.alchemyArray.AlchemyArrayEffectCraftingNew;
import WayofTime.bloodmagic.api.impl.BloodMagicAPI;
import WayofTime.bloodmagic.api.impl.recipe.RecipeAlchemyArray;
import WayofTime.bloodmagic.core.registry.AlchemyArrayRecipeRegistry;
import WayofTime.bloodmagic.iface.IAlchemyArray;
import WayofTime.bloodmagic.tile.TileInventory;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileAlchemyArray
extends TileInventory
implements ITickable,
IAlchemyArray {
    public boolean isActive = false;
    public int activeCounter = 0;
    public EnumFacing rotation = EnumFacing.field_176754_o[0];
    private String key = "empty";
    public AlchemyArrayEffect arrayEffect;
    private boolean doDropIngredients = true;

    public TileAlchemyArray() {
        super(2, "alchemyArray");
    }

    public void onEntityCollidedWithBlock(IBlockState state, Entity entity) {
        if (this.arrayEffect != null) {
            this.arrayEffect.onEntityCollidedWithBlock(this, this.func_145831_w(), this.field_174879_c, state, entity);
        }
    }

    @Override
    public void deserialize(NBTTagCompound tagCompound) {
        super.deserialize(tagCompound);
        this.isActive = tagCompound.func_74767_n("isActive");
        this.activeCounter = tagCompound.func_74762_e("activeCounter");
        this.key = tagCompound.func_74779_i("key");
        this.doDropIngredients = !tagCompound.func_74764_b("doDropIngredients") ? true : tagCompound.func_74767_n("doDropIngredients");
        this.rotation = EnumFacing.field_176754_o[tagCompound.func_74762_e("direction")];
        NBTTagCompound arrayTag = tagCompound.func_74775_l("arrayTag");
        this.arrayEffect = AlchemyArrayRecipeRegistry.getAlchemyArrayEffect(this.key);
        if (this.arrayEffect != null) {
            this.arrayEffect.readFromNBT(arrayTag);
        }
    }

    @Override
    public NBTTagCompound serialize(NBTTagCompound tagCompound) {
        super.serialize(tagCompound);
        tagCompound.func_74757_a("isActive", this.isActive);
        tagCompound.func_74768_a("activeCounter", this.activeCounter);
        tagCompound.func_74778_a("key", "".equals(this.key) ? "empty" : this.key);
        tagCompound.func_74757_a("doDropIngredients", this.doDropIngredients);
        tagCompound.func_74768_a("direction", this.rotation.func_176736_b());
        NBTTagCompound arrayTag = new NBTTagCompound();
        if (this.arrayEffect != null) {
            this.arrayEffect.writeToNBT(arrayTag);
        }
        tagCompound.func_74782_a("arrayTag", (NBTBase)arrayTag);
        return tagCompound;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    public void setItemDrop(boolean dropItems) {
        this.doDropIngredients = dropItems;
    }

    public void func_73660_a() {
        if (this.isActive && this.attemptCraft()) {
            ++this.activeCounter;
        } else {
            this.isActive = false;
            this.doDropIngredients = true;
            this.activeCounter = 0;
            this.arrayEffect = null;
            this.key = "empty";
        }
    }

    @Override
    public void dropItems() {
        if (this.arrayEffect == null || this.doDropIngredients) {
            super.dropItems();
        }
    }

    public boolean attemptCraft() {
        AlchemyArrayEffect effect = AlchemyArrayRecipeRegistry.getAlchemyArrayEffect(this.func_70301_a(0), this.func_70301_a(1));
        if (effect != null) {
            if (this.arrayEffect == null) {
                this.arrayEffect = effect;
                this.key = effect.getKey();
            } else {
                String effectKey = effect.getKey();
                if (!effectKey.equals(this.key)) {
                    this.arrayEffect = effect;
                    this.key = effect.getKey();
                }
            }
        } else {
            RecipeAlchemyArray recipe = BloodMagicAPI.INSTANCE.getRecipeRegistrar().getAlchemyArray(this.func_70301_a(0), this.func_70301_a(1));
            if (recipe == null) {
                return false;
            }
            AlchemyArrayEffectCraftingNew newEffect = new AlchemyArrayEffectCraftingNew(recipe);
            if (this.arrayEffect == null) {
                this.arrayEffect = newEffect;
                this.key = newEffect.key;
            } else if (!newEffect.key.equals(this.key)) {
                this.arrayEffect = newEffect;
                this.key = newEffect.key;
            }
        }
        if (this.arrayEffect != null) {
            this.isActive = true;
            if (this.arrayEffect.update(this, this.activeCounter)) {
                this.func_70298_a(0, 1);
                this.func_70298_a(1, 1);
                this.func_145831_w().func_175698_g(this.func_174877_v());
            }
            return true;
        }
        return false;
    }

    @Override
    public EnumFacing getRotation() {
        return this.rotation;
    }

    public void setRotation(EnumFacing rotation) {
        this.rotation = rotation;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return Block.field_185505_j.func_186670_a(this.func_174877_v());
    }
}

