/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual.types;

import WayofTime.bloodmagic.core.RegistrarBloodMagic;
import WayofTime.bloodmagic.demonAura.WorldDemonWillHandler;
import WayofTime.bloodmagic.ritual.AreaDescriptor;
import WayofTime.bloodmagic.ritual.EnumRuneType;
import WayofTime.bloodmagic.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.ritual.Ritual;
import WayofTime.bloodmagic.ritual.RitualComponent;
import WayofTime.bloodmagic.ritual.RitualRegister;
import WayofTime.bloodmagic.soul.DemonWillHolder;
import WayofTime.bloodmagic.soul.EnumDemonWillType;
import WayofTime.bloodmagic.util.DamageSourceBloodMagic;
import WayofTime.bloodmagic.util.Utils;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

@RitualRegister(value="lava")
public class RitualLava
extends Ritual {
    public static final String LAVA_RANGE = "lavaRange";
    public static final String FIRE_FUSE_RANGE = "fireFuse";
    public static final String FIRE_RESIST_RANGE = "fireResist";
    public static final String FIRE_DAMAGE_RANGE = "fireDamage";
    public static final String LAVA_TANK_RANGE = "lavaTank";
    public static final double vengefulWillDrain = 1.0;
    public static final double steadfastWillDrain = 0.5;
    public static final double corrosiveWillDrain = 0.2;
    public static final int corrosiveRefreshTime = 20;
    public int timer = 0;

    public RitualLava() {
        super("ritualLava", 0, 10000, "ritual.bloodmagic.lavaRitual");
        this.addBlockRange(LAVA_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 1, 0), 1));
        this.addBlockRange(FIRE_FUSE_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-2, -2, -2), 5));
        this.addBlockRange(FIRE_RESIST_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 0, 0), 1));
        this.addBlockRange(FIRE_DAMAGE_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 0, 0), 1));
        this.addBlockRange(LAVA_TANK_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 1, 0), 1));
        this.setMaximumVolumeAndDistanceOfRange(LAVA_RANGE, 9, 3, 3);
        this.setMaximumVolumeAndDistanceOfRange(FIRE_FUSE_RANGE, 0, 10, 10);
        this.setMaximumVolumeAndDistanceOfRange(FIRE_RESIST_RANGE, 0, 10, 10);
        this.setMaximumVolumeAndDistanceOfRange(FIRE_DAMAGE_RANGE, 0, 10, 10);
        this.setMaximumVolumeAndDistanceOfRange(LAVA_TANK_RANGE, 1, 10, 10);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        List entities;
        ++this.timer;
        World world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        int lpDrain = 0;
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        BlockPos pos = masterRitualStone.getBlockPos();
        List<EnumDemonWillType> willConfig = masterRitualStone.getActiveWillConfig();
        double rawWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.DEFAULT, willConfig);
        double rawDrained = 0.0;
        DemonWillHolder holder = WorldDemonWillHandler.getWillHolder(world, pos);
        AreaDescriptor lavaRange = this.getBlockRange(LAVA_RANGE);
        int maxLavaVolume = this.getMaxVolumeForRange(LAVA_RANGE, willConfig, holder);
        if (!lavaRange.isWithinRange(this.getMaxVerticalRadiusForRange(LAVA_RANGE, willConfig, holder), this.getMaxHorizontalRadiusForRange(LAVA_RANGE, willConfig, holder)) || maxLavaVolume != 0 && lavaRange.getVolume() > maxLavaVolume) {
            return;
        }
        for (BlockPos newPos : lavaRange.getContainedPositions(pos)) {
            IBlockState state = world.func_180495_p(newPos);
            if (!world.func_175623_d(newPos) && !Utils.isFlowingLiquid(world, newPos, state)) continue;
            int lpCost = this.getLPCostForRawWill(rawWill);
            if (currentEssence < lpCost) break;
            world.func_175656_a(newPos, Blocks.field_150356_k.func_176223_P());
            currentEssence -= lpCost;
            lpDrain += lpCost;
            if (!(rawWill > 0.0)) continue;
            double drain = this.getWillCostForRawWill(rawWill);
            rawWill -= drain;
            rawDrained += drain;
        }
        if (rawWill > 0.0) {
            AreaDescriptor chestRange = this.getBlockRange(LAVA_TANK_RANGE);
            TileEntity tile = world.func_175625_s(chestRange.getContainedPositions(pos).get(0));
            double drain = this.getWillCostForRawWill(rawWill);
            int lpCost = this.getLPCostForRawWill(rawWill);
            if (rawWill >= drain && currentEssence >= lpCost && tile != null && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
                IFluidHandler handler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
                double filled = handler.fill(new FluidStack(FluidRegistry.LAVA, 1000), true);
                double ratio = filled / 1000.0;
                rawWill -= drain * ratio;
                rawDrained += drain * ratio;
                currentEssence = (int)((double)currentEssence - Math.ceil((double)lpCost * ratio));
                lpDrain = (int)((double)lpDrain + Math.ceil((double)lpCost * ratio));
            }
        }
        double vengefulWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.VENGEFUL, willConfig);
        double steadfastWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.STEADFAST, willConfig);
        double corrosiveWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.CORROSIVE, willConfig);
        if (vengefulWill >= 1.0) {
            double vengefulDrained = 0.0;
            AreaDescriptor fuseRange = this.getBlockRange(FIRE_FUSE_RANGE);
            AxisAlignedBB fuseArea = fuseRange.getAABB(pos);
            List entities2 = world.func_72872_a(EntityLivingBase.class, fuseArea);
            for (EntityLivingBase entity : entities2) {
                if (vengefulWill < 1.0) break;
                if (entity instanceof EntityPlayer || entity.func_70644_a(RegistrarBloodMagic.FIRE_FUSE)) continue;
                entity.func_70690_d(new PotionEffect(RegistrarBloodMagic.FIRE_FUSE, 100, 0));
                vengefulDrained += 1.0;
                vengefulWill -= 1.0;
            }
            if (vengefulDrained > 0.0) {
                WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.VENGEFUL, vengefulDrained, true);
            }
        }
        if (steadfastWill >= 0.5) {
            double steadfastDrained = 0.0;
            AreaDescriptor resistRange = this.getBlockRange(FIRE_RESIST_RANGE);
            int duration = this.getFireResistForWill(steadfastWill);
            AxisAlignedBB resistArea = resistRange.getAABB(pos);
            entities = world.func_72872_a(EntityPlayer.class, resistArea);
            for (EntityPlayer entity : entities) {
                if (steadfastWill < 0.5) break;
                if (entity.func_70644_a(MobEffects.field_76426_n) && entity.func_70660_b(MobEffects.field_76426_n).func_76459_b() >= 2) continue;
                entity.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 100, 0));
                steadfastDrained += 0.5;
                steadfastWill -= 0.5;
            }
            if (steadfastDrained > 0.0) {
                WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.STEADFAST, steadfastDrained, true);
            }
        }
        if (this.timer % 20 == 0 && corrosiveWill >= 0.2) {
            double corrosiveDrained = 0.0;
            AreaDescriptor resistRange = this.getBlockRange(FIRE_DAMAGE_RANGE);
            float damage = this.getCorrosiveDamageForWill(corrosiveWill);
            AxisAlignedBB damageArea = resistRange.getAABB(pos);
            entities = world.func_72872_a(EntityLivingBase.class, damageArea);
            for (EntityPlayer entity : entities) {
                if (corrosiveWill < 0.2) break;
                if (entity.field_70128_L || entity.field_70737_aN > 0 || !Utils.isImmuneToFireDamage((EntityLivingBase)entity) || !entity.func_70097_a((DamageSource)DamageSourceBloodMagic.INSTANCE, damage)) continue;
                corrosiveDrained += 0.2;
                corrosiveWill -= 0.2;
            }
            if (corrosiveDrained > 0.0) {
                WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.CORROSIVE, corrosiveDrained, true);
            }
        }
        if (rawDrained > 0.0) {
            WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.DEFAULT, rawDrained, true);
        }
        masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(lpDrain));
    }

    @Override
    public int getRefreshTime() {
        return 1;
    }

    @Override
    public int getRefreshCost() {
        return 500;
    }

    @Override
    public ITextComponent[] provideInformationOfRitualToPlayer(EntityPlayer player) {
        return new ITextComponent[]{new TextComponentTranslation(this.getUnlocalizedName() + ".info", new Object[0]), new TextComponentTranslation(this.getUnlocalizedName() + ".default.info", new Object[0]), new TextComponentTranslation(this.getUnlocalizedName() + ".corrosive.info", new Object[0]), new TextComponentTranslation(this.getUnlocalizedName() + ".steadfast.info", new Object[0]), new TextComponentTranslation(this.getUnlocalizedName() + ".destructive.info", new Object[0]), new TextComponentTranslation(this.getUnlocalizedName() + ".vengeful.info", new Object[0])};
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addParallelRunes(components, 1, 0, EnumRuneType.FIRE);
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualLava();
    }

    @Override
    public int getMaxVolumeForRange(String range, List<EnumDemonWillType> activeTypes, DemonWillHolder holder) {
        double destructiveWill;
        if (LAVA_RANGE.equals(range) && activeTypes.contains(EnumDemonWillType.DESTRUCTIVE) && (destructiveWill = holder.getWill(EnumDemonWillType.DESTRUCTIVE)) > 0.0) {
            return 9 + (int)Math.pow(destructiveWill / 10.0, 1.5);
        }
        return (Integer)this.volumeRangeMap.get(range);
    }

    @Override
    public int getMaxVerticalRadiusForRange(String range, List<EnumDemonWillType> activeTypes, DemonWillHolder holder) {
        double destructiveWill;
        if (LAVA_RANGE.equals(range) && activeTypes.contains(EnumDemonWillType.DESTRUCTIVE) && (destructiveWill = holder.getWill(EnumDemonWillType.DESTRUCTIVE)) > 0.0) {
            return (int)(3.0 + destructiveWill / 10.0);
        }
        return (Integer)this.verticalRangeMap.get(range);
    }

    @Override
    public int getMaxHorizontalRadiusForRange(String range, List<EnumDemonWillType> activeTypes, DemonWillHolder holder) {
        double destructiveWill;
        if (LAVA_RANGE.equals(range) && activeTypes.contains(EnumDemonWillType.DESTRUCTIVE) && (destructiveWill = holder.getWill(EnumDemonWillType.DESTRUCTIVE)) > 0.0) {
            return (int)(3.0 + destructiveWill / 10.0);
        }
        return (Integer)this.horizontalRangeMap.get(range);
    }

    public int getFireResistForWill(double steadfastWill) {
        return (int)(200.0 + steadfastWill * 3.0);
    }

    public float getCorrosiveDamageForWill(double corrosiveWill) {
        return (float)(1.0 + corrosiveWill * 0.05);
    }

    public int getLPCostForRawWill(double raw) {
        return Math.max((int)(500.0 - raw), 0);
    }

    public double getWillCostForRawWill(double raw) {
        return Math.min(1.0, raw / 500.0);
    }
}

