/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.livingArmour.upgrade;

import WayofTime.bloodmagic.livingArmour.ILivingArmour;
import WayofTime.bloodmagic.livingArmour.LivingArmourUpgrade;
import WayofTime.bloodmagic.util.helper.TextHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class LivingArmourUpgradeGrimReaperSprint
extends LivingArmourUpgrade {
    public static final int[] costs = new int[]{20, 50, 130, 270, 450, 580, 700, 800, 900, 1000};
    public static final int[] rebirthDelay = new int[]{72000, 60000, 54000, 48000, 36000, 30000, 18000, 12000, 6000, 1200};
    public static final int[] strengthDuration = new int[]{0, 0, 100, 100, 200, 200, 200, 300, 300, 400};
    public static final int[] strengthValue = new int[]{0, 0, 0, 0, 0, 1, 1, 2, 2, 3};
    public static final int[] resistanceDuration = new int[]{100, 100, 100, 100, 100, 100, 100, 100, 100, 100};
    public static final int[] resistanceValue = new int[]{0, 0, 0, 0, 0, 1, 1, 2, 2, 3};
    public static final float[] healthOnRevive = new float[]{0.2f, 0.2f, 0.3f, 0.3f, 0.4f, 0.4f, 0.5f, 0.6f, 0.7f, 0.8f};
    public int deathTimer = 0;

    public LivingArmourUpgradeGrimReaperSprint(int level) {
        super(level);
    }

    @Override
    public void onTick(World world, EntityPlayer player, ILivingArmour livingArmour) {
        if (this.deathTimer > 0) {
            --this.deathTimer;
        }
    }

    @Override
    public String getUniqueIdentifier() {
        return "bloodmagic.upgrade.grimReaper";
    }

    @Override
    public int getMaxTier() {
        return 10;
    }

    @Override
    public int getCostOfUpgrade() {
        return costs[this.level];
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.deathTimer = tag.func_74762_e("bloodmagic.tracker.grimReaper");
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("bloodmagic.tracker.grimReaper", this.deathTimer);
    }

    @Override
    public String getUnlocalizedName() {
        return tooltipBase + "grimReaper";
    }

    public void applyEffectOnRebirth(EntityPlayer player) {
        int resDur;
        player.func_70606_j(player.func_110138_aP() * healthOnRevive[this.level]);
        int strDur = strengthDuration[this.level];
        if (strDur > 0) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76420_g, strDur, strengthValue[this.level]));
        }
        if ((resDur = resistanceDuration[this.level]) > 0) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, resDur, resistanceValue[this.level]));
        }
        this.deathTimer = rebirthDelay[this.level];
        player.func_146105_b((ITextComponent)new TextComponentString(TextHelper.localizeEffect(chatBase + "grimReaper", new Object[0])), true);
    }

    public boolean canSavePlayer(EntityPlayer player) {
        return this.deathTimer <= 0;
    }
}

