/*
 * Decompiled with CFR 0.152.
 */
package com.pam.harvestcraft.config;

import com.pam.harvestcraft.HarvestCraft;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.biome.Biome;

public class TreeGenerationConfiguration {
    private String fruit;
    private boolean enableGeneration = true;
    private int rarity = 20;
    private List<Biome> biomesAllowed = new ArrayList<Biome>();

    public TreeGenerationConfiguration(String fruit, boolean enableGeneration, int rarity, List<Biome> availableBiomes, String[] biomesAllowed) {
        this.fruit = fruit;
        this.enableGeneration = enableGeneration;
        if (!this.enableGeneration) {
            HarvestCraft.log.trace("generation is disabled for " + fruit);
            return;
        }
        this.rarity = rarity;
        Arrays.stream(biomesAllowed).forEach(item -> {
            Optional<Biome> found = availableBiomes.stream().filter(b -> b.getRegistryName().toString().equalsIgnoreCase((String)item)).findFirst();
            if (found != null && found.isPresent() && !this.getBiomesAllowed().contains(found.get())) {
                HarvestCraft.log.trace("biome added:" + found.get().getRegistryName().toString());
                this.biomesAllowed.add(found.get());
            }
        });
    }

    public boolean getEnableGeneration() {
        return this.enableGeneration;
    }

    public String getFruit() {
        return this.fruit;
    }

    public int getRarity() {
        return this.rarity;
    }

    public List<Biome> getBiomesAllowed() {
        return this.biomesAllowed;
    }
}

