/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.client.gui;

import aroma1997.core.client.gui.GuiBase;
import aroma1997.core.client.gui.elements.ILocationLookup;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public interface IRenderable {
    public void render(int var1, int var2, Gui var3, TextureManager var4);

    default public void render(int x, int y, GuiBase<?> gui) {
        this.render(x, y, (Gui)gui, gui.getTextureManager());
    }

    default public IRenderable offset(final int offsetX, final int offsetY) {
        final IRenderable parent = this;
        return new IRenderable(){

            @Override
            public void render(int x, int y, Gui gui, TextureManager textureManager) {
                IRenderable.this.render(x + offsetX, y + offsetY, gui, textureManager);
            }

            @Override
            public IRenderable offset(int x, int y) {
                return parent.offset(offsetX + x, offsetY + y);
            }
        };
    }

    public static IRenderable getRenderable(final ItemStack stack) {
        return new IRenderable(){

            @Override
            public void render(int x, int y, Gui gui, TextureManager textureManager) {
                Minecraft.func_71410_x().func_175599_af().func_180450_b(stack, x, y);
            }
        };
    }

    public static IRenderable getRenderable(final Supplier<String> text, final ILocationLookup location) {
        return new IRenderable(){

            @Override
            public void render(int x, int y, Gui gui, TextureManager textureManager) {
                GlStateManager.func_179141_d();
                Minecraft.func_71410_x().field_71466_p.func_78279_b((String)text.get(), x + 3, y, location.getWidth() - 8, 0x404040);
            }
        };
    }

    public static IRenderable getRenderable(Supplier<String> text) {
        return IRenderable.getRenderable(text, new ILocationLookup(){

            @Override
            public int getX() {
                return 0;
            }

            @Override
            public int getY() {
                return 0;
            }

            @Override
            public int getWidth() {
                return Integer.MAX_VALUE;
            }

            @Override
            public int getHeight() {
                return Integer.MAX_VALUE;
            }
        });
    }

    default public IRenderable scaled(final float scale) {
        final IRenderable parent = this;
        return new IRenderable(){

            @Override
            public void render(int x, int y, Gui gui, TextureManager textureManager) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
                parent.render(0, 0, gui, textureManager);
                GlStateManager.func_179121_F();
            }
        };
    }
}

