/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.client.gui;

import aroma1997.core.client.gui.IRenderTexture;
import aroma1997.core.client.gui.StaticTexture;
import aroma1997.core.client.gui.elements.GuiElement;
import aroma1997.core.client.gui.elements.ILocationLookup;
import aroma1997.core.container.ContainerBase;
import aroma1997.core.container.elements.ContainerElementBase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.inventory.Slot;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiBase<C extends ContainerBase<?>>
extends GuiContainer
implements ILocationLookup {
    private static final StaticTexture[][] background = new StaticTexture[][]{{StaticTexture.TOPLEFT, StaticTexture.TOP, StaticTexture.TOPRIGHT}, {StaticTexture.LEFT, StaticTexture.MIDDLE, StaticTexture.RIGHT}, {StaticTexture.BOTTOMLEFT, StaticTexture.BOTTOM, StaticTexture.BOTTOMRIGHT}};
    private final List<GuiElement> guiElements = new ArrayList<GuiElement>();

    public GuiBase(C container) {
        this(container, 176);
    }

    public GuiBase(C container, int height) {
        this(container, 166, height);
    }

    public GuiBase(C container, int width, int height) {
        super(container);
        this.field_146999_f = GuiBase.getFirstGreaterMultipleOf(width);
        this.field_147000_g = GuiBase.getFirstGreaterMultipleOf(height);
        for (ContainerElementBase<?> element : ((ContainerBase)((Object)container)).getElements()) {
            GuiElement guiElement = element.getGuiElement(this);
            if (guiElement == null) continue;
            this.addGuiElement(guiElement);
        }
    }

    public <T extends GuiElement> T addGuiElement(T element) {
        this.guiElements.add(element);
        return element;
    }

    public Iterable<GuiElement> getElements() {
        return this.guiElements;
    }

    private static int getFirstGreaterMultipleOf(int number) {
        if (number % 18 != 0) {
            number -= number % 18;
            number += 18;
        }
        return number;
    }

    public C getContainer() {
        return (C)((Object)((ContainerBase)this.field_147002_h));
    }

    public void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        for (GuiElement element : this.guiElements) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            element.drawForegroundLayer(mouseX, mouseY);
        }
        for (GuiElement element : this.guiElements) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            element.drawOverlay(mouseX, mouseY);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.drawTex(this.offset(this.field_147003_i, this.field_147009_r), background);
        for (Slot slot : ((ContainerBase)((Object)this.getContainer())).field_75151_b) {
            if (!slot.func_111238_b()) continue;
            StaticTexture.SLOT.render(slot.field_75223_e - 1 + this.field_147003_i, slot.field_75221_f - 1 + this.field_147009_r, this);
        }
    }

    public static void bindColor(int color) {
        int alpha = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        GlStateManager.func_179131_c((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)((float)alpha / 255.0f));
    }

    public <T extends IRenderTexture> void drawTex(ILocationLookup pos, T[][] background) {
        T[] texturesToUse;
        assert (background.length == 3);
        assert (background[0].length == 3 && background[1].length == 3 && background[2].length == 3);
        assert (background[0][0].getHeight() == background[0][1].getHeight() && background[0][0].getHeight() == background[0][2].getHeight());
        assert (background[1][0].getHeight() == background[1][1].getHeight() && background[1][0].getHeight() == background[1][2].getHeight());
        assert (background[2][0].getHeight() == background[2][1].getHeight() && background[2][0].getHeight() == background[2][2].getHeight());
        int heightPixels = pos.getHeight();
        int widthPixels = pos.getWidth();
        int posX = pos.getX();
        int posY = pos.getY();
        for (int currentHeight = 0; currentHeight < heightPixels; currentHeight += texturesToUse[0].getHeight()) {
            T texture;
            texturesToUse = background[GuiBase.getIndex(currentHeight, heightPixels - background[2][0].getHeight())];
            for (int currentWidth = 0; currentWidth < widthPixels; currentWidth += texture.getWidth()) {
                texture = texturesToUse[GuiBase.getIndex(currentWidth, widthPixels - texturesToUse[2].getWidth())];
                texture.render(posX + currentWidth, posY + currentHeight, this);
            }
        }
    }

    public void drawLineAround(int x, int y, int width, int height, int color) {
        GuiBase.func_73734_a((int)(x - 1), (int)(y - 1), (int)(x + width + 1), (int)y, (int)color);
        GuiBase.func_73734_a((int)(x - 1), (int)(y + height), (int)(x + width + 1), (int)(y + height + 1), (int)color);
        GuiBase.func_73734_a((int)x, (int)(y - 1), (int)(x - 1), (int)(y + height + 1), (int)color);
        GuiBase.func_73734_a((int)(x + width), (int)(y - 1), (int)(x + width + 1), (int)(y + height + 1), (int)color);
    }

    public void drawColoredRect(int x, int y, int width, int height, int color) {
        GuiBase.func_73734_a((int)x, (int)y, (int)(x + width), (int)(y + height), (int)color);
    }

    public void drawLine(int x0, int y0, int x1, int y1, int color) {
        int dx = Math.abs(x1 - x0);
        int sx = x0 < x1 ? 1 : -1;
        int dy = -Math.abs(y1 - y0);
        int sy = y0 < y1 ? 1 : -1;
        int err = dx + dy;
        while (true) {
            GuiBase.func_73734_a((int)x0, (int)y0, (int)(x0 + 1), (int)(y0 + 1), (int)color);
            if (x0 == x1 && y0 == y1) break;
            int e2 = 2 * err;
            if (e2 > dy) {
                err += dy;
                x0 += sx;
                continue;
            }
            if (e2 >= dx) continue;
            err += dx;
            y0 += sy;
        }
    }

    private static int getIndex(int current, int max) {
        if (current <= 0) {
            return 0;
        }
        if (current >= max) {
            return 2;
        }
        return 1;
    }

    public TextureManager getTextureManager() {
        return this.field_146297_k.field_71446_o;
    }

    public List<GuiButton> getButtonList() {
        return this.field_146292_n;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        GuiElement element;
        int relX = mouseX - this.field_147003_i;
        int relY = mouseY - this.field_147009_r;
        Iterator<GuiElement> iterator = this.guiElements.iterator();
        while (!(!iterator.hasNext() || (element = iterator.next()).isIn(relX, relY) && element.onClick(relX, relY))) {
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        for (GuiElement element : this.guiElements) {
            element.init();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    @Override
    public int getX() {
        return 0;
    }

    @Override
    public int getY() {
        return 0;
    }

    @Override
    public int getWidth() {
        return this.field_146999_f;
    }

    @Override
    public int getHeight() {
        return this.field_147000_g;
    }
}

