/*
 * Decompiled with CFR 0.152.
 */
package vazkii.arl.util;

import java.util.concurrent.Callable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Mouse;
import vazkii.arl.interf.IDropInItem;
import vazkii.arl.network.NetworkHandler;
import vazkii.arl.network.message.MessageDropIn;
import vazkii.arl.util.RenderHelper;

public final class DropInHandler {
    public static void register() {
        MinecraftForge.EVENT_BUS.register(DropInHandler.class);
        CapabilityManager.INSTANCE.register(IDropInItem.class, (Capability.IStorage)CapabilityFactory.INSTANCE, (Callable)CapabilityFactory.INSTANCE);
    }

    @SubscribeEvent
    public static void onDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        Minecraft mc = Minecraft.func_71410_x();
        GuiScreen gui = mc.field_71462_r;
        if (gui instanceof GuiContainer) {
            GuiContainer container = (GuiContainer)gui;
            ItemStack held = mc.field_71439_g.field_71071_by.func_70445_o();
            if (!held.func_190926_b()) {
                Slot under = container.getSlotUnderMouse();
                for (Slot s : container.field_147002_h.field_75151_b) {
                    int y;
                    int x;
                    ItemStack stack;
                    IDropInItem dropin;
                    if (s.field_75224_c != mc.field_71439_g.field_71071_by || (dropin = DropInHandler.getDropInHandler(stack = s.func_75211_c())) == null || !dropin.canDropItemIn(stack, held)) continue;
                    if (s == under) {
                        x = event.getMouseX();
                        y = event.getMouseY();
                        RenderHelper.renderTooltip(x, y, dropin.getDropInTooltip(stack));
                        continue;
                    }
                    x = container.getGuiLeft() + s.field_75223_e;
                    y = container.getGuiTop() + s.field_75221_f;
                    GlStateManager.func_179097_i();
                    mc.field_71466_p.func_175063_a("+", (float)(x + 10), (float)(y + 8), 0xFFFF00);
                    GlStateManager.func_179126_j();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onRightClick(GuiScreenEvent.MouseInputEvent.Pre event) {
        Minecraft mc = Minecraft.func_71410_x();
        GuiScreen gui = mc.field_71462_r;
        if (gui instanceof GuiContainer && Mouse.getEventButton() == 1) {
            ItemStack stack;
            IDropInItem dropin;
            GuiContainer container = (GuiContainer)gui;
            Slot under = container.getSlotUnderMouse();
            ItemStack held = mc.field_71439_g.field_71071_by.func_70445_o();
            if (under != null && !held.func_190926_b() && under.field_75224_c == mc.field_71439_g.field_71071_by && (dropin = DropInHandler.getDropInHandler(stack = under.func_75211_c())) != null && dropin.canDropItemIn(stack, held)) {
                mc.field_71439_g.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageDropIn(under.getSlotIndex(), held));
                event.setCanceled(true);
            }
        }
    }

    public static void executeDropIn(EntityPlayer player, int slot, ItemStack stack) {
        ItemStack target = player.field_71071_by.func_70301_a(Math.min(player.field_71071_by.func_70302_i_() - 1, slot));
        IDropInItem dropin = DropInHandler.getDropInHandler(target);
        if (dropin != null && dropin.canDropItemIn(target, stack)) {
            ItemStack held = player.field_71071_by.func_70445_o();
            if (player.func_184812_l_() && !stack.func_190926_b()) {
                held = stack;
            }
            ItemStack result = dropin.dropItemIn(target, stack);
            player.field_71071_by.func_70299_a(slot, result);
            player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
        }
    }

    public static IDropInItem getDropInHandler(ItemStack stack) {
        IDropInItem item;
        if (stack.hasCapability(IDropInItem.DROP_IN_CAPABILITY, null) && (item = (IDropInItem)stack.getCapability(IDropInItem.DROP_IN_CAPABILITY, null)) != null) {
            return item;
        }
        if (stack.func_77973_b() instanceof IDropInItem) {
            return (IDropInItem)stack.func_77973_b();
        }
        return null;
    }

    private static class CapabilityFactory
    implements Capability.IStorage<IDropInItem>,
    Callable<IDropInItem> {
        private static CapabilityFactory INSTANCE = new CapabilityFactory();

        private CapabilityFactory() {
        }

        public NBTBase writeNBT(Capability<IDropInItem> capability, IDropInItem instance, EnumFacing side) {
            return null;
        }

        public void readNBT(Capability<IDropInItem> capability, IDropInItem instance, EnumFacing side, NBTBase nbt) {
        }

        @Override
        public IDropInItem call() throws Exception {
            return new DefaultImpl();
        }

        private static class DefaultImpl
        implements IDropInItem {
            private DefaultImpl() {
            }

            @Override
            public boolean canDropItemIn(ItemStack stack, ItemStack incoming) {
                return false;
            }

            @Override
            public ItemStack dropItemIn(ItemStack stack, ItemStack incoming) {
                return incoming;
            }
        }
    }
}

