/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.ironbackpacks.core;

import com.google.common.base.Preconditions;
import gr8pefish.ironbackpacks.ConfigHandler;
import gr8pefish.ironbackpacks.api.IronBackpacksAPI;
import gr8pefish.ironbackpacks.api.backpack.BackpackInfo;
import gr8pefish.ironbackpacks.api.backpack.IBackpack;
import gr8pefish.ironbackpacks.api.backpack.variant.BackpackSize;
import gr8pefish.ironbackpacks.api.backpack.variant.BackpackSpecialty;
import gr8pefish.ironbackpacks.api.backpack.variant.BackpackType;
import gr8pefish.ironbackpacks.api.upgrade.BackpackUpgrade;
import gr8pefish.ironbackpacks.api.upgrade.IUpgrade;
import gr8pefish.ironbackpacks.item.ItemBackpack;
import gr8pefish.ironbackpacks.item.ItemUpgrade;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;

@Mod.EventBusSubscriber
@GameRegistry.ObjectHolder(value="ironbackpacks")
public class RegistrarIronBackpacks {
    public static final Item BACKPACK = Items.field_190931_a;
    public static final Item UPGRADE = Items.field_190931_a;
    @GameRegistry.ObjectHolder(value="open_backpack")
    public static final SoundEvent BACKPACK_OPEN = null;
    @GameRegistry.ObjectHolder(value="close_backpack")
    public static final SoundEvent BACKPACK_CLOSE = null;
    @GameRegistry.ObjectHolder(value="basic")
    public static final BackpackType PACK_BASIC = null;
    @GameRegistry.ObjectHolder(value="iron")
    public static final BackpackType PACK_IRON = null;
    @GameRegistry.ObjectHolder(value="gold")
    public static final BackpackType PACK_GOLD = null;
    @GameRegistry.ObjectHolder(value="diamond")
    public static final BackpackType PACK_DIAMOND = null;
    @GameRegistry.ObjectHolder(value="damage_bar")
    public static final BackpackUpgrade UPGRADE_DAMAGE_BAR = null;
    @GameRegistry.ObjectHolder(value="lock")
    public static final BackpackUpgrade UPGRADE_LOCK = null;
    @GameRegistry.ObjectHolder(value="extra_upgrade")
    public static final BackpackUpgrade UPGRADE_EXTRA_UPGRADE = null;
    @GameRegistry.ObjectHolder(value="everlasting")
    public static final BackpackUpgrade UPGRADE_EVERLASTING = null;
    private static IForgeRegistry<BackpackType> REGISTRY_TYPES = null;
    private static IForgeRegistry<BackpackUpgrade> REGISTRY_UPGRADES = null;

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().register(new ItemBackpack().setRegistryName("backpack"));
        event.getRegistry().register(new ItemUpgrade().setRegistryName("upgrade"));
    }

    @SubscribeEvent
    public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().register(new SoundEvent(new ResourceLocation("ironbackpacks", "open_backpack")).setRegistryName("open_backpack"));
        event.getRegistry().register(new SoundEvent(new ResourceLocation("ironbackpacks", "close_backpack")).setRegistryName("close_backpack"));
    }

    @SubscribeEvent
    public static void registerBackpacks(RegistryEvent.Register<BackpackType> event) {
        event.getRegistry().register((IForgeRegistryEntry)new BackpackType(IronBackpacksAPI.NULL, 0, 0, false, BackpackSize.MIN));
        event.getRegistry().register((IForgeRegistryEntry)new BackpackType(new ResourceLocation("ironbackpacks", "basic"), 0, 4, false, 9, 2));
        event.getRegistry().register((IForgeRegistryEntry)new BackpackType(new ResourceLocation("ironbackpacks", "iron"), 1, 7, true, 9, 3));
        event.getRegistry().register((IForgeRegistryEntry)new BackpackType(new ResourceLocation("ironbackpacks", "gold"), 2, 12, true, 9, 5));
        event.getRegistry().register((IForgeRegistryEntry)new BackpackType(new ResourceLocation("ironbackpacks", "diamond"), 3, 18, true, 9, 7));
    }

    @SubscribeEvent
    public static void registerUpgrades(RegistryEvent.Register<BackpackUpgrade> event) {
        event.getRegistry().register((IForgeRegistryEntry)new BackpackUpgrade(IronBackpacksAPI.NULL, 0, 0));
        if (ConfigHandler.upgrades.enableDamageBar) {
            event.getRegistry().register((IForgeRegistryEntry)new BackpackUpgrade(new ResourceLocation("ironbackpacks", "damage_bar"), 1, 0));
        }
        if (ConfigHandler.upgrades.enablePackLatch) {
            event.getRegistry().register((IForgeRegistryEntry)new BackpackUpgrade(new ResourceLocation("ironbackpacks", "lock"), 1, 0));
        }
        if (ConfigHandler.upgrades.enableExtraUpgrade) {
            event.getRegistry().register((IForgeRegistryEntry)new BackpackUpgrade(new ResourceLocation("ironbackpacks", "extra_upgrade"), -1, 0));
        }
        if (ConfigHandler.upgrades.enableEverlasting) {
            event.getRegistry().register((IForgeRegistryEntry)new BackpackUpgrade(new ResourceLocation("ironbackpacks", "everlasting"), 4, 1));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        ModelLoader.setCustomMeshDefinition((Item)BACKPACK, stack -> {
            if (stack.func_77973_b() instanceof IBackpack) {
                IBackpack backpack = (IBackpack)stack.func_77973_b();
                BackpackInfo backpackInfo = backpack.getBackpackInfo(stack);
                ResourceLocation location = new ResourceLocation(backpackInfo.getVariant().getBackpackType().getIdentifier().func_110624_b(), "backpack/" + backpackInfo.getVariant().getBackpackType().getIdentifier().func_110623_a() + "/" + backpackInfo.getVariant().getBackpackSpecialty().func_176610_l());
                return new ModelResourceLocation(location, "inventory");
            }
            return new ModelResourceLocation(new ResourceLocation("ironbackpacks", "backpack/null"), "inventory");
        });
        for (BackpackType backpackType : IronBackpacksAPI.getBackpackTypes()) {
            String resourcePathIn;
            if (backpackType.isNull()) continue;
            if (!backpackType.hasSpecialties()) {
                resourcePathIn = "backpack/" + backpackType.getIdentifier().func_110623_a() + "/" + BackpackSpecialty.NONE.func_176610_l();
                ResourceLocation location = new ResourceLocation(backpackType.getIdentifier().func_110624_b(), resourcePathIn);
                ModelLoader.registerItemVariants((Item)BACKPACK, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(location, "inventory")});
                continue;
            }
            for (String backpackSpecialty : BackpackSpecialty.getNonNoneNames()) {
                resourcePathIn = "backpack/" + backpackType.getIdentifier().func_110623_a() + "/" + backpackSpecialty;
                ResourceLocation location = new ResourceLocation(backpackType.getIdentifier().func_110624_b(), resourcePathIn);
                ModelLoader.registerItemVariants((Item)BACKPACK, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(location, "inventory")});
            }
        }
        ModelLoader.registerItemVariants((Item)BACKPACK, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(new ResourceLocation("ironbackpacks", "backpack/null"), "inventory")});
        ModelLoader.setCustomMeshDefinition((Item)UPGRADE, stack -> {
            if (stack.func_77973_b() instanceof IUpgrade) {
                IUpgrade upgrade = (IUpgrade)stack.func_77973_b();
                BackpackUpgrade backpackUpgrade = upgrade.getUpgrade(stack);
                ResourceLocation location = new ResourceLocation(backpackUpgrade.getIdentifier().func_110624_b(), "upgrade/" + backpackUpgrade.getIdentifier().func_110623_a());
                if (backpackUpgrade.isNull()) {
                    location = new ResourceLocation("ironbackpacks", "upgrade/null");
                }
                return new ModelResourceLocation(location, "inventory");
            }
            return new ModelResourceLocation(new ResourceLocation("ironbackpacks", "upgrade/null"), "inventory");
        });
        for (BackpackUpgrade backpackUpgrade : IronBackpacksAPI.getUpgrades()) {
            if (backpackUpgrade.isNull()) continue;
            ResourceLocation location = new ResourceLocation(backpackUpgrade.getIdentifier().func_110624_b(), "upgrade/" + backpackUpgrade.getIdentifier().func_110623_a());
            ModelLoader.registerItemVariants((Item)UPGRADE, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(location, "inventory")});
        }
        ModelLoader.registerItemVariants((Item)UPGRADE, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(new ResourceLocation("ironbackpacks", "upgrade/null"), "inventory")});
    }

    @SubscribeEvent
    public static void createRegistries(RegistryEvent.NewRegistry event) {
        REGISTRY_TYPES = new RegistryBuilder().setName(new ResourceLocation("ironbackpacks", "types")).setDefaultKey(IronBackpacksAPI.NULL).setType(BackpackType.class).setIDRange(0, 0x7FFFFFFE).addCallback((o, s, id, obj, oldObj) -> {
            BackpackType cfr_ignored_0 = (BackpackType)((Object)((Object)Preconditions.checkNotNull((Object)obj, (Object)"Attempted to register null Backpack type")));
        }).create();
        REGISTRY_UPGRADES = new RegistryBuilder().setName(new ResourceLocation("ironbackpacks", "upgrade")).setDefaultKey(IronBackpacksAPI.NULL).setType(BackpackUpgrade.class).setIDRange(0, 0x7FFFFFFE).addCallback((o, s, id, obj, oldObj) -> {
            BackpackUpgrade cfr_ignored_0 = (BackpackUpgrade)((Object)((Object)Preconditions.checkNotNull((Object)obj, (Object)"Attempted to register null Backpack upgrade")));
        }).create();
    }
}

