/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.ironbackpacks.api.backpack;

import com.google.common.base.Preconditions;
import gr8pefish.ironbackpacks.api.IronBackpacksAPI;
import gr8pefish.ironbackpacks.api.backpack.BackpackInfo;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;

public interface IBackpack {
    @Nonnull
    default public BackpackInfo getBackpackInfo(@Nonnull ItemStack stack) {
        Preconditions.checkNotNull((Object)stack, (Object)"ItemStack cannot be null");
        return BackpackInfo.fromStack(stack);
    }

    default public int getBackpackColor(@Nonnull ItemStack stack) {
        Preconditions.checkNotNull((Object)stack, (Object)"ItemStack cannot be null");
        return BackpackInfo.getColor(stack);
    }

    default public void updateBackpack(@Nonnull ItemStack stack, @Nonnull BackpackInfo backpackInfo) {
        Preconditions.checkNotNull((Object)stack, (Object)"ItemStack cannot be null");
        Preconditions.checkNotNull((Object)backpackInfo, (Object)"BackpackInfo cannot be null");
        IronBackpacksAPI.applyPackInfo(stack, backpackInfo);
    }
}

