/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.render;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.base.conduit.ConnectionMode;
import crazypants.enderio.base.conduit.IClientConduit;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.IConduitBundle;
import crazypants.enderio.base.conduit.IConduitRenderer;
import crazypants.enderio.base.conduit.geom.CollidableComponent;
import crazypants.enderio.base.conduit.geom.ConduitConnectorType;
import crazypants.enderio.base.conduit.geom.ConduitGeometryUtil;
import crazypants.enderio.base.paint.YetaUtil;
import crazypants.enderio.base.render.IBlockStateWrapper;
import crazypants.enderio.conduits.conduit.TileConduitBundle;
import crazypants.enderio.conduits.config.ConduitConfig;
import crazypants.enderio.conduits.render.BakedQuadBuilder;
import crazypants.enderio.conduits.render.ConduitBundleRenderManager;
import crazypants.enderio.conduits.render.DefaultConduitRenderer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ConduitBundleRenderer
extends TileEntitySpecialRenderer<TileConduitBundle> {
    @Nonnull
    private final List<IConduitRenderer> conduitRenderers = new ArrayList<IConduitRenderer>();
    @Nonnull
    private final List<IConduitRenderer> dynamicCnduitRenderers = new ArrayList<IConduitRenderer>();
    @Nonnull
    private final DefaultConduitRenderer dcr = new DefaultConduitRenderer();
    @Nonnull
    private static final Vector4f CORE_UVS = new Vector4f(2.0f, 14.0f, 14.0f, 2.0f);
    private boolean breakingAnimOnWholeConduit = false;

    public void registerRenderer(IConduitRenderer renderer) {
        this.conduitRenderers.add(renderer);
        if (renderer.isDynamic()) {
            this.dynamicCnduitRenderers.add(renderer);
        }
    }

    public void render(@Nonnull TileConduitBundle te, double x, double y, double z, float partialTick, int b, float alpha) {
        IBlockState paintSource;
        TileConduitBundle bundle = te;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (bundle.hasFacade() && !YetaUtil.isFacadeHidden(bundle, (EntityPlayer)player) && (paintSource = bundle.getPaintSource()) != null && paintSource.func_185914_p()) {
            return;
        }
        NNList<RenderPair> renderers = this.getDynamicRenderersForConduitBundle(bundle, player);
        if (renderers.isEmpty()) {
            return;
        }
        float brightness = bundle.getEntity().func_145831_w().func_175642_b(EnumSkyBlock.SKY, bundle.getLocation());
        RenderUtil.setupLightmapCoords((BlockPos)te.func_174877_v(), (World)te.func_145831_w());
        RenderUtil.bindBlockTexture();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179108_z();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder tes = tessellator.func_178180_c();
        tes.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        for (RenderPair pair : renderers) {
            pair.getRenderer().renderDynamicEntity(this, bundle, pair.getConduit(), x, y, z, partialTick, brightness);
        }
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179133_A();
        GlStateManager.func_179084_k();
        GlStateManager.func_179103_j((int)7424);
        RenderHelper.func_74519_b();
        GlStateManager.func_179121_F();
    }

    @Nonnull
    public List<BakedQuad> getGeneralQuads(@Nonnull IBlockStateWrapper state, BlockRenderLayer layer) {
        ArrayList<BakedQuad> result = new ArrayList<BakedQuad>();
        TileEntity tileEntity = state.getTileEntity();
        if (tileEntity instanceof TileConduitBundle) {
            IConduitBundle bundle = (IConduitBundle)tileEntity;
            if (layer == null) {
                this.addBreakingQuads(bundle, result);
            } else {
                float brightness = ConduitConfig.updateLightingWhenHidingFacades.get() == false && bundle.hasFacade() ? 1.572888E7f : (float)bundle.getEntity().func_145831_w().func_175642_b(EnumSkyBlock.SKY, bundle.getLocation());
                this.addConduitQuads(state, bundle, brightness, layer, result);
            }
        }
        return result;
    }

    private void addConduitQuads(@Nonnull IBlockStateWrapper state, @Nonnull IConduitBundle bundle, float brightness, @Nonnull BlockRenderLayer layer, @Nonnull List<BakedQuad> quads) {
        HashSet<EnumFacing> externals = new HashSet<EnumFacing>();
        ArrayList<BoundingBox> wireBounds = new ArrayList<BoundingBox>();
        if (layer == BlockRenderLayer.CUTOUT && bundle.hasFacade() && state.getYetaDisplayMode().isHideFacades()) {
            wireBounds.add(BoundingBox.UNIT_CUBE);
        }
        for (IClientConduit c : bundle.getClientConduits()) {
            if (!(c instanceof IClientConduit.WithDefaultRendering)) continue;
            IClientConduit.WithDefaultRendering con = (IClientConduit.WithDefaultRendering)c;
            if (state.getYetaDisplayMode().renderConduit(con)) {
                IConduitRenderer renderer = this.getRendererForConduit(con);
                if (renderer.canRenderInLayer(con, layer)) {
                    renderer.addBakedQuads(this, bundle, con, brightness, layer, quads);
                }
                Set<EnumFacing> extCons = con.getExternalConnections();
                Iterator iterator = extCons.iterator();
                while (iterator.hasNext()) {
                    EnumFacing dir = (EnumFacing)iterator.next();
                    if (dir == null || con.getConnectionMode(dir) == ConnectionMode.DISABLED || con.getConnectionMode(dir) == ConnectionMode.NOT_SET) continue;
                    externals.add(dir);
                }
                continue;
            }
            if (layer != BlockRenderLayer.CUTOUT) continue;
            Collection<CollidableComponent> components = con.getCollidableComponents();
            for (CollidableComponent component : components) {
                if (component == null) continue;
                this.addWireBounds(wireBounds, component);
            }
        }
        List<CollidableComponent> connectors = bundle.getConnectors();
        for (CollidableComponent component : connectors) {
            if (component == null) continue;
            if (component.conduitType != null) {
                IClientConduit.WithDefaultRendering conduit = (IClientConduit.WithDefaultRendering)bundle.getConduit(component.conduitType);
                if (conduit == null) continue;
                IConduitRenderer renderer = this.getRendererForConduit(conduit);
                if (state.getYetaDisplayMode().renderConduit(component.conduitType)) {
                    if (renderer.getCoreLayer() != layer) continue;
                    TextureAtlasSprite tex = conduit.getTextureForState(component);
                    BakedQuadBuilder.addBakedQuads(quads, component.bound, CORE_UVS, tex);
                    continue;
                }
                if (layer != BlockRenderLayer.CUTOUT) continue;
                this.addWireBounds(wireBounds, component);
                continue;
            }
            if (layer != BlockRenderLayer.SOLID || !state.getYetaDisplayMode().getDisplayMode().isAll()) continue;
            TextureAtlasSprite tex = ConduitBundleRenderManager.instance.getConnectorIcon(component.data);
            BakedQuadBuilder.addBakedQuads(quads, component.bound, tex);
        }
        for (BoundingBox wireBound : wireBounds) {
            if (wireBound == null) continue;
            BakedQuadBuilder.addBakedQuads(quads, wireBound, ConduitBundleRenderManager.instance.getWireFrameIcon());
        }
        if (layer == BlockRenderLayer.SOLID) {
            for (EnumFacing dir : externals) {
                if (dir == null) continue;
                this.addQuadsForExternalConnection(dir, quads);
            }
        }
        if (layer == BlockRenderLayer.CUTOUT && bundle.getClientConduits().isEmpty() && !bundle.hasFacade()) {
            BakedQuadBuilder.addBakedQuads(quads, BoundingBox.UNIT_CUBE.scale(0.1), ConduitBundleRenderManager.instance.getWireFrameIcon());
            BakedQuadBuilder.addBakedQuads(quads, BoundingBox.UNIT_CUBE.scale(0.15), ConduitBundleRenderManager.instance.getWireFrameIcon());
            BakedQuadBuilder.addBakedQuads(quads, BoundingBox.UNIT_CUBE.scale(0.2), ConduitBundleRenderManager.instance.getWireFrameIcon());
            BakedQuadBuilder.addBakedQuads(quads, BoundingBox.UNIT_CUBE.scale(0.25), ConduitBundleRenderManager.instance.getWireFrameIcon());
        }
    }

    private void addBreakingQuads(@Nonnull IConduitBundle bundle, @Nonnull List<BakedQuad> quads) {
        Class<? extends IConduit> conduitType = null;
        RayTraceResult hit = Minecraft.func_71410_x().field_71476_x;
        if (NullHelper.untrust((Object)hit) != null && hit.hitInfo instanceof CollidableComponent) {
            conduitType = ((CollidableComponent)hit.hitInfo).conduitType;
        }
        if (this.breakingAnimOnWholeConduit) {
            for (IClientConduit c : bundle.getClientConduits()) {
                if (conduitType != c.getClass() && conduitType != c.getBaseConduitType()) continue;
                IConduitRenderer renderer = this.getRendererForConduit(c);
                renderer.addBakedQuads(this, bundle, (IClientConduit.WithDefaultRendering)c, 1.0f, BlockRenderLayer.CUTOUT, quads);
            }
        }
        List<CollidableComponent> connectors = bundle.getConnectors();
        for (CollidableComponent component : connectors) {
            IClientConduit.WithDefaultRendering conduit;
            if (component == null || component.conduitType != conduitType && conduitType != null || (conduit = (IClientConduit.WithDefaultRendering)bundle.getConduit(component.conduitType)) == null) continue;
            TextureAtlasSprite tex = conduit.getTextureForState(component);
            BakedQuadBuilder.addBakedQuads(quads, component.bound, tex);
        }
    }

    private void addWireBounds(@Nonnull List<BoundingBox> wireBounds, @Nonnull CollidableComponent component) {
        if (component.isDirectional()) {
            EnumFacing componentDirection = component.getDirection();
            double sx = componentDirection.func_82601_c() != 0 ? 1.0 : 0.7;
            double sy = componentDirection.func_96559_d() != 0 ? 1.0 : 0.7;
            double sz = componentDirection.func_82599_e() != 0 ? 1.0 : 0.7;
            wireBounds.add(component.bound.scale(sx, sy, sz));
        } else {
            wireBounds.add(component.bound);
        }
    }

    private void addQuadsForExternalConnection(@Nonnull EnumFacing dir, @Nonnull List<BakedQuad> quads) {
        BoundingBox[] bbs;
        TextureAtlasSprite tex = ConduitBundleRenderManager.instance.getConnectorIcon((Object)ConduitConnectorType.EXTERNAL);
        for (BoundingBox bb : bbs = ConduitGeometryUtil.instance.getExternalConnectorBoundingBoxes(dir)) {
            if (bb == null) continue;
            BakedQuadBuilder.addBakedQuads(quads, bb, tex);
        }
    }

    @Nonnull
    public IConduitRenderer getRendererForConduit(@Nonnull IConduit conduit) {
        for (IConduitRenderer renderer : this.conduitRenderers) {
            if (!renderer.isRendererForConduit(conduit)) continue;
            return renderer;
        }
        return this.dcr;
    }

    @Nonnull
    protected NNList<RenderPair> getDynamicRenderersForConduitBundle(IConduitBundle b, EntityPlayerSP player) {
        NNList result = null;
        for (IConduitRenderer conduitRenderer : this.dynamicCnduitRenderers) {
            for (IClientConduit conduit : b.getClientConduits()) {
                if (!(conduit instanceof IClientConduit.WithDefaultRendering) || conduitRenderer == null || !conduitRenderer.isRendererForConduit(conduit) || !YetaUtil.renderConduit((EntityPlayer)player, conduit)) continue;
                if (result == null) {
                    result = new NNList();
                }
                result.add((Object)new RenderPair(conduitRenderer, (IClientConduit.WithDefaultRendering)conduit));
            }
        }
        return result != null ? result : NNList.emptyList();
    }

    static {
        CORE_UVS.scale(0.0625);
    }

    static class RenderPair {
        @Nonnull
        private final IClientConduit.WithDefaultRendering conduit;
        @Nonnull
        private final IConduitRenderer renderer;

        RenderPair(@Nonnull IConduitRenderer renderer, @Nonnull IClientConduit.WithDefaultRendering conduit) {
            this.renderer = renderer;
            this.conduit = conduit;
        }

        @Nonnull
        IClientConduit.WithDefaultRendering getConduit() {
            return this.conduit;
        }

        @Nonnull
        IConduitRenderer getRenderer() {
            return this.renderer;
        }
    }
}

