/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.recipe.enchanter;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import com.enderio.core.common.util.stackable.Things;
import crazypants.enderio.base.config.config.EnchanterConfig;
import crazypants.enderio.base.recipe.IMachineRecipe;
import crazypants.enderio.base.recipe.MachineRecipeInput;
import crazypants.enderio.base.recipe.RecipeLevel;
import crazypants.enderio.util.Prep;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.init.Items;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;

public class EnchanterRecipe
implements IMachineRecipe {
    @Nonnull
    private static final Things BOOK = new Things().add(Items.field_151099_bA);
    @Nonnull
    private static final Things LAPIS = new Things(new String[]{"oredict:gemLapis"});
    @Nonnull
    private final Things input;
    @Nonnull
    private final Enchantment enchantment;
    private final int stackSizePerLevel;
    private final double costMultiplier;
    @Nonnull
    private final String uuid;

    public EnchanterRecipe(@Nonnull Things input, int stackSizePerLevel, @Nonnull Enchantment enchantment, double costMultiplier) {
        this.input = input;
        this.stackSizePerLevel = stackSizePerLevel;
        this.enchantment = enchantment;
        this.costMultiplier = costMultiplier;
        this.uuid = (String)NullHelper.first((Object[])new String[]{((ItemStack)input.getItemStacksRaw().get(0)).toString(), "invalid Recipe"});
    }

    @Nonnull
    public Enchantment getEnchantment() {
        return this.enchantment;
    }

    private int getLevelForStackSize(int size) {
        return Math.min(size / this.stackSizePerLevel, this.enchantment.func_77325_b());
    }

    public int getItemsPerLevel() {
        return this.stackSizePerLevel;
    }

    @Override
    @Nonnull
    public String getUid() {
        return this.uuid;
    }

    @Override
    public int getEnergyRequired(@Nonnull NNList<MachineRecipeInput> inputs) {
        return 0;
    }

    @Override
    public boolean isRecipe(@Nonnull RecipeLevel machineLevel, @Nonnull NNList<MachineRecipeInput> inputs) {
        if (!RecipeLevel.IGNORE.canMake(machineLevel)) {
            return false;
        }
        ItemStack slot0 = MachineRecipeInput.getInputForSlot(0, inputs);
        ItemStack slot1 = MachineRecipeInput.getInputForSlot(1, inputs);
        ItemStack slot2 = MachineRecipeInput.getInputForSlot(2, inputs);
        if (!(BOOK.contains(slot0) && this.input.contains(slot1) && LAPIS.contains(slot2))) {
            return false;
        }
        int level = this.getLevelForStackSize(slot1.func_190916_E());
        if (level < 1) {
            return false;
        }
        return slot2.func_190916_E() >= this.getLapizForLevel(level);
    }

    @Override
    @Nonnull
    public IMachineRecipe.ResultStack[] getCompletedResult(long nextSeed, float chanceMultiplier, @Nonnull NNList<MachineRecipeInput> inputs) {
        ItemStack slot1 = MachineRecipeInput.getInputForSlot(1, inputs);
        int level = this.getLevelForStackSize(slot1.func_190916_E());
        EnchantmentData enchantmentData = new EnchantmentData(this.enchantment, level);
        ItemStack output = new ItemStack(Items.field_151134_bR);
        ItemEnchantedBook.func_92115_a((ItemStack)output, (EnchantmentData)enchantmentData);
        return new IMachineRecipe.ResultStack[]{new IMachineRecipe.ResultStack(output)};
    }

    @Override
    public boolean isValidInput(@Nonnull RecipeLevel machineLevel, @Nonnull MachineRecipeInput inputs) {
        if (!RecipeLevel.IGNORE.canMake(machineLevel)) {
            return false;
        }
        ItemStack slot0 = MachineRecipeInput.getInputForSlot(0, inputs);
        ItemStack slot1 = MachineRecipeInput.getInputForSlot(1, inputs);
        ItemStack slot2 = MachineRecipeInput.getInputForSlot(2, inputs);
        return Prep.isValid(slot0) && BOOK.contains(slot0) || Prep.isValid(slot1) && this.input.contains(slot1) || Prep.isValid(slot2) && LAPIS.contains(slot2);
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return "enchanter";
    }

    @Nonnull
    public NNList<MachineRecipeInput> getQuantitiesConsumed(@Nonnull NNList<MachineRecipeInput> inputs) {
        ItemStack slot0 = MachineRecipeInput.getInputForSlot(0, inputs).func_77946_l();
        ItemStack slot1 = MachineRecipeInput.getInputForSlot(1, inputs).func_77946_l();
        ItemStack slot2 = MachineRecipeInput.getInputForSlot(2, inputs).func_77946_l();
        int level = this.getLevelForStackSize(slot1.func_190916_E());
        slot0.func_190920_e(1);
        slot1.func_190920_e(this.stackSizePerLevel * level);
        slot2.func_190920_e(this.getLapizForLevel(level));
        NNList result = new NNList();
        result.add((Object)new MachineRecipeInput(0, slot0));
        result.add((Object)new MachineRecipeInput(1, slot1));
        result.add((Object)new MachineRecipeInput(2, slot2));
        return result;
    }

    public NNList<NNList<MachineRecipeInput>> getVariants() {
        NNList result = new NNList();
        for (int level = 1; level <= this.enchantment.func_77325_b(); ++level) {
            for (ItemStack item : this.input.getItemStacks()) {
                item = item.func_77946_l();
                for (ItemStack lapis : LAPIS.getItemStacks()) {
                    lapis = lapis.func_77946_l();
                    item.func_190920_e(this.stackSizePerLevel * level);
                    lapis.func_190920_e(this.getLapizForLevel(level));
                    if (item.func_190916_E() > item.func_77976_d() || lapis.func_190916_E() > lapis.func_77976_d()) continue;
                    result.add(this.getQuantitiesConsumed((NNList<MachineRecipeInput>)new NNList((Object[])new MachineRecipeInput[]{new MachineRecipeInput(0, (ItemStack)BOOK.getItemStacks().get(0)), new MachineRecipeInput(1, item), new MachineRecipeInput(2, lapis)})));
                }
            }
        }
        return result;
    }

    public int getXPCost(@Nonnull NNList<MachineRecipeInput> inputs) {
        ItemStack slot1 = MachineRecipeInput.getInputForSlot(1, inputs);
        int level = this.getLevelForStackSize(slot1.func_190916_E());
        return this.getCostForLevel(level);
    }

    private int getCostForLevel(int level) {
        level = Math.min(level, this.enchantment.func_77325_b());
        int cost = this.getRawCostForLevel(level);
        if (level < this.enchantment.func_77325_b()) {
            int nextCost = this.getRawCostForLevel(level + 1);
            cost = Math.max(nextCost / 2, cost);
        }
        return cost;
    }

    private int getRawCostForLevel(int level) {
        double min = Math.max(1, this.enchantment.func_77321_a(level));
        int cost = (int)Math.round((min *= this.costMultiplier) * EnchanterConfig.levelCostFactor.get());
        return cost += EnchanterConfig.baseLevelCost.get().intValue();
    }

    private int getLapizForLevel(int level) {
        int res = this.enchantment.func_77325_b() == 1 ? 5 : level;
        return (int)Math.max(1L, Math.round((double)res * EnchanterConfig.lapisCostFactor.get()));
    }

    public int getLapizForStackSize(int stackSize) {
        return this.getLapizForLevel(this.getLevelForStackSize(stackSize));
    }
}

