/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.material.material;

import crazypants.enderio.base.config.config.InfinityConfig;
import crazypants.enderio.base.material.material.Material;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockFire;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="enderio")
public class MaterialCraftingHandler {
    private static final Random RANDOM = new Random();
    private static final Map<BlockPos, Long> fires = new HashMap<BlockPos, Long>();

    @SubscribeEvent
    public static void on(BlockEvent.NeighborNotifyEvent event) {
        if (InfinityConfig.inWorldCraftingFireEnabled.get().booleanValue()) {
            World world = event.getWorld();
            BlockPos posIdx = event.getPos();
            if (world.field_73011_w.getDimension() != 0) {
                if (InfinityConfig.enableInAllDimensions.get().booleanValue()) {
                    posIdx = posIdx.func_177981_b(world.field_73011_w.getDimension() * 256);
                } else {
                    return;
                }
            }
            BlockPos pos = event.getPos();
            long worldTime = world.func_82737_E();
            if (fires.containsKey(posIdx)) {
                if (world.func_175623_d(pos) && world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150357_h && worldTime > fires.get(posIdx) && RANDOM.nextFloat() <= InfinityConfig.dropChance.get().floatValue()) {
                    MaterialCraftingHandler.spawnInfinityPowder(world, pos);
                }
                fires.remove(posIdx);
            } else if (event.getState().func_177230_c() instanceof BlockFire && world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150357_h) {
                if (fires.size() > 100) {
                    Iterator<Long> iterator = fires.values().iterator();
                    while (iterator.hasNext()) {
                        if (iterator.next() >= worldTime && fires.size() <= 500) continue;
                        iterator.remove();
                    }
                }
                fires.put(posIdx, worldTime + (long)InfinityConfig.fireMinAge.get().intValue());
            }
        }
    }

    public static void spawnInfinityPowder(@Nonnull World world, @Nonnull BlockPos pos) {
        double d0 = (double)(RANDOM.nextFloat() * 0.5f) + 0.25;
        double d1 = (double)(RANDOM.nextFloat() * 0.5f) + 0.25;
        double d2 = (double)(RANDOM.nextFloat() * 0.5f) + 0.25;
        EntityItem entityitem = new EntityItem(world, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, Material.POWDER_INFINITY.getStack(InfinityConfig.dropStackSize.get()));
        entityitem.func_174869_p();
        entityitem.func_70097_a(DamageSource.field_76372_a, -100.0f);
        entityitem.func_70015_d(10);
        world.func_72838_d((Entity)entityitem);
        if (InfinityConfig.makesSound.get().booleanValue()) {
            world.func_184133_a(null, pos, SoundEvents.field_187625_bm, SoundCategory.BLOCKS, 1.0f, RANDOM.nextFloat() * 0.4f + 0.8f);
        }
    }

    @SubscribeEvent
    public static void onWorldTick(@Nonnull TickEvent.WorldTickEvent event) {
        if (!fires.isEmpty() && !event.world.func_82736_K().func_82766_b("doFireTick") && InfinityConfig.inWorldCraftingEnabled.get().booleanValue() && (InfinityConfig.enableInAllDimensions.get().booleanValue() || event.world.field_73011_w.getDimension() == 0)) {
            int yOffset = event.world.field_73011_w.getDimension() * 256;
            long worldTime = event.world.func_82737_E();
            for (Map.Entry<BlockPos, Long> fire : fires.entrySet()) {
                BlockPos posIdx = fire.getKey();
                BlockPos pos = posIdx.func_177979_c(yOffset);
                if (pos.func_177956_o() < 0 || pos.func_177956_o() > 255 || worldTime <= fire.getValue()) continue;
                if (event.world.func_180495_p(pos).func_177230_c() instanceof BlockFire) {
                    event.world.func_175698_g(pos);
                } else {
                    fires.remove(posIdx);
                }
                return;
            }
        }
    }
}

