/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.machine.base.te;

import com.enderio.core.common.util.UserIdent;
import com.mojang.authlib.GameProfile;
import crazypants.enderio.api.redstone.IRedstoneConnectable;
import crazypants.enderio.base.TileEntityEio;
import crazypants.enderio.base.capability.ItemTools;
import crazypants.enderio.base.config.config.PersonalConfig;
import crazypants.enderio.base.diagnostics.Prof;
import crazypants.enderio.base.machine.interfaces.IIoConfigurable;
import crazypants.enderio.base.machine.interfaces.IMachine;
import crazypants.enderio.base.machine.interfaces.IRedstoneModeControlable;
import crazypants.enderio.base.machine.modes.IoMode;
import crazypants.enderio.base.machine.modes.RedstoneControlMode;
import crazypants.enderio.base.machine.sound.MachineSound;
import crazypants.enderio.base.paint.YetaUtil;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import info.loenwind.autosave.util.NBTAction;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Storable
public abstract class AbstractMachineEntity
extends TileEntityEio
implements IMachine,
IRedstoneModeControlable,
IRedstoneConnectable,
IIoConfigurable {
    @Nonnull
    private static final ItemTools.Limit PULL_PUSH_LIMIT = new ItemTools.Limit(1, 64);
    @Store(value={NBTAction.CLIENT, NBTAction.SAVE})
    @Nonnull
    public EnumFacing facing = EnumFacing.SOUTH;
    protected int ticksSinceSync = -1;
    protected boolean updateClients = false;
    protected boolean lastActive;
    protected int ticksSinceActiveChanged = 0;
    @Store
    @Nonnull
    protected RedstoneControlMode redstoneControlMode = RedstoneControlMode.IGNORE;
    @Store(value={NBTAction.CLIENT, NBTAction.SAVE})
    protected boolean redstoneCheckPassed;
    private boolean redstoneStateDirty = true;
    @Store
    protected EnumMap<EnumFacing, IoMode> faceModes;
    protected boolean notifyNeighbours = false;
    @SideOnly(value=Side.CLIENT)
    private MachineSound sound;
    @Store(value={NBTAction.SAVE})
    @Nullable
    private UserIdent owner;

    @Override
    @Nonnull
    public IoMode toggleIoModeForFace(@Nullable EnumFacing faceHit) {
        IoMode curMode = this.getIoMode(faceHit);
        IoMode mode = curMode.next();
        while (!this.supportsMode(faceHit, mode)) {
            mode = mode.next();
        }
        this.setIoMode(faceHit, mode);
        return mode;
    }

    @Override
    public boolean supportsMode(@Nullable EnumFacing faceHit, @Nullable IoMode mode) {
        return true;
    }

    @Override
    public void setIoMode(@Nullable EnumFacing faceHit, @Nullable IoMode mode) {
        if (mode == IoMode.NONE && this.faceModes == null) {
            return;
        }
        if (this.faceModes == null) {
            this.faceModes = new EnumMap(EnumFacing.class);
        }
        if (this.faceModes.get(faceHit) != mode) {
            this.faceModes.put(faceHit, mode);
            this.notifyNeighbours = true;
            this.func_70296_d();
            this.updateBlock();
        }
    }

    @Override
    public void clearAllIoModes() {
        if (this.faceModes != null) {
            this.faceModes = null;
            this.notifyNeighbours = true;
            this.func_70296_d();
            this.updateBlock();
        }
    }

    @Override
    @Nonnull
    public IoMode getIoMode(@Nullable EnumFacing face) {
        if (this.faceModes == null) {
            return IoMode.NONE;
        }
        IoMode res = this.faceModes.get(face);
        if (res == null) {
            return IoMode.NONE;
        }
        return res;
    }

    @Override
    @Nonnull
    public RedstoneControlMode getRedstoneControlMode() {
        return this.redstoneControlMode;
    }

    @Override
    public void setRedstoneControlMode(@Nonnull RedstoneControlMode redstoneControlMode) {
        this.redstoneControlMode = redstoneControlMode;
        this.redstoneStateDirty = true;
        this.func_70296_d();
    }

    @Nonnull
    public EnumFacing getFacing() {
        return this.facing;
    }

    public void setFacing(@Nonnull EnumFacing facing) {
        this.facing = facing;
        this.func_70296_d();
    }

    public abstract boolean isActive();

    @Nullable
    public ResourceLocation getSound() {
        return null;
    }

    public boolean hasSound() {
        return this.getSound() != null;
    }

    public float getVolume() {
        return PersonalConfig.machineSoundsVolume.get().floatValue();
    }

    public float getPitch() {
        return 1.0f;
    }

    protected boolean shouldPlaySound() {
        return this.isActive() && !this.func_145837_r();
    }

    @SideOnly(value=Side.CLIENT)
    private void updateSound() {
        if (PersonalConfig.machineSoundsEnabled.get().booleanValue() && this.hasSound()) {
            ResourceLocation soundRL = this.getSound();
            if (this.shouldPlaySound() && soundRL != null) {
                if (this.sound == null) {
                    this.sound = new MachineSound(soundRL, (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 0.5f, (float)this.field_174879_c.func_177952_p() + 0.5f, this.getVolume(), this.getPitch());
                    FMLClientHandler.instance().getClient().func_147118_V().func_147682_a((ISound)this.sound);
                }
            } else if (this.sound != null) {
                this.sound.endPlaying();
                this.sound = null;
            }
        }
    }

    @Override
    public void doUpdate() {
        if (this.field_145850_b.field_72995_K) {
            Prof.start((IBlockAccess)this.func_145831_w(), "clientTick");
            this.updateEntityClient();
            Prof.stop((IBlockAccess)this.func_145831_w());
        } else {
            Prof.start((IBlockAccess)this.func_145831_w(), "redstoneCheck");
            if (this.redstoneStateDirty) {
                boolean prevRedCheck = this.redstoneCheckPassed;
                this.redstoneCheckPassed = RedstoneControlMode.isConditionMet(this.redstoneControlMode, (TileEntity)this);
                this.redstoneStateDirty = false;
                this.updateClients |= prevRedCheck != this.redstoneCheckPassed;
            }
            if (this.shouldDoWorkThisTick(5)) {
                Prof.next((IBlockAccess)this.func_145831_w(), "sideIO");
                this.doSideIo();
            }
            Prof.next((IBlockAccess)this.func_145831_w(), "tasks");
            this.updateClients |= this.processTasks(this.redstoneCheckPassed);
            if (this.updateClients) {
                Prof.next((IBlockAccess)this.func_145831_w(), "clientNotification");
                this.forceUpdatePlayers();
                this.func_70296_d();
                this.updateClients = false;
            }
            if (this.notifyNeighbours) {
                Prof.next((IBlockAccess)this.func_145831_w(), "neighborNotification");
                this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), false);
                this.notifyNeighbours = false;
            }
            Prof.stop((IBlockAccess)this.func_145831_w());
        }
    }

    protected void updateEntityClient() {
        if (this.isActive() != this.lastActive) {
            ++this.ticksSinceActiveChanged;
            if (this.lastActive ? this.ticksSinceActiveChanged > 20 : this.ticksSinceActiveChanged > 4) {
                this.ticksSinceActiveChanged = 0;
                this.lastActive = this.isActive();
                this.updateBlock();
            }
        } else {
            this.ticksSinceActiveChanged = 0;
        }
        if (this.hasSound()) {
            this.updateSound();
        }
        YetaUtil.refresh((TileEntity)this);
    }

    protected final void doSideIo() {
        if (this.faceModes == null) {
            return;
        }
        Set<Map.Entry<EnumFacing, IoMode>> ents = this.faceModes.entrySet();
        for (Map.Entry<EnumFacing, IoMode> ent : ents) {
            boolean done;
            IoMode mode = ent.getValue();
            if (mode.pulls()) {
                Prof.start((IBlockAccess)this.func_145831_w(), "pull");
                done = this.doPull(ent.getKey());
                Prof.stop((IBlockAccess)this.func_145831_w());
                if (done) {
                    return;
                }
            }
            if (!mode.pushes()) continue;
            Prof.start((IBlockAccess)this.func_145831_w(), "push");
            done = this.doPush(ent.getKey());
            Prof.stop((IBlockAccess)this.func_145831_w());
            if (!done) continue;
            return;
        }
    }

    protected abstract boolean doPull(EnumFacing var1);

    protected abstract boolean doPush(EnumFacing var1);

    @Nonnull
    protected ItemTools.Limit getPullLimit() {
        return PULL_PUSH_LIMIT.copy();
    }

    @Nonnull
    protected ItemTools.Limit getPushLimit() {
        return PULL_PUSH_LIMIT.copy();
    }

    protected abstract boolean processTasks(boolean var1);

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K) {
            this.updateSound();
        }
    }

    public boolean isSideDisabled(EnumFacing dir) {
        return this.getIoMode(dir) == IoMode.DISABLED;
    }

    public void onNeighborBlockChange(@Nonnull IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos posIn, @Nonnull Block blockIn, @Nonnull BlockPos fromPos) {
        this.redstoneStateDirty = true;
    }

    @Override
    public boolean shouldRedstoneConduitConnect(@Nonnull World worldIn, @Nonnull BlockPos posIn, @Nonnull EnumFacing from) {
        return true;
    }

    @Override
    @Nonnull
    public BlockPos getLocation() {
        return this.func_174877_v();
    }

    @Override
    public boolean getRedstoneControlStatus() {
        return this.redstoneCheckPassed;
    }

    public void setOwner(@Nonnull EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K) {
            this.owner = UserIdent.create((GameProfile)player.func_146103_bH());
        }
    }

    @Nonnull
    public UserIdent getOwner() {
        return this.owner != null ? this.owner : UserIdent.NOBODY;
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return this.func_145838_q().func_149739_a();
    }
}

