/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.StaxFactory;
import crazypants.enderio.base.config.recipes.xml.AbstractCrafting;
import crazypants.enderio.base.config.recipes.xml.Item;
import crazypants.enderio.base.recipe.IRecipeInput;
import crazypants.enderio.base.recipe.Recipe;
import crazypants.enderio.base.recipe.RecipeBonusType;
import crazypants.enderio.base.recipe.RecipeOutput;
import crazypants.enderio.base.recipe.ThingsRecipeInput;
import crazypants.enderio.base.recipe.slicensplice.SliceAndSpliceRecipeManager;
import javax.annotation.Nonnull;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public class Slicing
extends AbstractCrafting {
    private int energy;
    private NNList<Item> inputs = new NNList();

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        try {
            super.readResolve();
            if (this.inputs.size() != 6) {
                throw new InvalidRecipeConfigException("Wrong number of <input>");
            }
            if (this.energy < 0) {
                throw new InvalidRecipeConfigException("Invalid negative value for 'energy'");
            }
            for (Item input : this.inputs) {
                this.valid = this.valid && input.isValid();
            }
        }
        catch (InvalidRecipeConfigException e) {
            throw new InvalidRecipeConfigException(e, "in <slicing>");
        }
        return this;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        super.enforceValidity();
        for (Item input : this.inputs) {
            input.enforceValidity();
        }
    }

    @Override
    public void register(@Nonnull String recipeName) {
        if (this.isValid() && this.isActive()) {
            NNList inputStacks = new NNList();
            NNList.NNIterator itr = this.inputs.fastIterator();
            while (itr.hasNext()) {
                Item item = (Item)itr.next();
                inputStacks.add((Object)new ThingsRecipeInput(item.getThing(), inputStacks.size()));
            }
            RecipeOutput recipeOutput = new RecipeOutput(this.getOutput().getItemStack());
            SliceAndSpliceRecipeManager.getInstance().addRecipe(new Recipe(recipeOutput, this.energy, RecipeBonusType.NONE, (IRecipeInput[])inputStacks.toArray((Object[])new IRecipeInput[inputStacks.size()])));
        }
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        if ("energy".equals(name)) {
            this.energy = Integer.parseInt(value);
            return true;
        }
        return super.setAttribute(factory, name, value);
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        if ("input".equals(name)) {
            this.inputs.add(factory.read(new Item().setAllowDelaying(false), startElement));
            return true;
        }
        return super.setElement(factory, name, startElement);
    }
}

