/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.factory;

import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.config.factory.ByteBufHelper;
import crazypants.enderio.base.config.factory.IValue;
import crazypants.enderio.base.config.factory.IValueFactory;
import crazypants.enderio.base.lang.Lang;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractValue<T>
implements IValue<T> {
    @Nonnull
    protected final IValueFactory owner;
    protected int valueGeneration = 0;
    @Nonnull
    protected final String section;
    @Nonnull
    protected final String keyname;
    @Nonnull
    private final String text;
    @Nonnull
    protected final T defaultValue;
    @Nullable
    protected T value = null;
    protected Double minValue;
    protected Double maxValue;
    private boolean isSynced = false;
    protected boolean isStartup = false;

    protected AbstractValue(@Nonnull IValueFactory owner, @Nonnull String section, @Nonnull String keyname, @Nonnull T defaultValue, @Nonnull String text) {
        this.owner = owner;
        this.section = section;
        this.keyname = keyname;
        this.text = text;
        this.defaultValue = defaultValue;
    }

    @Override
    @Nonnull
    public T get() {
        if (this.value == null || this.valueGeneration != this.owner.getGeneration()) {
            if (this.owner.getServerConfig() != null && this.owner.getServerConfig().containsKey(this.keyname)) {
                try {
                    this.value = this.owner.getServerConfig().get(this.keyname);
                }
                catch (ClassCastException e) {
                    Log.error("Server config value " + this.keyname + " is invalid");
                    this.value = null;
                }
            } else {
                this.value = this.makeValue();
                if (!this.owner.isInInit() && this.owner.getConfig().hasChanged()) {
                    this.owner.getConfig().save();
                }
            }
            this.valueGeneration = this.owner.getGeneration();
        }
        return (T)NullHelper.first((Object[])new Object[]{this.value, this.defaultValue});
    }

    @Nullable
    protected abstract T makeValue();

    @Override
    @Nonnull
    public IValue<T> setMin(double min) {
        this.minValue = min;
        return this;
    }

    @Override
    @Nonnull
    public IValue<T> setMax(double max) {
        this.maxValue = max;
        return this;
    }

    @Override
    @Nonnull
    public IValue<T> sync() {
        if (!this.isSynced) {
            this.isSynced = true;
            this.owner.addSyncValue(this);
        }
        return this;
    }

    @Override
    @Nonnull
    public IValue<T> startup() {
        this.isStartup = true;
        return this.sync();
    }

    @SideOnly(value=Side.CLIENT)
    public void onServerSync(@Nonnull Map<String, Object> serverConfig) {
        if (this.isStartup && serverConfig.containsKey(this.keyname)) {
            Object serverValue = serverConfig.get(this.keyname);
            T clientValue = this.get();
            if (!clientValue.equals(serverValue)) {
                Log.error(Lang.NETWORK_BAD_CONFIG.get(this.section, this.keyname, serverValue));
                Minecraft.func_71410_x().field_71439_g.field_71174_a.func_147298_b().func_150718_a((ITextComponent)Lang.NETWORK_BAD_CONFIG.toChatServer(this.section, this.keyname, serverValue));
            }
        }
    }

    @Nonnull
    public IValue<T> preload() {
        this.owner.addPreloadValue(this);
        return this;
    }

    public void save(ByteBuf buf) {
        ByteBufHelper.STRING127.saveValue(buf, this.keyname);
        ByteBufHelper dataType = this.getDataType();
        buf.writeByte(dataType.ordinal());
        dataType.saveValue(buf, this.get());
    }

    protected abstract ByteBufHelper getDataType();

    protected String getText() {
        return this.text + (this.isStartup ? " (must be kept in sync with server)" : (this.isSynced ? " (synced from server)" : ""));
    }
}

